/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.operation;

import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.matrix.ColumnMajorSparseMatrix;
import org.la4j.matrix.DenseMatrix;
import org.la4j.matrix.RowMajorSparseMatrix;
import org.la4j.operation.VectorOperation;
import org.la4j.vector.DenseVector;
import org.la4j.vector.SparseVector;

public abstract class MatrixVectorOperation<R> {
    public abstract R apply(DenseMatrix var1, DenseVector var2);

    public abstract R apply(DenseMatrix var1, SparseVector var2);

    public abstract R apply(RowMajorSparseMatrix var1, DenseVector var2);

    public abstract R apply(RowMajorSparseMatrix var1, SparseVector var2);

    public abstract R apply(ColumnMajorSparseMatrix var1, DenseVector var2);

    public abstract R apply(ColumnMajorSparseMatrix var1, SparseVector var2);

    public void ensureApplicableTo(Matrix a, Vector b) {
    }

    public VectorOperation<R> partiallyApply(final DenseMatrix a) {
        return new VectorOperation<R>(){

            @Override
            public R apply(SparseVector b) {
                return MatrixVectorOperation.this.apply(a, b);
            }

            @Override
            public R apply(DenseVector b) {
                return MatrixVectorOperation.this.apply(a, b);
            }

            @Override
            public void ensureApplicableTo(Vector b) {
                MatrixVectorOperation.this.ensureApplicableTo(a, b);
            }
        };
    }

    public VectorOperation<R> partiallyApply(final RowMajorSparseMatrix a) {
        return new VectorOperation<R>(){

            @Override
            public R apply(SparseVector b) {
                return MatrixVectorOperation.this.apply(a, b);
            }

            @Override
            public R apply(DenseVector b) {
                return MatrixVectorOperation.this.apply(a, b);
            }

            @Override
            public void ensureApplicableTo(Vector b) {
                MatrixVectorOperation.this.ensureApplicableTo(a, b);
            }
        };
    }

    public VectorOperation<R> partiallyApply(final ColumnMajorSparseMatrix a) {
        return new VectorOperation<R>(){

            @Override
            public R apply(SparseVector b) {
                return MatrixVectorOperation.this.apply(a, b);
            }

            @Override
            public R apply(DenseVector b) {
                return MatrixVectorOperation.this.apply(a, b);
            }

            @Override
            public void ensureApplicableTo(Vector b) {
                MatrixVectorOperation.this.ensureApplicableTo(a, b);
            }
        };
    }
}

