/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.operation.inplace;

import org.la4j.Matrix;
import org.la4j.iterator.MatrixIterator;
import org.la4j.matrix.ColumnMajorSparseMatrix;
import org.la4j.matrix.DenseMatrix;
import org.la4j.matrix.RowMajorSparseMatrix;
import org.la4j.matrix.SparseMatrix;
import org.la4j.operation.SimpleMatrixMatrixOperation;

public class InPlaceCopyMatrixToMatrix
extends SimpleMatrixMatrixOperation<Matrix> {
    @Override
    public Matrix applySimple(DenseMatrix a, SparseMatrix b) {
        MatrixIterator it = b.iterator();
        while (it.hasNext()) {
            int j;
            it.next();
            int i = it.rowIndex();
            double x = a.get(i, j = it.columnIndex());
            if (x == 0.0) continue;
            it.set(x);
        }
        return b;
    }

    @Override
    public Matrix applySimple(SparseMatrix a, DenseMatrix b) {
        return this.fromSparseToMatrix(a, b);
    }

    @Override
    public Matrix applySimple(SparseMatrix a, SparseMatrix b) {
        return this.fromSparseToMatrix(a, b);
    }

    @Override
    public Matrix apply(DenseMatrix a, DenseMatrix b) {
        for (int i = 0; i < a.rows(); ++i) {
            for (int j = 0; j < a.columns(); ++j) {
                b.set(i, j, a.get(i, j));
            }
        }
        return b;
    }

    @Override
    public Matrix apply(RowMajorSparseMatrix a, ColumnMajorSparseMatrix b) {
        return this.fromSparseToMatrix(a, b);
    }

    @Override
    public Matrix apply(ColumnMajorSparseMatrix a, RowMajorSparseMatrix b) {
        return this.fromSparseToMatrix(a, b);
    }

    private Matrix fromSparseToMatrix(SparseMatrix a, Matrix b) {
        MatrixIterator it = a.nonZeroIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            b.set(i, j, x);
        }
        return b;
    }
}

