/*
 * Decompiled with CFR 0.152.
 */
package florent;

import java.util.ArrayList;
import java.util.ListIterator;
import robocode.util.Utils;

public class GunManager {
    private static final int DEPTH = 30;
    private static final int HIT_DEPTH = 200;
    private static final int BIAS_DEPTH = 1000;
    private ArrayList errors = new ArrayList();
    private double hitRate = 0.0;
    private double error = 0.0;
    private double bias;
    private int arrived = 0;
    private String name;

    public GunManager(Object object, String name) {
        this.name = String.valueOf(object.getClass().getName()) + ":" + name;
    }

    public void fire(double angle, double time, int round, double distance) {
        this.errors.add(new ShotRecord(angle, time, round, distance));
    }

    public void arrived(double angle, double time, int round) {
        int index = this.errors.indexOf(new ShotRecord(0.0, time, round, 0.0));
        if (index < 0 && index > this.errors.size() - 1) {
            System.out.println("GunManager: " + this.name + " shot not found " + time + " index" + index);
        } else {
            ++this.arrived;
            double lastError = ((ShotRecord)this.errors.get(index)).arrived(angle);
            this.error = (this.error * (double)Math.min(this.arrived - 1, 29) + Math.abs(lastError)) / (double)Math.min(this.arrived, 30);
            this.hitRate = 0.0;
            int i = this.errors.size() - 1;
            while (i > Math.max(this.errors.size() - 200, -1)) {
                this.hitRate += ((ShotRecord)this.errors.get(i)).isHit() ? 1.0 : 0.0;
                --i;
            }
            this.hitRate /= 1.0 * (double)Math.min(this.arrived, 200);
            this.bias = (this.bias * (double)Math.min(this.arrived - 1, 999) + lastError) / (double)Math.min(this.arrived, 1000);
        }
    }

    public double overallHitRate() {
        double overallHitRate = 0.0;
        ListIterator it = this.errors.listIterator();
        while (it.hasNext()) {
            overallHitRate += ((ShotRecord)it.next()).isHit() ? 1.0 : 0.0;
        }
        return overallHitRate / (double)this.errors.size();
    }

    public String getName() {
        return this.name;
    }

    public double getHitRate() {
        return this.hitRate;
    }

    public double getBias() {
        return this.bias;
    }

    public double getError() {
        return this.error;
    }

    private class ShotRecord {
        private double time;
        private int round;
        private double angle;
        private double distance;
        private double error;
        private boolean hit = false;

        public ShotRecord(double angle, double time, int round, double distance) {
            this.time = time;
            this.angle = angle;
            this.round = round;
            this.distance = distance;
        }

        public double arrived(double angle) {
            this.error = Math.pow(Utils.normalRelativeAngle((double)(this.angle - angle)), 2.0);
            if (Math.abs(Math.tan(Utils.normalRelativeAngle((double)(this.angle - angle)))) < Math.atan(20.0 / this.distance)) {
                this.hit = true;
            }
            return this.error;
        }

        public boolean equals(Object arg0) {
            try {
                return ((ShotRecord)arg0).round == this.round && ((ShotRecord)arg0).time == this.time;
            }
            catch (Exception e) {
                return false;
            }
        }

        public int hashCode() {
            return (int)((double)(1000 * this.round) + this.time);
        }

        public double getError() {
            return this.error;
        }

        public boolean isHit() {
            return this.hit;
        }
    }
}

