/*
 * Decompiled with CFR 0.152.
 */
package florent;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import robocode.AdvancedRobot;

public class PUtils {
    public static final double MAX_ROBOT_VELOCITY = 8.0;
    public static final double BOT_WIDTH = 36.0;

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public static int sign(double v) {
        return v < 0.0 ? -1 : 1;
    }

    public static double minMax(double v, double min, double max) {
        return Math.max(min, Math.min(max, v));
    }

    public static double maxEscapeAngle(double bulletVelocity) {
        return Math.asin(8.0 / bulletVelocity);
    }

    public static Rectangle2D fieldRectangle(AdvancedRobot robot, double margin) {
        return new Rectangle2D.Double(margin, margin, robot.getBattleFieldWidth() - margin * 2.0, robot.getBattleFieldHeight() - margin * 2.0);
    }

    public static double bulletVelocity(double bulletPower) {
        return 20.0 - 3.0 * bulletPower;
    }

    public static int getVelocityIndex(double velocity) {
        if ((velocity = Math.abs(velocity)) > 7.5) {
            return 4;
        }
        if (velocity > 5.0) {
            return 3;
        }
        if (velocity > 2.5) {
            return 2;
        }
        if (velocity > 0.0) {
            return 1;
        }
        return 0;
    }

    public static double rollingAvg(double value, double newEntry, double n) {
        return (value * n + newEntry) / (n + 1.0);
    }

    public static double backAsFrontTurn(double newHeading, double oldHeading) {
        return Math.tan(newHeading - oldHeading);
    }

    public static double backAsFrontDirection(double newHeading, double oldHeading) {
        return PUtils.sign(Math.cos(newHeading - oldHeading));
    }

    public static String formatNumber(double num) {
        return NumberFormat.getNumberInstance().format(num);
    }
}

