/*
 * Decompiled with CFR 0.152.
 */
package mladjo;

import Targeting.TargetingStuff;
import Targeting.TargetingWave;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class iRobot
extends AdvancedRobot {
    public static int BINS = 47;
    public static double[] surfStats = new double[BINS];
    public Point2D.Double myLocation;
    public Point2D.Double enemyLocation;
    public ArrayList enemyWaves;
    public ArrayList surfDirections;
    public ArrayList surfAbsBearings;
    private static final double bulletPOWER = 2.0;
    private int timeSinceLastScan = 10;
    static double enemyAbsoluteBearing;
    private static double lateralDirection;
    private static double lastEnemyVelocity;
    public static double oppEnergy;
    public Rectangle2D.Double fieldRect;
    public static double wallStick;

    static {
        oppEnergy = 100.0;
        wallStick = 160.0;
    }

    public void run() {
        this.enemyWaves = new ArrayList();
        this.surfDirections = new ArrayList();
        this.surfAbsBearings = new ArrayList();
        this.fieldRect = new Rectangle2D.Double(18.0, 18.0, this.getBattleFieldWidth() - 36.0, this.getBattleFieldHeight() - 36.0);
        lateralDirection = 1.0;
        lastEnemyVelocity = 0.0;
        this.setBodyColor(Color.black);
        this.setGunColor(Color.black);
        this.setScanColor(Color.white);
        this.setRadarColor(Color.black);
        this.setBulletColor(Color.red);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.doScanner();
            this.execute();
        }
    }

    public void doScanner() {
        ++this.timeSinceLastScan;
        double radarOffset = Double.POSITIVE_INFINITY;
        if (this.timeSinceLastScan < 3) {
            radarOffset = Utils.normalRelativeAngle((double)(this.getRadarHeadingRadians() - enemyAbsoluteBearing));
            radarOffset += (double)this.sign(radarOffset) * 0.05;
        }
        this.setTurnRadarLeftRadians(radarOffset);
    }

    int sign(double v) {
        return v > 0.0 ? 1 : -1;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.myLocation = new Point2D.Double(this.getX(), this.getY());
        double lateralVelocity = this.getVelocity() * Math.sin(e.getBearingRadians());
        double absBearing = e.getBearingRadians() + this.getHeadingRadians();
        enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        this.timeSinceLastScan = 0;
        this.surfDirections.add(0, new Integer(lateralVelocity >= 0.0 ? 1 : -1));
        this.surfAbsBearings.add(0, new Double(absBearing + Math.PI));
        double bulletPower = oppEnergy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09 && this.surfDirections.size() > 2) {
            HostileWave bulletWave = new HostileWave();
            bulletWave.fireTime = this.getTime() - 1L;
            bulletWave.bulletVelocity = iRobot.bulletVelocity(bulletPower);
            bulletWave.distanceTraveled = iRobot.bulletVelocity(bulletPower);
            bulletWave.direction = (Integer)this.surfDirections.get(2);
            bulletWave.directAngle = (Double)this.surfAbsBearings.get(2);
            bulletWave.fireLocation = (Point2D.Double)this.enemyLocation.clone();
            this.enemyWaves.add(bulletWave);
        }
        oppEnergy = e.getEnergy();
        this.enemyLocation = iRobot.project(this.myLocation, absBearing, e.getDistance());
        this.updateWaves();
        this.doSurfing();
        double enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double enemyDistance = e.getDistance();
        double enemyVelocity = e.getVelocity();
        if (enemyVelocity != 0.0) {
            lateralDirection = TargetingStuff.sign(enemyVelocity * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing));
        }
        TargetingWave wave = new TargetingWave(this);
        wave.gunLocation = new Point2D.Double(this.getX(), this.getY());
        TargetingWave.targetLocation = TargetingStuff.project(wave.gunLocation, enemyAbsoluteBearing, enemyDistance);
        wave.lateralDirection = lateralDirection;
        wave.bulletPower = 2.0;
        wave.setSegmentations(enemyDistance, enemyVelocity, lastEnemyVelocity);
        lastEnemyVelocity = enemyVelocity;
        wave.bearing = enemyAbsoluteBearing;
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.getGunHeadingRadians() + wave.mostVisitedBearingOffset())));
        this.setFire(wave.bulletPower);
        if (this.getEnergy() >= 2.0) {
            this.addCustomEvent(wave);
        }
    }

    public void updateWaves() {
        int x = 0;
        while (x < this.enemyWaves.size()) {
            HostileWave ew = (HostileWave)this.enemyWaves.get(x);
            ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled > this.myLocation.distance(ew.fireLocation) + 50.0) {
                this.enemyWaves.remove(x);
                --x;
            }
            ++x;
        }
    }

    public HostileWave getClosestSurfableWave() {
        double closestDistance = Double.POSITIVE_INFINITY;
        HostileWave surfWave = null;
        int x = 0;
        while (x < this.enemyWaves.size()) {
            HostileWave ew = (HostileWave)this.enemyWaves.get(x);
            double distance = this.myLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            if (distance > ew.bulletVelocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public static int getFactorIndex(HostileWave ew, Point2D.Double targetLocation) {
        double offsetAngle = iRobot.absoluteBearing(ew.fireLocation, targetLocation) - ew.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / iRobot.maxEscapeAngle(ew.bulletVelocity) * (double)ew.direction;
        return (int)iRobot.limit(0.0, factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    public void logHit(HostileWave ew, Point2D.Double targetLocation) {
        int index = iRobot.getFactorIndex(ew, targetLocation);
        int x = 0;
        while (x < BINS) {
            int n = x;
            surfStats[n] = surfStats[n] + 1.0 / (Math.pow(index - x, 2.0) + 1.0);
            ++x;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (!this.enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            HostileWave hitWave = null;
            int x = 0;
            while (x < this.enemyWaves.size()) {
                HostileWave ew = (HostileWave)this.enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled - this.myLocation.distance(ew.fireLocation)) < 50.0 && Math.round(iRobot.bulletVelocity(e.getBullet().getPower()) * 10.0) == Math.round(ew.bulletVelocity * 10.0)) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this.enemyWaves.remove(this.enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public void onWin(WinEvent e) {
        int i = 0;
        while (i < 200) {
            Color robotColor = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
            Color gunColor = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
            Color radarColor = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
            this.setColors(robotColor, gunColor, radarColor);
            this.setTurnGunRight(Double.POSITIVE_INFINITY);
            this.setTurnLeft(Double.POSITIVE_INFINITY);
            this.execute();
            ++i;
        }
    }

    public Point2D.Double predictPosition(HostileWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)this.myLocation.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = this.wallSmoothing(predictedPosition, iRobot.absoluteBearing(surfWave.fireLocation, predictedPosition) + (double)direction * 1.5707963267948966, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + iRobot.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = iRobot.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = iRobot.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation) < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity + surfWave.bulletVelocity)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    public double checkDanger(HostileWave surfWave, int direction) {
        int index = iRobot.getFactorIndex(surfWave, this.predictPosition(surfWave, direction));
        return surfStats[index];
    }

    public void doSurfing() {
        HostileWave surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            return;
        }
        double dangerLeft = this.checkDanger(surfWave, -1);
        double dangerRight = this.checkDanger(surfWave, 1);
        double goAngle = iRobot.absoluteBearing(surfWave.fireLocation, this.myLocation);
        goAngle = dangerLeft < dangerRight ? this.wallSmoothing(this.myLocation, goAngle - 1.5707963267948966, -1) : this.wallSmoothing(this.myLocation, goAngle + 1.5707963267948966, 1);
        iRobot.setBackAsFront(this, goAngle);
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!this.fieldRect.contains(iRobot.project(botLocation, angle, 160.0))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    class HostileWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity;
        double directAngle;
        double distanceTraveled;
        int direction;
    }
}

