/*
 * Decompiled with CFR 0.152.
 */
package kronenthaler;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import kronenthaler.common.MyAdvancedRobot;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Basilisk
extends MyAdvancedRobot {
    public static int BINS = 47;
    public static double[] stats = new double[BINS];
    public int direction = 1;
    public Point2D.Double myLocation;
    public Point2D.Double enemyLocation;
    public ArrayList<EnemyWave> enemyWaves;
    public ArrayList<WaveBullet> waves;
    public ArrayList<Integer> surfDirections;
    public ArrayList<Double> surfAbsBearings;
    public static double oppEnergy = 100.0;
    public int ticks = 10;
    public static Rectangle2D.Double _fieldRect = new Rectangle2D.Double(18.0, 18.0, 770.0, 570.0);
    public static double WALL_STICK = 160.0;

    public void run() {
        this.enemyWaves = new ArrayList();
        this.surfDirections = new ArrayList();
        this.surfAbsBearings = new ArrayList();
        this.waves = new ArrayList();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.myLocation = new Point2D.Double(this.getX(), this.getY());
        double lateralVelocity = this.getVelocity() * Math.sin(e.getBearingRadians());
        double absBearing = e.getBearingRadians() + this.getHeadingRadians();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())) * 2.0);
        this.surfDirections.add(0, lateralVelocity >= 0.0 ? 1 : -1);
        this.surfAbsBearings.add(0, absBearing + Math.PI);
        double bulletPower = oppEnergy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09 && this.surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = this.getTime() - 1L;
            ew.bulletVelocity = Basilisk.bulletVelocity(bulletPower);
            ew.distanceTraveled = Basilisk.bulletVelocity(bulletPower);
            ew.direction = this.surfDirections.get(2);
            ew.directAngle = this.surfAbsBearings.get(2);
            ew.fireLocation = (Point2D.Double)this.enemyLocation.clone();
            this.enemyWaves.add(ew);
        }
        oppEnergy = e.getEnergy();
        this.enemyLocation = Basilisk.project(this.myLocation, absBearing, e.getDistance());
        this.updateWaves();
        this.doSurfing();
        for (WaveBullet currentWave : this.waves) {
            if (!currentWave.checkHit(this.enemyLocation.x, this.enemyLocation.y, this.getTime())) continue;
            this.waves.remove(currentWave);
        }
        double myX = this.getX();
        double myY = this.getY();
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double enemyX = this.getX() + e.getDistance() * Math.sin(absoluteBearing);
        double enemyY = this.getY() + e.getDistance() * Math.cos(absoluteBearing);
        double enemyHeading = e.getHeadingRadians();
        double enemyVelocity = e.getVelocity();
        double t = Point2D.Double.distance(myX, myY, enemyX, enemyY) / 600.0;
        bulletPower = 0.1 * t + 3.0 * (1.0 - t);
        if (this.getEnergy() < 15.0) {
            bulletPower = 0.1;
        }
        if ((this.getEnergy() > 15.0 || this.getEnergy() <= 15.0 && this.ticks == 0) && (e.getEnergy() > 5.0 || this.ticks == 0)) {
            this.linearTargeting(myX, myY, bulletPower, enemyX, enemyY, enemyHeading, enemyVelocity);
            this.ticks = 50;
        }
        --this.ticks;
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (!this.enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            for (int x = 0; x < this.enemyWaves.size(); ++x) {
                EnemyWave ew = this.enemyWaves.get(x);
                if (!(Math.abs(ew.distanceTraveled - this.myLocation.distance(ew.fireLocation)) < 50.0) || !(Math.abs(Basilisk.bulletVelocity(e.getBullet().getPower()) - ew.bulletVelocity) < 0.001)) continue;
                hitWave = ew;
                break;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this.enemyWaves.remove(this.enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (!this.enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            for (int x = 0; x < this.enemyWaves.size(); ++x) {
                EnemyWave ew = this.enemyWaves.get(x);
                if (!(Math.abs(ew.distanceTraveled - this.myLocation.distance(ew.fireLocation)) < 50.0) || !(Math.abs(Basilisk.bulletVelocity(e.getBullet().getPower()) - ew.bulletVelocity) < 0.001)) continue;
                hitWave = ew;
                break;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this.enemyWaves.remove(this.enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public void updateWaves() {
        for (int x = 0; x < this.enemyWaves.size(); ++x) {
            EnemyWave ew = this.enemyWaves.get(x);
            ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletVelocity;
            if (!(ew.distanceTraveled > this.myLocation.distance(ew.fireLocation) + 50.0)) continue;
            this.enemyWaves.remove(x);
            --x;
        }
    }

    public EnemyWave getClosestSurfableWave() {
        double closestDistance = 2.147483647E9;
        EnemyWave surfWave = null;
        for (int x = 0; x < this.enemyWaves.size(); ++x) {
            EnemyWave ew = this.enemyWaves.get(x);
            double distance = this.myLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            if (!(distance > ew.bulletVelocity) || !(distance < closestDistance)) continue;
            surfWave = ew;
            closestDistance = distance;
        }
        return surfWave;
    }

    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = Basilisk.absoluteBearing(ew.fireLocation, targetLocation) - ew.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / Basilisk.maxEscapeAngle(ew.bulletVelocity) * (double)ew.direction;
        return (int)Basilisk.limit(0.0, factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = Basilisk.getFactorIndex(ew, targetLocation);
        for (int x = 0; x < BINS; ++x) {
            int n = x;
            stats[n] = stats[n] + 1.0 / (Math.pow(index - x, 2.0) + 1.0);
        }
    }

    public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)this.myLocation.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = this.wallSmoothing(predictedPosition, Basilisk.absoluteBearing(surfWave.fireLocation, predictedPosition) + (double)direction * 1.5707963267948966, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + Basilisk.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = Basilisk.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = Basilisk.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation) < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity + surfWave.bulletVelocity)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    public double checkDanger(EnemyWave surfWave, int direction) {
        int index = Basilisk.getFactorIndex(surfWave, this.predictPosition(surfWave, direction));
        return stats[index];
    }

    public void doSurfing() {
        EnemyWave surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            return;
        }
        double dangerLeft = this.checkDanger(surfWave, -1);
        double dangerRight = this.checkDanger(surfWave, 1);
        double goAngle = Basilisk.absoluteBearing(surfWave.fireLocation, this.myLocation);
        goAngle = dangerLeft < dangerRight ? this.wallSmoothing(this.myLocation, goAngle - 1.5707963267948966, -1) : this.wallSmoothing(this.myLocation, goAngle + 1.5707963267948966, 1);
        Basilisk.setBackAsFront(this, goAngle);
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(Basilisk.project(botLocation, angle, WALL_STICK))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity;
        double directAngle;
        double distanceTraveled;
        int direction;
    }

    class WaveBullet {
        private double startX;
        private double startY;
        private double startBearing;
        private double power;
        private long fireTime;
        private int direction;
        private double[] returnSegment;

        public WaveBullet(double x, double y, double bearing, double power, int direction, long time, double[] segment) {
            this.startX = x;
            this.startY = y;
            this.startBearing = bearing;
            this.power = power;
            this.direction = direction;
            this.fireTime = time;
            this.returnSegment = segment;
        }

        public boolean checkHit(double enemyX, double enemyY, long currentTime) {
            if (Point2D.distance(this.startX, this.startY, enemyX, enemyY) <= (double)(currentTime - this.fireTime) * Basilisk.bulletVelocity(this.power)) {
                int index;
                double desiredDirection = Math.atan2(enemyX - this.startX, enemyY - this.startY);
                double angleOffset = Utils.normalRelativeAngle((double)(desiredDirection - this.startBearing));
                double guessFactor = Math.max(-1.0, Math.min(1.0, angleOffset / Basilisk.maxEscapeAngle(Basilisk.bulletVelocity(this.power)))) * (double)this.direction;
                int n = index = (int)Math.round((double)((this.returnSegment.length - 1) / 2) * (guessFactor + 1.0));
                this.returnSegment[n] = this.returnSegment[n] + 1.0;
                return true;
            }
            return false;
        }
    }
}

