/*
 * Decompiled with CFR 0.152.
 */
package apc.targeting;

import apc.utils.EmData;
import java.awt.geom.Point2D;
import robocode.util.Utils;

public class Circle {
    private double battleFieldHeight = 1200.0;
    private double battleFieldWidth = 1200.0;

    public Circle(double height, double width) {
        this.battleFieldHeight = height;
        this.battleFieldWidth = width;
    }

    public double targetBot(long currentTime, double gunHeading, double firePower, Point2D.Double myLocation, EmData bot, double heading) {
        Point2D.Double location = bot.location();
        double enemyHeading = bot.heading();
        double enemyHeadingChange = bot.changeInHeading();
        double enemyVelocity = bot.velocity();
        double deltaTime = 0.0;
        while ((deltaTime += 1.0) * (20.0 - 3.0 * firePower) < Point2D.Double.distance(myLocation.x, myLocation.y, location.x, location.y)) {
            location.x += Math.sin(enemyHeading) * enemyVelocity;
            location.y += Math.cos(enemyHeading) * enemyVelocity;
            enemyHeading += enemyHeadingChange;
            if (!(location.x < 18.0 || location.y < 18.0 || location.x > this.battleFieldWidth - 18.0) && !(location.y > this.battleFieldHeight - 18.0)) continue;
            location.x = Math.min(Math.max(18.0, location.x), this.battleFieldWidth - 18.0);
            location.y = Math.min(Math.max(18.0, location.y), this.battleFieldHeight - 18.0);
            break;
        }
        bot.setPrediction(location);
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(location.x - myLocation.x, location.y - myLocation.y));
        return theta;
    }
}

