/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.distributer;

import xander.core.drive.Direction;
import xander.gfws.FactorArrays;
import xander.gfws.distributer.WeightDistributer;

public class TriangleDistributer
implements WeightDistributer {
    private double wp = 1.0;

    public TriangleDistributer() {
    }

    public TriangleDistributer(double widthMultiplier) {
        this.wp = widthMultiplier;
    }

    @Override
    public double addWeight(double[] array, double preciseIndex, double weight, double distance, double bulletVelocity, Direction surfDirection) {
        double f1 = preciseIndex;
        double indexWidth = this.wp * FactorArrays.getPreciseFactorIndexRobotWidth(array.length, distance, bulletVelocity);
        double f0 = preciseIndex - indexWidth / 2.0;
        double d = f1 - f0;
        double f2 = f1 + d;
        double h = weight / d;
        double m0 = h / d;
        double m2 = -h / d;
        int si = (int)Math.round(Math.floor(f0));
        int ei = (int)Math.round(Math.floor(f2));
        int mi = (int)Math.round(Math.floor(f1));
        double b0 = -m0 * f0;
        double b2 = -m2 * f2;
        double rsum = 0.0;
        double vsum = 0.0;
        int i = si;
        while (i <= ei) {
            if (i != mi) {
                double x0 = Math.max(f0, (double)i);
                double x1 = Math.min((double)(i + 1), f2);
                double m = i < mi ? m0 : m2;
                double b = i < mi ? b0 : b2;
                double y0 = m * x0 + b;
                double y1 = m * x1 + b;
                double a = (y0 + y1) / 2.0 * (x1 - x0);
                double r = a / weight;
                if (i > 0 && i < array.length) {
                    int n = i;
                    array[n] = array[n] + r * weight;
                    vsum += r * weight;
                }
                rsum += r;
            }
            ++i;
        }
        if (mi >= 0 && mi < array.length) {
            int n = mi;
            array[n] = array[n] + (1.0 - Math.abs(rsum)) * weight;
            vsum += (1.0 - Math.abs(rsum)) * weight;
        }
        return vsum;
    }
}

