/*
 * Decompiled with CFR 0.152.
 */
package starpkg;

import java.util.ArrayList;
import java.util.ListIterator;
import starpkg.HelperTools;
import starpkg.Position;
import starpkg.StarViewerZ;

public class RadarCtrl {
    private StarViewerZ robot = null;
    private HelperTools tools = new HelperTools();
    public boolean roundScan = false;
    public ArrayList scannedName = new ArrayList();
    double turnAngle = 720.0;
    public int scanedEnemyNo = 0;
    public long reTurnTime = 0L;
    public long reTurnTimeCtrl = 0L;
    public boolean roundScanning = false;

    public RadarCtrl(StarViewerZ getInst) {
        this.robot = getInst;
    }

    public void SetRadar() {
        this.turnAngle = 720.0;
        if (this.roundScan) {
            this.roundScan = false;
        } else if (this.robot.status.totalEnemy <= 1) {
            if (this.robot.getTime() > 10L) {
                this.turnAngle = this.TargetSetRadar();
            }
            this.roundScanning = false;
        } else if (this.robot.status.totalEnemy > 1 && this.robot.getTime() > 10L) {
            this.SearchTotalScan();
        }
        this.robot.setTurnRadarRight(this.turnAngle);
    }

    public double TargetSetRadar() {
        double angle = 0.0;
        Position cPos = new Position(this.robot.getX(), this.robot.getY());
        if (this.robot.getTime() - this.robot.enemy.enemyMain.lastTime > 10L) {
            return 720.0;
        }
        double diffX = this.robot.enemy.enemyMain.pos.X - cPos.X;
        double diffY = this.robot.enemy.enemyMain.pos.Y - cPos.Y;
        angle = Math.toDegrees(Math.atan2(diffX, diffY));
        double targetAngle = this.robot.getRadarHeading() - angle;
        targetAngle = (targetAngle = this.tools.NormalAngle(targetAngle)) > 0.0 ? (this.robot.status.totalEnemy > 1 ? (targetAngle += 18.0) : (targetAngle += 20.0)) : (this.robot.status.totalEnemy > 1 ? (targetAngle -= 18.0) : (targetAngle -= 20.0));
        return targetAngle;
    }

    public void SearchTotalScan() {
        if (this.robot.getTime() - this.reTurnTime < this.reTurnTimeCtrl) {
            this.turnAngle = this.TargetSetRadar();
            this.roundScanning = false;
        }
    }

    public void OnScan(String cName) {
        if (this.robot.getTime() - this.reTurnTime > this.reTurnTimeCtrl) {
            this.roundScanning = true;
            this.reTurnTimeCtrl = 9L;
            String name = "";
            boolean add = true;
            ListIterator nameListItor = this.scannedName.listIterator(0);
            while (nameListItor.hasNext()) {
                name = (String)nameListItor.next();
                if (name != cName) continue;
                add = false;
                break;
            }
            if (add) {
                this.scannedName.add(cName);
                ++this.scanedEnemyNo;
            }
            if (this.scanedEnemyNo >= this.robot.status.totalEnemy) {
                this.turnAngle *= -1.0;
                this.scanedEnemyNo = 0;
                this.scannedName.clear();
                this.reTurnTime = this.robot.getTime();
            }
        }
    }
}

