/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp;

public class NetworkStringBuilder {
    private final StringBuilder builder = new StringBuilder();
    private int indentLevel;
    private final boolean activations;
    private final boolean responsibilities;
    private final boolean eligibilities;
    private final boolean learningRates;
    private final boolean name;
    private final boolean intermediate;
    private final boolean states;
    private final boolean weights;
    private final boolean extra;
    private final boolean connectivity;

    public NetworkStringBuilder(String show) {
        this.activations = show.contains("A") || show.contains("Y") || show.isEmpty();
        this.responsibilities = show.contains("R") || show.contains("D") || show.isEmpty();
        this.eligibilities = show.contains("E") || show.isEmpty();
        this.learningRates = show.contains("L") || show.isEmpty();
        this.name = show.contains("N") || show.isEmpty();
        this.intermediate = show.contains("I") || show.isEmpty();
        this.states = show.contains("S") || show.isEmpty();
        this.weights = show.contains("W") || show.isEmpty();
        this.extra = show.contains("X") || show.isEmpty();
        this.connectivity = show.contains("C") || show.isEmpty();
    }

    public void append(String s) {
        this.builder.append(s);
    }

    public void appendln() {
        this.builder.append("\n");
    }

    public void appendln(String s) {
        this.indent();
        this.builder.append(s.replaceAll("\n", "\n" + this.getIndent()));
        this.appendln();
    }

    public String getIndent() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.indentLevel; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }

    public void indent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.builder.append("  ");
        }
    }

    public void popIndent() {
        this.indentLevel = Math.max(0, this.indentLevel - 1);
    }

    public void pushIndent() {
        ++this.indentLevel;
    }

    public boolean showActivations() {
        return this.activations;
    }

    public boolean showConnectivity() {
        return this.connectivity;
    }

    public boolean showEligibilities() {
        return this.eligibilities;
    }

    public boolean showExtra() {
        return this.extra;
    }

    public boolean showIntermediate() {
        return this.intermediate;
    }

    public boolean showLearningRates() {
        return this.learningRates;
    }

    public boolean showName() {
        return this.name;
    }

    public boolean showResponsibilities() {
        return this.responsibilities;
    }

    public boolean showStates() {
        return this.states;
    }

    public boolean showWeights() {
        return this.weights;
    }

    public String toString() {
        return this.builder.toString();
    }
}

