/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.layer;

import dmonner.xlbp.Component;
import dmonner.xlbp.DownstreamComponent;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.Responsibilities;
import dmonner.xlbp.layer.AbstractDownstreamLayer;
import dmonner.xlbp.layer.CopySourceLayer;
import dmonner.xlbp.layer.DownstreamLayer;
import dmonner.xlbp.layer.InternalLayer;
import dmonner.xlbp.layer.UpstreamLayer;
import java.util.Arrays;

public abstract class AbstractFanOutLayer
extends AbstractDownstreamLayer
implements InternalLayer {
    private static final long serialVersionUID = 1L;
    protected DownstreamLayer[] downstream = new DownstreamLayer[0];
    protected int nDownstream = 0;
    protected int[] myIndexInDownstream = new int[0];
    protected Responsibilities[] dDownstream = new Responsibilities[0];
    protected CopySourceLayer downstreamCopyLayer;

    public AbstractFanOutLayer(AbstractFanOutLayer that, NetworkCopier copier) {
        super(that, copier);
    }

    public AbstractFanOutLayer(String name, int size) {
        super(name, size);
    }

    @Override
    public void addDownstream(DownstreamComponent downstream) {
        int index = this.nDownstream++;
        this.setDownstreamCapacity(this.nDownstream);
        this.downstream[index] = downstream.asDownstreamLayer();
        this.dDownstream[index] = new Responsibilities(this.size);
        this.connectDownstream(index);
        this.myIndexInDownstream[index] = downstream.indexOfUpstream(this);
    }

    @Override
    public void addDownstreamCopyLayer(CopySourceLayer copySource) {
        if (this.downstreamCopyLayer != copySource) {
            if (this.downstreamCopyLayer != null) {
                throw new IllegalStateException("Cannot add " + copySource + " as the downstream copy layer for " + this.name + " since " + this.downstreamCopyLayer + " already fills that role.");
            }
            this.downstreamCopyLayer = copySource;
        }
    }

    @Override
    public void aliasResponsibilities(int index, Responsibilities resp) {
        this.dDownstream[index] = resp;
    }

    @Override
    public UpstreamLayer asUpstreamLayer() {
        return this;
    }

    @Override
    public void build() {
        if (!this.built) {
            super.build();
            this.myIndexInDownstream = new int[this.nDownstream];
            for (int i = 0; i < this.nDownstream; ++i) {
                DownstreamLayer downstream = this.downstream[i];
                int index = downstream.indexOfUpstream(this);
                if (index < 0) {
                    throw new IllegalStateException(this.name + " is not in " + downstream.getName() + " layer's list of connected upstream layers.");
                }
                if (downstream.size() != this.size()) {
                    throw new IllegalStateException("Incompatible sizes between " + this.name + " (" + this.size() + ") and " + downstream.getName() + " (" + downstream.size() + ").");
                }
                this.myIndexInDownstream[i] = index;
            }
            this.built = true;
        }
    }

    @Override
    public void clearResponsibilities() {
        super.clearResponsibilities();
        for (int i = 0; i < this.nDownstream; ++i) {
            this.dDownstream[i].clear();
        }
    }

    protected void connectDownstream(int index) {
        DownstreamLayer downstream = this.downstream[index];
        if (!downstream.connectedUpstream(this)) {
            downstream.addUpstream(this);
        }
    }

    @Override
    public boolean connectedDownstream(DownstreamComponent downstream) {
        return this.indexOfDownstream(downstream) >= 0;
    }

    @Override
    public abstract AbstractFanOutLayer copy(NetworkCopier var1);

    @Override
    public AbstractFanOutLayer copy(String nameSuffix) {
        return this.copy(new NetworkCopier(nameSuffix));
    }

    @Override
    public void copyConnectivityFrom(Component comp, NetworkCopier copier) {
        super.copyConnectivityFrom(comp, copier);
        if (comp instanceof AbstractFanOutLayer) {
            AbstractFanOutLayer that = (AbstractFanOutLayer)comp;
            this.downstream = new DownstreamLayer[that.downstream.length];
            this.myIndexInDownstream = new int[that.myIndexInDownstream.length];
            this.dDownstream = new Responsibilities[that.dDownstream.length];
            this.nDownstream = that.nDownstream;
            for (int i = 0; i < that.downstream.length; ++i) {
                this.downstream[i] = copier.getCopyIfExists(that.downstream[i]);
                this.myIndexInDownstream[i] = that.myIndexInDownstream[i];
                this.dDownstream[i] = new Responsibilities(this.size);
            }
        }
    }

    protected void disconnectDownstream(DownstreamComponent downstream) {
        int index = downstream.indexOfUpstream(this);
        if (index >= 0) {
            downstream.removeUpstream(index);
        }
    }

    @Override
    public DownstreamComponent getDownstream() {
        return this.getDownstream(0);
    }

    @Override
    public DownstreamComponent getDownstream(int index) {
        return this.downstream[index];
    }

    @Override
    public CopySourceLayer getDownstreamCopyLayer() {
        return this.downstreamCopyLayer;
    }

    @Override
    public int getIndexInDownstream() {
        return this.getIndexInDownstream(0);
    }

    @Override
    public int getIndexInDownstream(int index) {
        return this.myIndexInDownstream[index];
    }

    @Override
    public Responsibilities getResponsibilities(int index) {
        return this.dDownstream[index];
    }

    @Override
    public int indexOfDownstream(DownstreamComponent downstream) {
        for (int i = 0; i < this.nDownstream; ++i) {
            if (this.downstream[i] != downstream) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int nDownstream() {
        return this.nDownstream;
    }

    @Override
    public boolean optimize() {
        if (!super.optimize()) {
            return false;
        }
        if (this.upstream == null) {
            throw new IllegalStateException(this.name + " is missing an upstream layer.");
        }
        if (this.nDownstream == 0) {
            throw new IllegalStateException(this.name + " is missing a downstream layer.");
        }
        if (this.nDownstream == 1) {
            UpstreamLayer upstream = this.upstream;
            DownstreamLayer downstream = this.downstream[0];
            upstream.removeDownstream(this);
            downstream.removeUpstream(this);
            upstream.addDownstream(downstream);
            return false;
        }
        return true;
    }

    @Override
    public void removeDownstream(DownstreamComponent downstream) {
        this.removeDownstream(this.indexOfDownstream(downstream));
    }

    @Override
    public void removeDownstream(int index) {
        DownstreamLayer old = this.downstream[index];
        for (int i = index + 1; i < this.nDownstream; ++i) {
            this.downstream[i - 1] = this.downstream[i];
        }
        --this.nDownstream;
        this.setDownstreamCapacity(this.nDownstream);
        this.disconnectDownstream(old);
    }

    protected void setDownstreamCapacity(int capacity) {
        this.downstream = Arrays.copyOf(this.downstream, capacity);
        this.myIndexInDownstream = Arrays.copyOf(this.myIndexInDownstream, capacity);
        this.dDownstream = Arrays.copyOf(this.dDownstream, capacity);
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        super.toString(sb);
        sb.pushIndent();
        if (sb.showConnectivity()) {
            sb.indent();
            sb.append("Downstream: [");
            sb.append(this.downstream[0].getName());
            for (int i = 1; i < this.nDownstream; ++i) {
                sb.append(", ");
                sb.append(this.downstream[i].getName());
            }
            sb.append("]");
            sb.appendln();
        }
        if (sb.showExtra() && this.downstreamCopyLayer != null) {
            sb.appendln("DownstreamCopyLayer: " + this.downstreamCopyLayer.getName());
        }
        sb.popIndent();
    }
}

