/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.stat;

import dmonner.xlbp.Component;
import dmonner.xlbp.Network;
import dmonner.xlbp.compound.Compound;
import dmonner.xlbp.compound.WeightBank;
import dmonner.xlbp.compound.WeightedCompound;
import dmonner.xlbp.connection.Connection;
import dmonner.xlbp.layer.BiasLayer;
import dmonner.xlbp.layer.Layer;
import dmonner.xlbp.stat.AbstractStat;
import dmonner.xlbp.stat.ConnectionStat;
import dmonner.xlbp.stat.Stat;
import dmonner.xlbp.util.CSVWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public class NetworkStat
extends AbstractStat {
    private final ConnectionStat all = new ConnectionStat();

    public NetworkStat(Network net) {
        HashSet<Connection> cs = new HashSet<Connection>();
        LinkedList<Component> q = new LinkedList<Component>();
        q.add(net);
        while (!q.isEmpty()) {
            Component comp = (Component)q.poll();
            if (comp instanceof WeightedCompound) {
                WeightedCompound wcomp = (WeightedCompound)comp;
                for (int i = 0; i < wcomp.nUpstreamWeights(); ++i) {
                    WeightBank bank = wcomp.getUpstreamWeights(i);
                    q.add(bank);
                }
            }
            if (comp instanceof WeightBank) {
                cs.add(((WeightBank)comp).getConnection());
                continue;
            }
            if (comp instanceof BiasLayer) {
                cs.add(((BiasLayer)comp).getConnection());
                continue;
            }
            if (comp instanceof Compound) {
                for (Component sub : ((Compound)comp).getComponents()) {
                    q.add(sub);
                }
                continue;
            }
            if (comp instanceof Network) {
                for (Component sub : ((Network)comp).getComponents()) {
                    q.add(sub);
                }
                continue;
            }
            if (comp instanceof Layer) continue;
            throw new IllegalArgumentException("Unhandled subtype of Component: " + comp);
        }
        for (Connection c : cs) {
            this.all.add(new ConnectionStat(c));
        }
        this.analyze();
    }

    public void add(NetworkStat that) {
        this.all.add(that.all);
    }

    @Override
    public void add(Stat that) {
        if (!(that instanceof NetworkStat)) {
            throw new IllegalArgumentException("Can only add in NetworkStats.");
        }
        this.add((NetworkStat)that);
    }

    @Override
    public void addTo(String prefix, Map<String, Object> map) {
        this.all.addTo(prefix, map);
    }

    @Override
    public void analyze() {
        this.all.analyze();
    }

    @Override
    public void clear() {
        this.all.clear();
    }

    public ConnectionStat getConnectionStat() {
        return this.all;
    }

    @Override
    public void saveData(CSVWriter out) throws IOException {
        this.all.saveData(out);
    }

    @Override
    public void saveHeader(String prefix, CSVWriter out) throws IOException {
        this.all.saveHeader(prefix, out);
    }

    @Override
    public String toString(String prefix) {
        return this.all.toString(prefix);
    }
}

