package McS;
import robocode.*;
import java.awt.Color;

// API help : http://robocode.sourceforge.net/docs/robocode/robocode/Robot.html

/**
 * Spanky_test - a newbie robot by McSpuddles
 */
public class Spanky_test extends Robot
{
	/**
	 * run: Spanky's default behavior
	 */
	public void run() {
		// Initialization of the robot should be put here
        int direction; //0 is backwards, 1 forwards
        double distance; //distance Spanky moves

		setColors(Color.blue,Color.red,Color.green); // body,gun,radar
		// setBulletColor(Color.red);
		// setScanColor(Color.green); 
        
        direction = 0;
        
        // Robot main loop
			while(true) {
		    distance = (Math.random()*20)+120; //stop Spanky from getting stuck in loops with other robots
			// Replace the next 4 lines with any behavior you would like
		    if (direction == 0) {
			    ahead(distance);
			    turnGunRight(360);
			    direction = 1;
		    } else {
		        back(distance);
			    turnGunRight(360);
			    direction = 0;
		    }
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		// Replace the next line with any behavior you would like
		smartFire(e.getDistance());
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		// Change heading by an unpredictable amount
		turnLeft((Math.random()*15) + 45);
		back(37);
	}
	
	/**
	 * onHitWall: What to do when you hit a wall
	 */
	public void onHitWall(HitWallEvent e) {
		// Move away from the wall
		turnRight((Math.random()*15) + 45 - e.getBearing());
		ahead (150);
    }

    public void onWin() {
		while(true) {
			smartFire(201);
	    }
    }
    
    
    public void smartFire(double robotDistance) {
		// Nicked from Corners
		if (robotDistance > 200 || getEnergy() < 15) {
			setBulletColor(Color.red);
			fire(1);
		} else if (robotDistance > 50) {
			setBulletColor(Color.orange);
			fire(2);
		} else {
			setBulletColor(Color.green);
			fire(3);
	    }	
    }
}
