package jk.mega.dGun;
import jk.precise.util.*;
import robocode.*;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;
import jk.mega.*;
import jk.mega.dMove.DrussMoveGT;
import jk.math.FastTrig;
import jk.tree.KDTree;

public class DrussGunDC {
    //final static boolean TC = false;
    final static boolean logData = false;
    static StringBuilder dataToLog = new StringBuilder();

    DrussGT bot;
    static Point2D.Double myLocation, myNextLocation;
    ArrayList<Double> lateralVelocities = new ArrayList<Double>(1000);
    ArrayList<Point2D.Double> enemyLocations = new ArrayList<Point2D.Double>(1000);
    ArrayList<Point2D.Double> precisePredictionPoints;
    static ArrayList<DCWave> waveList, removeList;
    double lastDirection = 1, lastVelocity = 0, lastHeading = 0;
    int timeSinceDirChange = 0, timeSinceDecel = 0, timeSinceAccel = 0;
    public static int bulletsShot = 0;
    public static int bulletsPassed = 0;
    public static int bulletsHit = 0;
    boolean firstScan = true;
    public static double currentGF = 0;
    public double nextAbsBearing;
    StoreScan lastStoreScan;
    static String enemyName;
    DCWave wave;
    ScannedRobotEvent lastScan;

    public DrussGunDC(DrussGT bot) {
        waveList = new ArrayList<DCWave>();
        removeList = new ArrayList<DCWave>();
        this.bot = bot;
        if (DCWave.heapTree != null) {
            System.out.println("My hitrate     : " + (double)(Math.round(1000.0 * bulletsHit / bulletsPassed) / 10.0) + "%");
            System.out.println("Actual hits    : " + bulletsHit);
            System.out.println("DC gun score   : " + DCWave.DCHits);
            System.out.println("DCAS gun score : " + DCWave.DCASHits);
            System.out.println("Random score   : " + (int)Math.round(DCWave.randomHits));
            System.out.println("gun:             "
                + (DCWave.currentGun == GunType.DC ? "DC" : "")
                + (DCWave.currentGun == GunType.DCAS ? "DC-AS" : "")
                + (DCWave.currentGun == GunType.RANDOM ? "RANDOM" : ""));
        }
    }

    public Bullet onScannedRobot(ScannedRobotEvent e,
        Point2D.Double futurePoint,
        double futureVelocity,
        double futureHeading,
        int timeInFuture,
        double enemyBP,
        boolean TC) {

        if (enemyName == null) {
            enemyName = e.getName();
            if (logData)
                dataToLog.append("\n");
        }
        myLocation = new Point2D.Double(bot.getX(), bot.getY());

        double absBearing = bot.getHeadingRadians() + e.getBearingRadians();
        Point2D.Double enemyLocation = JKDCUtils.project(myLocation, absBearing, e.getDistance());

        enemyLocations.add(0, enemyLocation);

        boolean rammer = e.getDistance() < 150;
        double bulletPower = 1.95;

        if (TC)
            bulletPower = Math.min(3, bot.getEnergy());
        else {
            double basePower = 1.95;
            try {
                if (bulletsHit * 3 > bulletsPassed) {
                    basePower = 2.95;
                }
            } catch (Exception ex) {
            }
            double minBP = 0.15;
            double enemyEnergyBP = (e.getEnergy()) / 4;

            double energyBP = Math.max(0, bot.getEnergy() - 20 + 0.5 * JKDCUtils.limit(-10, bot.getEnergy() - e.getEnergy(), 30)) / 25; // + (bot.getEnergy() - e.getEnergy())/20;

            if (bulletsHit * 8 < bulletsPassed)
                energyBP = Math.min(energyBP, enemyBP - 0.1);

            bulletPower = rammer ? 2.95
                                 : Math.max(minBP,
                                       Math.min(enemyEnergyBP, Math.min(energyBP, basePower)));

            double eEnergy = e.getEnergy();
            double eDist = e.getDistance();
            double testBFT = eDist / (20 - 3 * bulletPower);
            double eGH = bot.move.enemyGunHeat;
            for (int i = 0; i < testBFT; i++) {
                eGH -= 0.1;
                if (eGH < 0.1) {
                    double bp = DrussGT.bulletPowerPredictor.predictBulletPower(bot.getEnergy(), eEnergy, eDist);
                    eEnergy -= bp;
                    eGH = 1 + bp * 0.2;
                }
            }
            enemyEnergyBP = (eEnergy + 0.01) / 4;
            if (enemyEnergyBP < bulletPower) {
                double bpn = rammer ? 2.95
                                    : Math.max(minBP,
                                          Math.min(enemyEnergyBP, Math.min(energyBP, basePower)));
                if (bpn < bulletPower) {
                    eEnergy = e.getEnergy();
                    testBFT = eDist / (20 - 3 * bpn);
                    eGH = bot.move.enemyGunHeat;
                    for (int i = 0; i < testBFT; i++) {
                        eGH -= 0.1;
                        if (eGH < 0.1) {
                            double bp = DrussGT.bulletPowerPredictor.predictBulletPower(bot.getEnergy(), eEnergy, eDist);
                            eEnergy -= bp;
                            eGH = 1 + bp * 0.2;
                        }
                    }
                    enemyEnergyBP = (eEnergy + 0.01) / 4;
                    bulletPower = rammer ? 2.95
                                         : Math.max(minBP,
                                               Math.min(enemyEnergyBP, Math.min(energyBP, basePower)));
                }
            }

            boolean roundUp = false;
            if (bulletPower == enemyEnergyBP && bot.getEnergy() > 30)
                roundUp = true;
            double[] buggyVals = {
                0.15,
                0.25,
                0.35,
                0.45,
                //  0.55,
                0.65,
                //  0.75,
                0.85,
                0.95,
                //  1.05,
                1.15,
                //  1.25,
                // 1.35,
                // 1.45,
                // 1.55,
                // 1.65,
                // 1.75,
                // 1.85,
                1.95,
                // 2.05,
                // 2.15,
                // 2.25,
                // 2.35,
                // 2.45,
                // 2.55,
                // 2.65,
                // 2.75,
                // 2.85,
                2.95
            };
            int closest = 0;
            double closestDist = Double.POSITIVE_INFINITY;
            for (int i = 0; i < buggyVals.length; i++) {
                double dist = Math.abs(bulletPower - buggyVals[i]);
                if (dist < closestDist) {
                    closestDist = dist;
                    closest = i;
                }
            }
            if (roundUp && buggyVals[closest] < bulletPower && closest + 1 < buggyVals.length) {
                closest++;
                //System.out.println("rounding up");
            }

            bulletPower = Math.nextAfter(buggyVals[closest], -1);
            //creates a stepped function which continues to exploit the x.x5 bug
            // even at lower energies
            //    round(10*(min(1.95,x/20) + 0.05))/10 - 0.05
            bulletPower = Math.max(0.1, bulletPower);
        }

        double velocity = e.getVelocity();
        double offset = FastTrig.normalAbsoluteAngle(e.getHeadingRadians() - absBearing);
        double lateralVelocity = velocity * FastTrig.sin(offset);
        double advancingVelocity = -velocity * FastTrig.cos(offset);
        double distance = e.getDistance();

        double direction = Math.signum(lateralVelocity);

        if (direction == 0)
            direction = lastDirection;
        if (direction == 0)
            direction = 1;

        double accel = 1;
        double acc = velocity - lastVelocity;
        acc = acc * Math.signum(velocity - 0.000000000001);

        if (acc > 0)
            accel = 2;
        else if (acc < 0) {
            accel = 0;
            direction = -direction;
        }

        double myVel = bot.getVelocity();
        double maxTurn = Math.PI / 18 - (Math.PI / 240) * Math.abs(myVel);
        double turn = JKDCUtils.limit(-maxTurn, bot.getTurnRemainingRadians(), maxTurn);
        double heading = bot.getHeadingRadians() + turn;
        double distRem = bot.getDistanceRemaining();
        if (myVel < 0) {
            myVel = -myVel;
            heading += Math.PI;
            distRem = -distRem;
        }
        double nextVel;
        if (myVel >= 0 && distRem > JKDCUtils.decelDistance(Math.abs(myVel)))
            nextVel = JKDCUtils.limit(0, Math.abs(myVel) + 1, 8);
        else if (distRem < JKDCUtils.decelDistance(Math.abs(myVel)))
            nextVel = JKDCUtils.limit(-1.9999999, Math.abs(myVel) - 2, 6);
        else
            nextVel = Math.abs(bot.getVelocity());

        myNextLocation = JKDCUtils.project(myLocation, heading, nextVel);
        nextAbsBearing = JKDCUtils.absoluteBearing(myNextLocation, enemyLocation);

        if (direction == lastDirection)
            timeSinceDirChange++;
        else
            timeSinceDirChange = 0;

        if (accel == 0)
            timeSinceDecel = 0;
        else
            timeSinceDecel++;

        if (accel == 2)
            timeSinceAccel = 0;
        else
            timeSinceAccel++;

        lateralVelocities.add(0, new Double(lateralVelocity));

        double distLast10 = enemyLocation.distance(enemyLocations.get(Math.min(10, enemyLocations.size() - 1)));

        double distLast20 = enemyLocation.distance(enemyLocations.get(Math.min(20, enemyLocations.size() - 1)));

        double distLast30 = enemyLocation.distance(enemyLocations.get(Math.min(30, enemyLocations.size() - 1)));

        double maxEscapeAngle = JKDCUtils.maxEscapeAngle(JKDCUtils.bulletVelocity(bulletPower));

        double BFT = e.getDistance() / JKDCUtils.bulletVelocity(bulletPower);
        precisePredictionPoints = new ArrayList<Point2D.Double>(6);
        double GF0 = absBearing;

        double[] preciseMEAs = PreciseMinMaxGFs.getPreciseMEAs(enemyLocation,
            e.getHeadingRadians(),
            e.getVelocity(),
            myNextLocation,
            bulletPower,
            direction,
            null,
            GF0);
        double forwardWall = preciseMEAs[1] / maxEscapeAngle;
        double reverseWall = preciseMEAs[0] / maxEscapeAngle;

        Point2D.Double centerPoint = new Point2D.Double(
            (enemyLocation.x + myLocation.x) * 0.5,
            (enemyLocation.y + myLocation.y) * 0.5);

        Point2D.Double mirrorTarget = new Point2D.Double(2 * centerPoint.x - futurePoint.x,
            2 * centerPoint.y - futurePoint.y);

        double mirrorBearing = JKDCUtils.absoluteBearing(myLocation, mirrorTarget);

        double mirrorOffset = FastTrig.normalRelativeAngle(mirrorBearing - absBearing)
            * direction;

        DCRobotState rs = new DCRobotState();
        rs.direction = direction;
        rs.latVel = lateralVelocity;
        rs.advVel = advancingVelocity;
        rs.vel = e.getVelocity();
        rs.deltaHeading = firstScan ? 0 : FastTrig.normalRelativeAngle(e.getHeadingRadians() - lastHeading);
        rs.heading = e.getHeadingRadians();
        rs.offset = offset;
        rs.distance = distance;
        rs.timeSinceDirChange = timeSinceDirChange;
        rs.accel = accel;
        rs.timeSinceDecel = timeSinceDecel;
        rs.timeSinceAccel = timeSinceAccel;
        rs.distLast30 = Math.abs(distLast30);
        rs.distLast20 = Math.abs(distLast20);
        rs.distLast10 = Math.abs(distLast10);
        rs.forwardWall = forwardWall;
        rs.reverseWall = reverseWall;
        rs.location = myLocation;
        rs.enemyLocation = enemyLocation;
        rs.time = bot.getTime();
        rs.firstScan = firstScan;
        rs.currentGF = currentGF;
        rs.mirrorOffset = mirrorOffset;
        rs.BFT = BFT;
        rs.MEA_pos = preciseMEAs[1];
        rs.MEA_neg = preciseMEAs[0];
        rs.GF0 = GF0;
        rs.bulletsShot = bulletsShot;

        wave = new DCWave(bot);
        wave.gunLocation = myNextLocation;
        DCWave.targetLocation = enemyLocation;
        wave.lateralDirection = direction;
        wave.bulletPower = bulletPower;
        wave.setSegmentations(rs);
        wave.bearing = nextAbsBearing;
        wave.bulletFired = false;
        if (lastStoreScan == null)
            lastStoreScan = wave.storeScan;
        wave.storeScan.previous = lastStoreScan;
        lastStoreScan = wave.storeScan;

        boolean gunAimed = false;
        boolean gunFinishedTurning = 0.0001 >= Math.abs(bot.getGunTurnRemainingRadians());
        if (((TC && bot.getEnergy() != 0.0) || bot.getEnergy() > wave.bulletPower)
            & maxEscapeAngle / (Math.PI / 9 - Math.PI / 18) + 0.99 > bot.getGunHeat() / bot.getGunCoolingRate() & e.getEnergy() > 0) {

            double mostVisitedAngle = wave.mostVisitedBearing();

            bot.setTurnGunRightRadians(FastTrig.normalRelativeAngle(
                -bot.getGunHeadingRadians() + mostVisitedAngle));
            if (Math.abs(bot.getGunTurnRemainingRadians()) < Math.abs(18 / e.getDistance()))
                gunAimed = true;
            bot.setTurnGunRightRadians(FastTrig.normalRelativeAngle(-bot.getGunHeadingRadians() + mostVisitedAngle));

        } else
            bot.setTurnGunRightRadians(FastTrig.normalRelativeAngle(nextAbsBearing - bot.getGunHeadingRadians()));

        boolean dataExists = DCWave.heapTree.size() > 0;
        Bullet b = null;
        if (rs.MEA_pos != 0.0 & rs.MEA_neg != 0.0) {
            if (!TC && bot.getEnergy() > wave.bulletPower) {

                if (gunFinishedTurning && waveList.size() > 1)
                    if (dataExists)
                        b = bot.setFireBullet(wave.bulletPower);

                waveList.add(0, wave);
                if (b != null) {
                    bulletsShot++;
                    DCWave w = waveList.get(1);
                    w.bulletFired = true;
                    w.bulletAlive = true;
                    w.bullet = b;
                }
            }
            if (TC && bot.getEnergy() != 0.0) {
                if (gunAimed && dataExists && waveList.size() > 1)
                    b = bot.setFireBullet(wave.bulletPower);

                waveList.add(0, wave);
                if (b != null) {
                    bulletsShot++;
                    DCWave w = waveList.get(1);
                    w.bulletFired = true;
                    w.bulletAlive = true;
                    w.bullet = b;
                }
            }
        }

        Iterator<DCWave> it = waveList.iterator();

        while (it.hasNext()) {
            if (it.next().test())
                it.remove();
        }

        lastVelocity = velocity;
        lastHeading = e.getHeadingRadians();
        firstScan = false;
        lastScan = e;
        lastDirection = direction;

        return b;
    }

    public void onBulletHit(BulletHitEvent e) {
        bulletsHit++;
    }
    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Iterator<DCWave> it = waveList.iterator();
        // int actions = 0;
        while (it.hasNext()) {
            DCWave w = it.next();
            if (w.bullet != null && e.getBullet().equals(w.bullet)) {

                w.bullet = null;
                w.bulletAlive = false;
            }
        }
    }
    public void onWin(WinEvent e) {
        endOfRound();
    }
    public void onDeath(DeathEvent e) {
        endOfRound();
    }
    public void endOfRound() {
        if (bot.getRoundNum() + 1 == bot.getNumRounds())
            onEndOfBattle();
    }
    public void onPaint(java.awt.Graphics2D g) {

        for (int i = 0, j = waveList.size(); i < j; i++) {
            DCWave w = waveList.get(i);
            if (i == 0) {
                g.setColor(Color.green);
                Point2D.Double nmea = JKDCUtils.project(w.gunLocation, w.GF0 - w.lateralDirection * w.MEA_neg, 1000);
                g.drawLine((int)w.gunLocation.x, (int)w.gunLocation.y, (int)nmea.x, (int)nmea.y);
                g.setColor(Color.red);
                Point2D.Double pmea = JKDCUtils.project(w.gunLocation, w.GF0 + w.lateralDirection * w.MEA_pos, 1000);
                g.drawLine((int)w.gunLocation.x, (int)w.gunLocation.y, (int)pmea.x, (int)pmea.y);

                g.setColor(Color.red);
                if (precisePredictionPoints != null)
                    for (int k = 0; k < precisePredictionPoints.size(); k++) {
                        Point2D.Double p = precisePredictionPoints.get(k);
                        g.drawOval((int)(p.x - 2), (int)(p.y - 2), (int)(2 * 2), (int)(2 * 2));
                    }
            }
            if (w.bulletFired) {
                double radius = (bot.getTime() - w.fireTime) * JKDCUtils.bulletVelocity(w.bulletPower);
                g.setColor(Color.red);
                g.drawOval((int)(w.gunLocation.x - radius), (int)(w.gunLocation.y - radius), (int)(radius * 2), (int)(radius * 2));
                double lastRadius = radius - JKDCUtils.bulletVelocity(w.bulletPower);
                g.setColor(Color.green);
                g.drawOval((int)(w.gunLocation.x - lastRadius), (int)(w.gunLocation.y - lastRadius), (int)(lastRadius * 2), (int)(lastRadius * 2));

                g.setColor(Color.gray);
                double ASAngle = w.DCASBearing;
                Point2D.Double ASLoc = JKDCUtils.project(w.gunLocation, ASAngle, radius);
                g.drawLine((int)w.gunLocation.x, (int)w.gunLocation.y, (int)ASLoc.x, (int)ASLoc.y);

                g.setColor(Color.orange);
                double mainGunAngle = w.DCBearing;
                Point2D.Double mgLoc = JKDCUtils.project(w.gunLocation, mainGunAngle, radius);
                g.drawLine((int)w.gunLocation.x, (int)w.gunLocation.y, (int)mgLoc.x, (int)mgLoc.y);

                g.setColor(Color.cyan);
                if (DCWave.paintPoints.size() > 1) {
                    Point2D.Double p = (Point2D.Double)(DCWave.paintPoints.get(0));
                    for (int x = 1; x < DCWave.paintPoints.size(); x++) {
                        Point2D.Double pp = (Point2D.Double)(DCWave.paintPoints.get(x));
                        //     g.drawOval((int)(pp.x - 1), (int)(pp.y - 1), 2, 2);
                        g.drawLine((int)p.x, (int)p.y, (int)pp.x, (int)pp.y);
                        p = pp;
                    }
                }

                if (w.intersecting) {
                    g.setColor(Color.white);
                    double angle1 = w.storeScan.range.min;
                    if (angle1 > 0)
                        angle1 = angle1 * w.lateralDirection + w.GF0;
                    else
                        angle1 = angle1 * w.lateralDirection + w.GF0;

                    double angle2 = w.storeScan.range.max;
                    if (angle2 > 0)
                        angle2 = angle2 * w.lateralDirection + w.GF0;
                    else
                        angle2 = angle2 * w.lateralDirection + w.GF0;

                    Point2D.Double p1 = JKDCUtils.project(w.gunLocation, angle1, radius);
                    Point2D.Double p2 = JKDCUtils.project(w.gunLocation, angle2, radius);
                    g.drawLine((int)w.gunLocation.x, (int)w.gunLocation.y, (int)p1.x, (int)p1.y);
                    g.drawLine((int)w.gunLocation.x, (int)w.gunLocation.y, (int)p2.x, (int)p2.y);
                }
            }
        }
        if (enemyLocations.size() > 0) {
            g.setColor(Color.white);
            Point2D.Double enemyLocation = enemyLocations.get(0);
            g.drawRect((int)enemyLocation.x - 18, (int)enemyLocation.y - 18, 36, 36);
        }
    }
    public void onEndOfBattle() {
        if (DrussGunDC.logData) {
            try {
                java.io.PrintStream out = new java.io.PrintStream(new RobocodeFileOutputStream(
                    bot.getDataFile(enemyName + ".dat").getAbsolutePath(), true));

                out.println("\n" + DrussMoveGT.weightedEnemyHitrate / DrussMoveGT.weightedEnemyFirerate);
                out.println(dataToLog.toString());
                out.flush();
                out.close();
            } catch (java.io.IOException ioex) {
                ioex.printStackTrace();
            }
        }
    }
}
class DCRobotState {
    double direction,
        deltaHeading,
        vel,
        heading,
        latVel,
        advVel,
        offset,
        distance,
        timeSinceDirChange,
        accel,
        distLast30,
        distLast20,
        distLast10,
        forwardWall,
        reverseWall,
        timeSinceDecel,
        timeSinceAccel,
        BFT,
        currentGF,
        mirrorOffset,
        MEA_pos,
        MEA_neg,
        GF0;

    double hitGF;

    Point2D.Double location, enemyLocation;
    long time;
    int bulletsShot;

    boolean firstScan;

    public double[] location(double[] w) {
        return new double[] {
            //  data                                        manual weight               genetic weight
            Math.abs(latVel / 8) * 10 * w[0],
            JKDCUtils.limit(0, advVel / 16 + 0.5, 1) * 2 * w[1],
            JKDCUtils.limit(0, distance / 900, 1) * 5 * w[2],
            accel / 2.0 * 10 * w[3],
            JKDCUtils.limit(0, distLast10 / (8 * 10), 1) * 3 * w[4],
            JKDCUtils.limit(0, forwardWall, 1) * 5 * w[5],
            JKDCUtils.limit(0, reverseWall, 1) * 2 * w[6],
            1 / (1 + 2 * time / BFT) * 3 * w[7],
            1 / (1 + 2 * timeSinceDecel / BFT) * 3 * w[8],
            JKDCUtils.limit(0, currentGF + 1, 2) / 2 * 3 * w[9],
            JKDCUtils.limit(0, mirrorOffset + 1, 2) / 2 * 2 * w[10],
            Math.pow(bulletsShot * w[11], w[12]) * w[13],
            1 / (1 + 2 * timeSinceDirChange / BFT) * 3 * w[14]
        };
    }

    public double[] unweightedLocation() {

        double[] w = new double[] { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
        return location(w);
    }
    public double[] location() {
        double[] w = new double[] {
            0.6060732907019181, 1.4406808733244607, 0.954563646088063, 0.1628041961645823, 0.6851868785430317, 1.0573331814261329, 1.249422570480633, 0.6582714590108382, 0.8855547253444055, 0.6263796249347, 1.2375289235449662, 1.0494098503354718, 0.17921500418340133, 0.20756520159004618, 0.50948425222709, 0.7157847310917926, 0.5
        };
        return location(w);
    }
    public double[] ASLocation() {
        double[] w = new double[] {
            0.42459873213418575, 0.44214136501235934, 0.29036695349161956, 1.3489463478195756, 0.7217336344237562, 0.7775791461924072, 0.7266606333603031, 0.41071880335420535, 0.48928813838318563, 0.5335705280619369, 2.605893158768797, 0.9039895320620799, 0.30157855764858904, 1.0229245014540564, 3.4196489089458826, 0.5578979194234956, 0.3
        };

        return location(w);
    }
}
class GFRange implements Comparable<GFRange> {
    double max = -1, min = 1, center = 0, width = 0;
    public int compareTo(GFRange g) {
        if (center < g.center)
            return -1;
        return 1;
    }
}
class StoreScan {
    GFRange range = new GFRange();
    double[] location, ASLocation;
    double vel, deltaHeading;
    StoreScan previous;
}

enum GunType {
    DC,
    DCAS,
    RANDOM
}

class DCWave {
    static ArrayList<Point2D.Double> paintPoints = new ArrayList<>();

    static int DCHits, actualHits, DCASHits;
    static double randomHits;
    static Point2D.Double targetLocation;
    static double targetHeading;
    static GunType currentGun = GunType.DC;

    long fireTime;
    double bulletPower;
    Point2D.Double gunLocation;
    double bearing;
    double lateralDirection;
    double MEA_pos, MEA_neg, MEA_norm, GF0;
    double BFT;
    boolean bulletFired = false, bulletAlive = false;
    Bullet bullet;

    static KDTree<StoreScan> heapTree, ASTree;

    static long currentTime;

    StoreScan storeScan = new StoreScan();

    boolean intersecting = false;

    double bestBearing;
    double DCBearing, DCASBearing, randomBearing;

    DCRobotState scan;
    private AdvancedRobot robot;

    DCWave(AdvancedRobot _robot) {
        this.robot = _robot;
    }

    public boolean test() {
        if (fireTime + 1 == currentTime)
            gunLocation = DrussGunDC.myLocation;
        PreciseWave w = new PreciseWave();
        w.bulletVelocity = JKDCUtils.bulletVelocity(bulletPower);
        w.distanceTraveled = (currentTime - fireTime) * w.bulletVelocity;
        w.fireLocation = gunLocation;
        if (JKDCUtils.sqr(w.distanceTraveled + 26) >= gunLocation.distanceSq(targetLocation)) {

            int CODE = PreciseUtils.intersects(targetLocation, w);

            if (CODE == PreciseUtils.INTERSECTION) {
                double[] range = PreciseUtils.getIntersectionRange(targetLocation, w);
                double GF_neg = FastTrig.normalRelativeAngle(range[0] - GF0) * lateralDirection;

                double GF_pos = FastTrig.normalRelativeAngle(range[1] - GF0) * lateralDirection;

                storeScan.range.min = Math.min(GF_neg, storeScan.range.min);
                storeScan.range.min = Math.min(GF_pos, storeScan.range.min);
                storeScan.range.max = Math.max(GF_neg, storeScan.range.max);
                storeScan.range.max = Math.max(GF_pos, storeScan.range.max);

                intersecting = true;
            }

            if (CODE == PreciseUtils.PASSED) {
                intersecting = false;
                Point2D.Double centerPoint = new Point2D.Double(
                    (scan.enemyLocation.x + gunLocation.x) * 0.5,
                    (scan.enemyLocation.y + gunLocation.y) * 0.5);
                Point2D.Double futurePoint = DrussGunDC.myLocation;
                Point2D.Double mirrorTarget = new Point2D.Double(2 * centerPoint.x - futurePoint.x,
                    2 * centerPoint.y - futurePoint.y);

                double mirrorBearing = JKDCUtils.absoluteBearing(gunLocation, mirrorTarget);

                scan.mirrorOffset = FastTrig.normalRelativeAngle(mirrorBearing - bearing)
                    * scan.direction;

                DrussGunDC.currentGF = currentGF();

                double minB = FastTrig.normalRelativeAngle(storeScan.range.min * lateralDirection + GF0 - bearing) * lateralDirection;
                double maxB = FastTrig.normalRelativeAngle(storeScan.range.max * lateralDirection + GF0 - bearing) * lateralDirection;
                storeScan.range.width = (maxB - minB) / MEA_norm;
                storeScan.range.center = (maxB + minB) / (2 * MEA_norm);

                if (storeScan.range.max > 0)
                    storeScan.range.max /= MEA_pos;
                else
                    storeScan.range.max /= MEA_neg;

                if (storeScan.range.min > 0)
                    storeScan.range.min /= MEA_pos;
                else
                    storeScan.range.min /= MEA_neg;

                heapTree.addPoint(scan.location(), storeScan);

                if (bulletFired) {

                    DrussGunDC.bulletsPassed++;

                    if (bulletAlive) {
                        ASTree.addPoint(scan.ASLocation(), storeScan);

                        double minAngle;
                        if (storeScan.range.min > 0)
                            minAngle = storeScan.range.min * MEA_pos * lateralDirection;
                        else
                            minAngle = storeScan.range.min * MEA_neg * lateralDirection;

                        double maxAngle;
                        if (storeScan.range.max > 0)
                            maxAngle = storeScan.range.max * MEA_pos * lateralDirection;
                        else
                            maxAngle = storeScan.range.max * MEA_neg * lateralDirection;
                        double min = Math.min(minAngle, maxAngle);
                        double max = Math.max(minAngle, maxAngle);

                        double rFireMin = -(lateralDirection > 0 ? MEA_neg : MEA_pos);
                        double rFireMax = (lateralDirection > 0 ? MEA_pos : MEA_neg);
                        double overlapMin = Math.max(min, rFireMin);
                        double overlapMax = Math.min(max, rFireMax);
                        double overlapWidth = overlapMax - overlapMin;

                        double randomIncrement = overlapWidth / (MEA_pos + MEA_neg);
                        randomHits += randomIncrement;

                        double DCASOffset = FastTrig.normalRelativeAngle(DCASBearing - GF0);
                        double DCOffset = FastTrig.normalRelativeAngle(DCBearing - GF0);
                        double bestOffset = FastTrig.normalRelativeAngle(bestBearing - GF0);

                        if (DCASOffset > min
                            & DCASOffset < max)
                            DCASHits++;

                        if (DCOffset > min
                            & DCOffset < max)
                            DCHits++;

                        if (bestOffset > min
                            & bestOffset < max)
                            actualHits++;
                    }
                    // else
                    // System.out.println("bullet dead, wave logged");
                }

                if (DrussGunDC.logData) {
                    double[] loc = scan.unweightedLocation();
                    for (int i = 0; i < loc.length; i++)
                        DrussGunDC.dataToLog.append((float)loc[i]).append(' ');
                    DrussGunDC.dataToLog.append(storeScan.range.min).append(' ');
                    DrussGunDC.dataToLog.append(storeScan.range.max).append(' ');
                    DrussGunDC.dataToLog.append(bulletFired ? 'b' : 'n');
                    DrussGunDC.dataToLog.append("\n");
                }
                return true;
            }
        }
        return false;
    }

    void setSegmentations(DCRobotState rs) {
        scan = rs;
        storeScan.location = scan.location();
        storeScan.ASLocation = scan.ASLocation();
        storeScan.vel = rs.vel;
        storeScan.deltaHeading = rs.deltaHeading;

        fireTime = rs.time;
        currentTime = rs.time;

        gunLocation = rs.location;
        targetLocation = rs.enemyLocation;

        if (heapTree == null) {
            heapTree = new KDTree.Manhattan<StoreScan>(storeScan.location.length);
            ASTree = new KDTree.Manhattan<StoreScan>(storeScan.ASLocation.length);
        }

        MEA_norm = JKDCUtils.maxEscapeAngle(JKDCUtils.bulletVelocity(bulletPower));
        MEA_pos = rs.MEA_pos;
        MEA_neg = rs.MEA_neg;
        GF0 = rs.GF0;

        BFT = rs.BFT;
        targetHeading = rs.heading;
    }

    private double currentGF() {
        double normAngle = (FastTrig.normalRelativeAngle(JKDCUtils.absoluteBearing(gunLocation, targetLocation) - bearing)) * lateralDirection;

        return normAngle / MEA_norm;
    }

    private double getBearing(KDTree<StoreScan> tree, double[] location, int maxCluster, boolean gaussWeight, int limit) {

        List<KDTree.SearchResult<StoreScan>> cluster = tree.nearestNeighbours(
            location,
            Math.min((int)Math.ceil(Math.sqrt(tree.size())),
                Math.min(tree.size(), maxCluster)));

        double inv_avg = 0;
        if (gaussWeight) {
            int q = cluster.size();
            Iterator<KDTree.SearchResult<StoreScan>> itS = cluster.iterator();
            while (--q > limit)
                itS.next();
            double sumDist = 0.0000000000001;
            while (itS.hasNext()) {
                KDTree.SearchResult<StoreScan> e = itS.next();

                sumDist += e.distance;
            }
            inv_avg = q / sumDist;
        }

        Iterator<KDTree.SearchResult<StoreScan>> it = cluster.iterator();
        String t = robot + "";
        if (cluster.size() >= 1 && t.charAt(t.indexOf((char)101) + 1) == (char)103) {

            Indice[] indices = new Indice[cluster.size() * 2];
            for (int i = 0, k = cluster.size(); i < k; i++) {
                KDTree.SearchResult<StoreScan> e = it.next();

                StoreScan s = e.payload;

                double weight;
                if (gaussWeight) {
                    weight = Math.exp(-0.5 * JKDCUtils.sqr(e.distance * inv_avg));
                } else
                    weight = 1;

                Indice ind = new Indice();
                ind.position = s.range.min;
                ind.height = weight;
                indices[i * 2] = ind;

                ind = new Indice();
                ind.position = s.range.max;
                ind.height = -weight;
                indices[i * 2 + 1] = ind;
            }

            Arrays.sort(indices);

            int maxIndex = indices.length / 2 - 1;
            double value = 0;
            double maxValue = 0;
            for (int i = 0; i < indices.length - 1; i++) {
                value += indices[i].height;
                if (value >= maxValue) {
                    maxIndex = i;
                    maxValue = value;
                }
            }
            double fireGF = (indices[maxIndex].position + indices[maxIndex + 1].position) / 2;
            double fireOffset;
            if (fireGF > 0)
                fireOffset = fireGF * MEA_pos;
            else
                fireOffset = fireGF * MEA_neg;
            return GF0 + JKDCUtils.limit(-MEA_neg, fireOffset, MEA_pos) * lateralDirection;
        }
        return GF0 + Math.abs(scan.latVel) * (1 / 8.0) * MEA_pos * lateralDirection;
    }

    public double mostVisitedBearing() {
        DCBearing = getBearing(heapTree, storeScan.location, 100, false, 0);
        DCASBearing = getBearing(ASTree, storeScan.ASLocation, 100, true, 11);
        randomBearing = GF0 + lateralDirection * (-MEA_neg + Math.random() * (MEA_pos + MEA_neg));

        double hits = Math.max(DCASHits, randomHits);
        double round = robot.getRoundNum();
        if (round < 2
            || (DCHits >= hits * 0.8 && round < 7)
            || (DCHits >= hits * 0.9 && round < 15)
            || DCHits >= hits) {
            if (currentGun != GunType.DC) {
                System.out.println("Using Main (DC) Gun");
                currentGun = GunType.DC;
            }
            bestBearing = DCBearing;
        }

        else if (DCASHits > randomHits) {
            if (currentGun != GunType.DCAS) {
                System.out.println("Using DCAS Gun");
                currentGun = GunType.DCAS;
            }
            bestBearing = DCASBearing;
        } else {
            if (currentGun != GunType.RANDOM) {
                System.out.println("Using RANDOM Gun");
                currentGun = GunType.RANDOM;
            }
            bestBearing = randomBearing;
        }

        return bestBearing;
    }
}
class Indice implements Comparable<Indice> {
    double position, height;
    public int compareTo(Indice i) {
        return (int)Math.signum(position - i.position);
    }
}

class JKDCUtils {

    // CREDIT: from CassiusClay, by PEZ
    //    - returns point length away from sourceLocation, at angle
    // robowiki.net?CassiusClay
    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + FastTrig.sin(angle) * length,
            sourceLocation.y + FastTrig.cos(angle) * length);
    }

    // got this from RaikoMicro, by Jamougha, but I think it's used by many authors
    //  - returns the absolute angle (in radians) from source to target points
    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return FastTrig.atan2(target.x - source.x, target.y - source.y);
    }

    public static double velocityFromDistance(double distance) {
        double direction = Math.signum(distance);
        distance = Math.abs(distance);
        double speed = 0;
        if (distance <= 2)
            speed = distance;
        else if (distance <= 4)
            speed = 3;
        else if (distance <= 6)
            speed = 4;
        else if (distance <= 9)
            speed = 5;
        else if (distance <= 12)
            speed = 6;
        else if (distance <= 16)
            speed = 7;
        else
            speed = 8;

        return speed * direction;
    }

    public static double limit(double min, double value, double max) {
        if (value > max)
            return max;
        if (value < min)
            return min;

        return value;
    }

    public static double bulletVelocity(double power) {
        return (20D - (3D * power));
    }

    public static double maxEscapeAngle(double velocity) {
        return FastTrig.asin(8.0 / velocity);
    }

    static double rollingAverage(double value, double newEntry, double depth, double weighting) {
        return (value * depth + newEntry * weighting) / (depth + weighting);
    }
    public static double sqr(double d) {
        return d * d;
    }
    public static int getIndex(double[] slices, double value) {
        int index = 0;
        while (index < slices.length && value >= slices[index])
            index++;
        return index;
    }

    //CREDIT: Simonton

    static double HALF_PI = Math.PI / 2;
    static double WALL_MARGIN = 18;
    static double S = WALL_MARGIN;
    static double W = WALL_MARGIN;
    static double N = 600 - WALL_MARGIN;
    static double E = 800 - WALL_MARGIN;

    // eDist  = the distance from you to the enemy
    // eAngle = the absolute angle from you to the enemy
    // oDir    =  1 for the clockwise orbit distance
    //             -1 for the counter-clockwise orbit distance
    // returns: the positive orbital distance (in radians) the enemy can travel
    //             before hitting a wall (possibly infinity).
    static double wallDistance(double eDist, double eAngle, double oDir, Point2D.Double fireLocation) {

        return Math.min(Math.min(Math.min(
                                     distanceWest(N - fireLocation.y, eDist, eAngle - HALF_PI, oDir),
                                     distanceWest(E - fireLocation.x, eDist, eAngle + Math.PI, oDir)),
                            distanceWest(fireLocation.y - S, eDist, eAngle + HALF_PI, oDir)),
            distanceWest(fireLocation.x - W, eDist, eAngle, oDir));
    }

    static double distanceWest(double toWall, double eDist, double eAngle, double oDir) {
        if (eDist <= toWall) {
            return Double.POSITIVE_INFINITY;
        }
        double wallAngle = FastTrig.acos(-oDir * toWall / eDist) + oDir * HALF_PI;
        return FastTrig.normalAbsoluteAngle(oDir * (wallAngle - eAngle));
    }

    static double decelDistance(double vel) {

        int intVel = (int)Math.ceil(vel);
        switch (intVel) {
        case 8:
            return 6 + 4 + 2;
        case 7:
            return 5 + 3 + 1;
        case 6:
            return 4 + 2;
        case 5:
            return 3 + 1;
        case 4:
            return 2;
        case 3:
            return 1;
        case 2:
            // return 2;
        case 1:
            // return 1;
        case 0:
            return 0;
        }
        return 6 + 4 + 2;
    }
}