/*
 * Created on 2004-9-30
 */
package tide;

import java.io.Serializable;

/**
 * this event occurred when you received a teammate's message
 * 
 * @author xiemin
 */
public class MessageEvent extends Event
{
	//the name of the massage sender
	private String sender;
	//the content of the message
	private Serializable message;
	
	/**
	 * create a new MessageEvent
	 * @param event robocode MessageEvent
	 */
	public MessageEvent(robocode.MessageEvent event)
	{
		super(event);
		this.sender = event.getSender();
		this.message = event.getMessage();
	}
	
	/**
	 * Return the content of the message
	 * @return the content of the message
	 */
	public Serializable getMessage()
	{
		return message;
	}
	/**
	 * Return the name of the massage sender
	 * @return the name of the massage sender
	 */
	public String getSender()
	{
		return sender;
	}
}
