/*
 * Created on 2004-9-26
 */
package tide.util;


import java.awt.geom.Point2D;

import tide.RobotConsole;
import tide.ScannedRobotEvent;


/**
 * My robot's info relative to a certain enemy
 * this name of this info is my robot name + enemy name
 * @author iiley(Chen Jing)
 */
public class MyInfo extends BotInfo {
	public MyInfo(RobotConsole robot, ScannedRobotEvent e){
		
		time = e.getTime();
		
		name = robot.getName()+e.getName();
		
		energy = robot.getEnergy();
		
		absBearing = MathUtils.heading(e.getX(), e.getY(),
				robot.getX(), robot.getY());
		
		velocity = robot.getVelocity();
				
		distance = Point2D.distance(robot.getX(), robot.getY(),
				e.getX(), e.getY());
		
		heading = MathUtils.anglePI(robot.getHeading());
		
		location = new Point2D.Double(robot.getX(), robot.getY());

		leaveVelocity = robot.getVelocity()*Math.sin(robot.getHeading()-absBearing);
		if(leaveVelocity > 0){
			direction = 1;
		}else if(leaveVelocity < 0){
			direction = -1;
		}
		closeVelocity = robot.getVelocity()*Math.cos(robot.getHeading()-absBearing);
	}
}
