/*
 * Situation.java
 *
 * Created on 14 maart 2004, 20:13
 */

/**
 *
 * @author  Vic Stewart
 */
package vic;
public class Situation extends Base
{
    static final int NumDimensions = 12; //recompile Log after changing this...
    static double[] weights = new double[NumDimensions];
    byte[] dimension = new byte[NumDimensions];                    //8 bits granularity per dimension should be enough
    
    Situation()
    {
    }
    
    Situation(Situation pSituation)
    {
        dimension = pSituation.dimension;
    }
    
    double TimeFactor(byte ETA)
    {
        return ((double)ETA / (double)getDimension(0));         //ETA is the bullet travel time of the current situation. We must factor in that the stored Observation probably had a different ETA (Dimension(0)).
    }

    void setDimension(int pIndex, double pValue, double pMin, double pMax)
    {
        dimension[pIndex] = (byte)Math.round(((127.0 / (pMax-pMin)) * (pValue - pMin)));
    }
    
    byte getDimension(int pIndex)
    {
        return dimension[pIndex];
    }
    
    int distance(Situation other)
    {
        int result = 0;
        
        weights[0] = 10.0d;    //ETA
        weights[1] = 100.0d;    //myBearing
        weights[2] = 100.0d;     //vel
        weights[3] = 10.0d;    //center
        weights[4] = 10.0d;     //wall
        weights[5] = 10.0d;    //corner
        weights[6] = 1000.0d;     //TimeSinceLastVelChange
        weights[7] = 10.0d;    //power
        weights[8] = 100.0d;     //last vel
        weights[9] = 10000.0d;     //Category
        weights[10] = 0.0d;     //FrontWallRatio
        weights[11] = 0.0d;     //RearWallRatio

        switch(dimension[9])
        {
            case 0:     //no walls
                weights[3] = 0.0d;    //center
                weights[4] = 0.0d;    //wall
                weights[5] = 0.0d;    //corner
                break;
            case 32:    //1 wall
                weights[1] = 10.0d;    //myBearing
                weights[3] = 10.0d;    //center
                weights[4] = 0.0d;    //wall
                weights[5] = 10.0d;    //corner
                weights[6] = 100.0d;   //TimeSinceLastVelChange
                weights[10] = 1000.0d;     //FrontWallRatio
                break;
                /*
            case 64:    //1 wall > corner
                weights[2] = 0.0d;     //vel
                weights[8] = 0.0d;     //last vel
                weights[3] = 100.0d;    //center
                weights[4] = 100.0d;    //wall
                weights[5] = 100.0d;    //corner
                weights[6] = 0.0d;    //TimeSinceLastVelChange
                weights[10] = 1000.0d;     //FrontWallRatio
                break;
                 **/
            case 95:    //2 wall / corner
                weights[1] = 10.0d;    //myBearing
                weights[3] = 10.0d;    //center
                weights[4] = 0.0d;    //wall
                weights[5] = 10.0d;    //corner
                weights[2] = 100.0d;     //vel
                weights[8] = 100.0d;     //last vel
                weights[6] = 1000.0d;   //TimeSinceLastVelChange
                weights[10] = 200.0d;     //FrontWallRatio
                weights[11] = 50.0d;     //RearWallRatio

                break;
            case 127:   //rear wall
                weights[3] = 0.0d;     //center
                weights[4] = 0.0d;    //wall
                weights[5] = 0.0d;     //corner
                weights[11] = 10.0d;     //RearWallRatio
                break;
        }    

        for(int i = 0; i < NumDimensions; i++)
        {
            result += (weights[i] * Math.pow(dimension[i] - other.dimension[i], 2));
        }
        
        return result;
    }
}
