package kawigi.sbf;
import robocode.*;
import kawigi.sbf.utils.*;
import kawigi.sbf.core.*;
import java.awt.geom.*;
import java.awt.Color;

/**
 * FloodHT - a robot by Kawigi.  About time I made a megabot.
 */
public class FloodHT extends TeamRobot implements Moveable
{
	/**
	 *	Main robot execution loop
	 **/
	public void run()
	{
		//the Flood has always been blue. I'm a little less attached than
		//I used to be.
		setColors(Color.blue,Color.red,Color.blue);
		setAdjustGunForRobotTurn(true);
		Utils.initRound(this);
		MeleeMovement.init();
		DuelMovement.init();
		TeamMovement.init();
		do
		{
			Utils.update();
			//Call radar logic:
			VolatileEnemy target = Utils.getCurrentTarget();
			RadarManager.doRadar(this, target);
			if (getOthers() == 1)
			{
				if (target != null)
					DuelMovement.move(this, target);
			}
			else if (Utils.isTeamGame())
				TeamController.doTeamMovement(this);
			else
				MeleeMovement.minimumRiskMovement(this);
			execute();
		}
		while (true);
	}
	
	public void onScannedRobot(ScannedRobotEvent e)
	{
		//get the volatile enemy object
		VolatileEnemy scannedRobot;
		if (isTeammate(e.getName()))
			return;
		else
			scannedRobot = Utils.getEnemy(e.getName());
		
		//update data and get targeting segmentation indexes
		scannedRobot.update(this, e);
		if (scannedRobot.lastShotTime == e.getTime()-1)
		{
			DuelMovement.fireSelfWave();
		}
		int[] indexes = scannedRobot.getSegmentIndexes();
		int[] segment = Utils.getStats(e.getName()).getSegment(indexes);
		if (!scannedRobot.teammate)
		{
			if (Utils.getCurrentTarget() == null || (Utils.getTargetRating(scannedRobot) < Utils.getTargetRating(Utils.getCurrentTarget()) && getGunHeat()/getGunCoolingRate() > 4))
				Utils.setCurrentTarget(scannedRobot);
			if (getEnergy() > 0)
				scannedRobot.updateWaves(segment, e.getTime(), indexes);
		}
		else
			out.println("Bug! I shouldn't be here if this is a teammate!");
		if (scannedRobot == Utils.getCurrentTarget())
		{
			int bestindex = segment.length/2;
			double absBearing = getHeadingRadians()+e.getBearingRadians();
			double power = Utils.getPower(scannedRobot);
			double gf1 = Math.asin(8/Utils.getBulletVelocity(power)) * scannedRobot.getLateralDirection();
			//Stay aimed at them if they enemy is disabled.
			if (scannedRobot.energy > 0)
				for (int i=0; i<31; i++)
				{
					double tempBearing = absBearing + gf1*(2.0*i/(segment.length-1)-1);
					//don't shoot into walls!  Ignore guessfactors to which my enemy can't possibly make it.
					if (Utils.inField(Utils.projectPoint(Utils.getMyLocation(), tempBearing, e.getDistance()*(Utils.getBulletVelocity(power)/(Utils.getBulletVelocity(power)+8)))) && segment[i] > segment[bestindex])
						bestindex = i;
				}
			double offset = gf1*(2.0*bestindex/(segment.length-1)-1);
			setTurnGunRightRadians(Utils.normalize(absBearing+offset-getGunHeadingRadians()));
			if (Math.abs(getGunTurnRemaining()) < 5)
			{
				//in one-on-one, add a weight to waves lined up with real bullets
				if (setFireBullet(power) != null && getOthers() == 1)
				{
					// Waves not aligned with real bullets are counted, but waves aligned
					// with real bullets are given more weight.
					scannedRobot.lastWave.weight = 6;
				}
			}
		}
	}
	
	public void onDeath(DeathEvent e)
	{
		Utils.uninitRound();
	}
	
	public void onWin(WinEvent e)
	{
		Utils.uninitRound();
		//victory dance!
	}
	
	public void onRobotDeath(RobotDeathEvent e)
	{
		Utils.robotDeath(e.getName());
	}
	
	public void onHitByBullet(HitByBulletEvent e)
	{
		if (!isTeammate(e.getName()))
		{
			VolatileEnemy enemy = Utils.getEnemy(e.getName());
			enemy.logHit(e.getTime());
			enemy.energy += e.getPower()*3;
			if (getOthers() == 1)
			{
				DuelMovement.hit(e.getBullet());
			}
		}
	}
	
	public void onBulletHit(BulletHitEvent e)
	{
		double power = e.getBullet().getPower();
		double damage = Math.max(4*power, 6*power-2);
		VolatileEnemy enemy = Utils.getEnemy(e.getName());
		enemy.energy -= damage;
	}
	
	public void onMessageReceived(MessageEvent e) 
	{
		TeamController.receiveMessage(e.getMessage());
	}
}
