package kawigi.sbf.core.messages;
import kawigi.sbf.utils.*;
import java.io.*;
import java.awt.geom.*;

public class EnemyUpdateMessage implements Serializable
{
	private String name;
	private double x, y, velocity, energy, heading;
	private long time;
	
	public EnemyUpdateMessage(VolatileEnemy enemy, long time)
	{
		this.name = enemy.name;
		x = enemy.getX();
		y = enemy.getY();
		velocity = enemy.velocity;
		energy = enemy.energy;
		heading = enemy.heading;
		this.time = time;
	}
	
	public Point2D getLocation()
	{
		return new Point2D.Double(x, y);
	}
	
	public String getName()
	{
		return name;
	}
	
	public double getVelocity()
	{
		return velocity;
	}
	
	public double getEnergy()
	{
		return energy;
	}
	
	public double getHeading()
	{
		return heading;
	}
	
	public long getTime()
	{
		return time;
	}
}