package kawigi.sbf.utils;
import java.util.*;
import java.awt.geom.*;
import robocode.*;
import kawigi.sbf.core.*;
import kawigi.sbf.core.messages.*;

public class VolatileEnemy extends Point2D.Double
{
	public double heading, velocity, velocityChange, energy, lastBulletPower, lastMoveDirection;
	public long lastHitTime, lastScanTime, lastScanDelay, lastNewMovementTime, lastShotTime;
	public ArrayList bullets;
	public boolean leader, droid, teammate, targetingMe, firstUpdate;
	public WaveBullet lastWave, lastRemovedWave;
	public String name;
	public Point2D lastMyLocation;
	public VolatileEnemy currentTarget;
	
	public VolatileEnemy()
	{
		bullets = new ArrayList();
		lastMoveDirection = 1;
		lastBulletPower = 3;
		firstUpdate = true;
		energy = 100;
	}
	
	public void update(TeamRobot robot, ScannedRobotEvent e)
	{
		name = e.getName();
		double energydiff = energy-e.getEnergy();
		energy = e.getEnergy();
		if (energydiff > .0999 && energydiff <= 3)
		{
			lastShotTime = e.getTime()-1;
			lastBulletPower = energydiff;
		}
		//update current state:
		setLocation(Utils.projectPoint(Utils.getMyLocation(), robot.getHeadingRadians() + e.getBearingRadians(), e.getDistance()));
		lastScanDelay = e.getTime() - lastScanTime;
		lastScanTime = e.getTime();
		velocityChange = e.getVelocity()-velocity;
		if (Math.abs(velocityChange) >= .5)
			lastNewMovementTime = e.getTime();
		velocity = e.getVelocity();
		heading = e.getHeadingRadians();
		if (velocity != 0)
		{
			lastMoveDirection = (velocity < 0) ? -1 : 1;
		}
		
		//guessing their "team" status:
		if (firstUpdate)
		{
			if (e.getEnergy() >= 180)
				leader = true;
			if (e.getEnergy()%100 > 15 && e.getEnergy()%100 < 30)
				droid = true;
			teammate = robot.isTeammate(e.getName());
		}
		firstUpdate = false;
		if (Utils.isTeamGame())
		{
			TeamController.sendMessage(new EnemyUpdateMessage(this, e.getTime()));
		}
	}
	
	//update for self:
	public void update(TeamRobot robot)
	{
		name = robot.getName();
		double energydiff = energy-robot.getEnergy();
		energy = robot.getEnergy();
		if (energydiff > .0999 && energydiff <= 3)
		{
			lastShotTime = robot.getTime()-1;
			lastBulletPower = energydiff;
		}
		//update current state:
		setLocation(robot.getX(), robot.getY());
		lastScanDelay = robot.getTime() - lastScanTime;
		lastScanTime = robot.getTime();
		velocityChange = robot.getVelocity()-velocity;
		if (Math.abs(velocityChange) >= .5)
			lastNewMovementTime = robot.getTime();
		velocity = robot.getVelocity();
		heading = robot.getHeadingRadians();
		if (velocity != 0)
		{
			lastMoveDirection = (velocity < 0) ? -1 : 1;
		}
		
		//guessing their "team" status:
		if (firstUpdate)
		{
			if (robot.getEnergy() >= 180)
				leader = true;
			if (robot.getEnergy()%100 > 15 && robot.getEnergy()%100 < 30)
				droid = true;
			teammate = true;
		}
		firstUpdate = false;
	}
	
	//update for team message:
	public void update(EnemyUpdateMessage update)
	{
		if (update.getTime() == lastScanTime)
			return;
		name = update.getName();
		double energydiff = energy-update.getEnergy();
		energy = update.getEnergy();
		if (energydiff > .0999 && energydiff <= 3)
		{
			lastShotTime = update.getTime()-1;
			lastBulletPower = energydiff;
		}
		//update current state:
		setLocation(update.getLocation());
		lastScanDelay = update.getTime() - lastScanTime;
		lastScanTime = update.getTime();
		velocityChange = update.getVelocity()-velocity;
		if (Math.abs(velocityChange) >= .5)
			lastNewMovementTime = update.getTime();
		velocity = update.getVelocity();
		heading = update.getHeading();
		if (velocity != 0)
		{
			lastMoveDirection = (velocity < 0) ? -1 : 1;
		}
		
		//guessing their "team" status:
		if (firstUpdate)
		{
			if (update.getEnergy() >= 180)
				leader = true;
			if (update.getEnergy()%100 > 15 && update.getEnergy()%100 < 30)
				droid = true;
			teammate = false;
		}
		firstUpdate = false;
	}
	
	public int[] getSegmentIndexes()
	{
		boolean melee = Utils.getRobot().getOthers() != 1;
		int[] indexes = new int[(melee ? Utils.meleeSegmentSizes.length : Utils.segmentSizes.length)+1];
		indexes[0] = Utils.getRobot().getOthers() == 1 ? 0 : 1;
		
		//same indexes for melee and one-on-one.
		
		//wall segmentation:
		indexes[1] = Utils.inField(Utils.projectPoint(this, heading, lastMoveDirection*80)) ? 0 : 1;
		
		//acceleration segmentation:
		//0 means the sign of the velocity == -the sign of the velocity change (decelerating)
		//1 means the velocity change was roughly zero
		//2 means the sign of the velocity and velocity change are about the same
		indexes[2] = (int)(lastMoveDirection*Math.min(1, Math.max(-1, velocityChange)))+1;
		//If I'm not getting that frequent of scans and the velocity is 8, they're most likely
		//moving at constant velocity.
		if (Math.abs(velocity) > 7.9 && lastScanDelay > 3)
			indexes[2] = 1;
		
		//lateral direction segmentation:
		double latd = Math.cos(heading-Utils.angle(this, Utils.getMyLocation()));
		indexes[3] = (int)(latd*lastMoveDirection*1.4+1.4);
		double bft = distance(Utils.getMyLocation())/Utils.getBulletVelocity(Utils.getPower(this));
		if (melee)	//insert melee-specific segments:
		{
			int best = 0;
			double angle = Utils.angle(this, Utils.getMyLocation());
			for (int i=0; i<Utils.meleeSegmentSizes[3]; i++)
				if (MeleeMovement.rawAntigravityAtPoint(Utils.projectPoint(this, angle+i*Math.PI*2/Utils.meleeSegmentSizes[3]*getLateralDirection(), 100), this) < MeleeMovement.rawAntigravityAtPoint(Utils.projectPoint(this, angle+best*Math.PI*2/Utils.meleeSegmentSizes[3]*getLateralDirection(), 100), this))
					best = i;
			indexes[4] = best;
		}
		else	//insert 1-on-1-specific segments:
		{
			//velocity segmentation:
			indexes[4] = (int)Math.abs(Math.sin(heading-Utils.angle(this, Utils.getMyLocation()))*velocity/3);
			//time segmentation:
			indexes[5] = (int)Math.min(3, (lastScanTime-lastNewMovementTime)*3/bft);
			//direction segmentation:
			//indexes[6] = (getLateralDirection() < 0) == (DuelMovement.getDirection() < 0) ? 0 : 1;
		}
		
		// For some reason, I traditionally make bft (/distance) the last segmentation:
		indexes[indexes.length-1] = (int)Math.min(9, bft/10);
		return indexes;
	}
	
	public int[] getSelfSegmentIndexes(VolatileEnemy fromEnemy)
	{
		int[] indexes = new int[Utils.selfSegmentSizes.length+1];
		//melee or one-on-one:
		indexes[0] = Math.min(Utils.getRobot().getOthers()-1, 1);
		
		//wall segmentation:
		indexes[1] = Utils.inField(Utils.projectPoint(this, heading, lastMoveDirection*80)) ? 0 : 1;
		
		//acceleration segmentation:
		indexes[2] = (int)(lastMoveDirection*Math.min(1, Math.max(-1, velocityChange)))+1;
		
		//lateral velocity segmentation:
		double latv = Math.sin(heading-Utils.angle(this, fromEnemy));
		indexes[3] = (int)Math.abs(latv/3);

		//time segmentation:
		double bft = distance(fromEnemy)/Utils.getBulletVelocity(fromEnemy.lastBulletPower);
		indexes[4] = (int)Math.min(3, (lastScanTime-lastNewMovementTime)*3/bft);
		
		// bft:
		indexes[5] = (int)Math.min(9, bft/10);
		return indexes;
	}
	
	public void updateWaves(int[] segment, long time, int[] indexes)
	{
		for (int i=0; i<bullets.size(); i++)
		{
			WaveBullet wave = (WaveBullet)bullets.get(i);
			if (wave.updateEnemy(this, time))
			{
				TeamController.sendMessage(new WaveHitMessage(name, wave.getGF(), wave.getIndexes()));
				if (wave.weight > 1)
					lastRemovedWave = wave;
				bullets.remove(i);
				i--;
			}
		}
		bullets.add(lastWave = new WaveBullet(this, time, segment, indexes));
	}
	
	public void updateWaves(int[] segment, long time, VolatileEnemy from, int[] indexes)
	{
		for (int i=0; i<bullets.size(); i++)
		{
			WaveBullet wave = (WaveBullet)bullets.get(i);
			if (wave.updateEnemy(this, time))
			{
				if (wave.weight > 0)
					lastRemovedWave = wave;
				bullets.remove(i);
				i--;
			}
		}
		bullets.add(lastWave = new WaveBullet(Utils.getRobot(), from, segment, time, getLateralDirection(from), from.lastBulletPower, indexes));
	}
	
	public double getLateralDirection(VolatileEnemy from)
	{
		double latv = Math.sin(heading-Utils.angle(this, from))*lastMoveDirection;
		if (latv < 0)
			return -1;
		else
			return 1;
	}
	
	public double getLateralDirection()
	{
		double latv = Math.sin(heading-Utils.angle(this, Utils.getMyLocation()))*lastMoveDirection;
		if (latv < 0)
			return -1;
		else
			return 1;
	}
	
	public void logHit(long time)
	{
		lastHitTime = time;
	}
}
