package ags.muse.recon.events;

import robocode.ScannedRobotEvent;
import ags.util.points.*;

public class ScanReconEvent extends ReconEvent {
    private static final long serialVersionUID = 1L;

    // Constructor
    public ScanReconEvent(SelfReconEvent selfReconEvent, ScannedRobotEvent scan) {
        // Create the ReconEvent from the ScannedRobotEvent
        super(
                scan.getTime() - 1, 
                scan.getName(),
                selfReconEvent.getLocation().addRelativePoint(RelativePoint.fromDM(selfReconEvent.getVelocity().direction+scan.getBearingRadians(), scan.getDistance())),
                RelativePoint.fromDM(scan.getHeadingRadians(), scan.getVelocity()),
                scan.getEnergy()
        );
    }

}
