package bayen.nano;

//Import the neccessary classes
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.HitByBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitWallEvent;

//Import a utility class
import robocode.util.Utils;

/**
 * Squirrel - a robot by Bayen
 *
 * Codesize Reduction Help:  Voidious (Thanks!)
 */
public class Squirrel extends AdvancedRobot
{
	//CONSTANTS:
	private static final double RADAR_EXTRA = 2.2;
	private static final double RIGHT_ANGLE = 1.57;
	private static final double POSITIVE_ONE = 1.0;
	private static final double NEGATIVE_ONE = -1.0;
	private static final double ZERO = 0.0;
	private static final double BULLET_POWER = 3.0;
	private static final double EIGHT = 8.0;
	private static final double SIXTEEN = 16.0;
	private static final double ONE_TENTH = 0.1;
	private static final double HUNDRED = 100.0;
	private static final double THIRTEEN = 13.0;

	//VARIABLES:
	private static double _gunCheck;
	private static double _moveCheck = NEGATIVE_ONE;
	private static double _energy = HUNDRED;
	private static double _direction = POSITIVE_ONE;
	
	public void run() {
		/*
		 * To start off, I simply spin my radar around
		 * in circles until I scan an enemy.
		 */
		do {
			turnRadarRightRadians(HUNDRED);
		} while(true);
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		/*
		 * ONSCANNEDROBOT() - I do most of my calculating and actions here during the scan,
		 *                    since now is when I have the most information about the enemy
		 *                    robot.
		 */

		/*
		 * I start every scan by declaring a couple of useful variables.  I'll use them later.
		 */
		double bearing;
		double difference;
		
		/*
		 * MOVEMENT - I actually have two movement patterns.  The default pattern is to circle the enemy
		 *            and continue to do so throughout the match.  The alternative movement calculates when
		 *            the enemy fires and changes direction there, in attempt to dodge the bullet.
		 */
		
		/*
		 * To begin my movement, I turn myself perpendicular to the enemy.  I use a SET method, so that
		 * the turn does not execute yet, but it will at the same time as all of my other SET commands.
		 */
		setTurnRightRadians((bearing = e.getBearingRadians()) + RIGHT_ANGLE);
		
		/*
		 * The second part of my movement is the actual forwards or backwards motion.  I set myself to go
		 * one hundred pixels, then I determine the direction based on which movement pattern I am currently
		 * using and if they have fired this turn.
		 */
		setAhead(HUNDRED * (_direction *= ((difference = _energy - (_energy = e.getEnergy())) <= BULLET_POWER && difference > ONE_TENTH?_moveCheck:POSITIVE_ONE)));
		
		/*
		 * RADAR - I use a simple radar lock that creates a scan arc around the enemy from which they cannot
		 *         escape.  This means I get to scan them every turn, so I get to do all this every turn.
		 */
		setTurnRadarRightRadians(Utils.normalRelativeAngle(((bearing += getHeadingRadians()) - getRadarHeadingRadians()) * RADAR_EXTRA));

		/*
		 * TARGETING - I also have two targeting methods in this robot.  The first method is a simple
		 *             linear predictor, which fires at where the enemy will be if they continue moving
		 *             in the same direction and at the same velocity as they are now.  The second is
		 *             fire at where they will be at a random velocity.
		 */
		setTurnGunRightRadians(Utils.normalRelativeAngle(bearing - getGunHeadingRadians() + ((_gunCheck<ZERO?((Math.random() * SIXTEEN) - EIGHT):e.getVelocity()) * Math.sin(e.getHeadingRadians() - bearing) / THIRTEEN)));
		
		/*
		 * Then I fire a bullet.
		 */
		setFire(BULLET_POWER);
	}

	public void onHitByBullet(HitByBulletEvent e) {
		/*
		 * ONHITBYBULLET() - update my information about the current movement method.
		 */
		_moveCheck *= NEGATIVE_ONE;
	}
	
	public void onBulletHit(BulletHitEvent e) {
		/*
		 * ONBULLETHIT() - update my information about the current targeting method.
		 */
		_gunCheck -= (_gunCheck<ZERO?POSITIVE_ONE:NEGATIVE_ONE);
	}
	
	public void onBulletMissed(BulletMissedEvent e) {
		/*
		 * ONBULLETHIT() - update my information about the current targeting method.
		 */
		_gunCheck += (_gunCheck<ZERO?POSITIVE_ONE:NEGATIVE_ONE);
	}
	
	public void onHitWall(HitWallEvent e) {
		/*
		 * Change Direction
		 */
		_direction *= NEGATIVE_ONE;
	}
	
}

