package sgp;
import robocode.*;
import java.util.*;

/**
 * PatternIntercept - a class by Simon Parker
 */

public class PatternIntercept extends LinearIntercept implements java.io.Serializable
{
	PatternAnalyser analyser;
	public PatternIntercept(PatternAnalyser patternAnalyser)
	{
		analyser = patternAnalyser;
	}

	protected Coordinate getEstimatedPosition(double time)
	{
		Coordinate relativeNormalisedPosition = analyser.getEstimatedDeltaPosition(targetVelocity, time);
		Coordinate relativeAbsolutePosition = relativeNormalisedPosition.rotate(targetHeading);
		return Strategy.limitToBattleField(targetStartingPoint.plus(relativeAbsolutePosition));
	}
}