package doka;

import robocode.*;
import robocode.util.*;
import java.awt.*;
import java.awt.geom.*;
import java.util.ArrayList; 


// API help : http://robocode.sourceforge.net/docs/robocode/robocode/Robot.html

class DataPoint {
	// public double distance;
	// public double lateralVelocity;
	// public double distanceToWall;
	public double[] coord;
	public double guessfactor;

	public static double distanceSquared(DataPoint a, DataPoint b){
		double d = 0;
		for (int i = 0; i < a.coord.length; i++) {
			d += (a.coord[i]-b.coord[i])*(a.coord[i]-b.coord[i]);
		}
		return d;
	}
}

class KNN {
	public static DataPoint[] nearestneighbours(ArrayList<DataPoint> allPoints, DataPoint currentPoint, int numNeighbours){
		DataPoint[] nearestPoints = new DataPoint[numNeighbours];

		if(allPoints.size() < numNeighbours){
			return null;
		}

		// fill nearestPoints with the first <numNeighbours> points from allPoints
		for (int x = 0; x < nearestPoints.length; x++) {
			nearestPoints[x] = allPoints.get(x);
		}

		double[] nearestDistancesSq = new double[numNeighbours];
		nearestDistancesSq[0] = DataPoint.distanceSquared(currentPoint, nearestPoints[0]);
		double longestDistanceSq = nearestDistancesSq[0];
		int longestIndex = 0;

		// for x = 1 to numNeighbours-1
		for (int x = 1; x < numNeighbours; x++) {
			nearestDistancesSq[x] = DataPoint.distanceSquared(currentPoint, nearestPoints[x]);
			if (nearestDistancesSq[x] > longestDistanceSq){
				longestDistanceSq = nearestDistancesSq[x];
				longestIndex = x;
			}
		}

		// for x = numNeighbours to allPoints.length-1
		for (int x = numNeighbours; x < allPoints.size(); x++) {
			double thisDistanceSq = DataPoint.distanceSquared(currentPoint, allPoints.get(x));
			if (thisDistanceSq < longestDistanceSq){
				nearestPoints[longestIndex] = allPoints.get(x);
				nearestDistancesSq[longestIndex] = thisDistanceSq;
				// find the new maximum value in nearestDistancesSq
				// 	set longestDistanceSq to the maximum value
				// 	set longestIndex to the array index of the maximum value
				for (int i = 0; i < nearestDistancesSq.length; i++) {
					if (nearestDistancesSq[i] > longestDistanceSq){
						longestDistanceSq = nearestDistancesSq[i];
						longestIndex = i;
					}
				}
			}
		}

		return nearestPoints;
	}
}

class Wave {
	double bulletPower;
	Point2D gunLocation;
	double bearing;
	double distanceTraveled;
	int direction;

	DataPoint enemyData;
 
	public void advance() {
		distanceTraveled += Rules.getBulletSpeed(bulletPower);
	}

	public boolean hasArrived(Point2D targetLocation) {
		if(distanceTraveled > gunLocation.distance(targetLocation) - 18){
			double desiredDirection = Math.atan2(targetLocation.getX() - gunLocation.getX(), targetLocation.getY() - gunLocation.getY());
			double angleOffset = Utils.normalRelativeAngle(desiredDirection - bearing);
			double escapeAngle = Math.asin(8 / Rules.getBulletSpeed(bulletPower));
			double guessFactor = Math.max(-1, Math.min(1, angleOffset / escapeAngle)) * direction;

			enemyData.guessfactor = guessFactor;

			// int index = (int) Math.round((returnSegment.length - 1) /2 * (guessFactor + 1));
			// // returnSegment[index]++;
			// readings++;
			// returnSegment[index] = ((returnSegment[index] * (Math.min(readings, 200) - 1) + 1) / Math.min(readings, 200));
			return true;
		}
		return false;
	}
}


public class ShinigamiKNN extends AdvancedRobot
{
	// <UTILS>
	// private double limit(double a, double min, double max){
	// 	return Math.min(max, Math.max(min, a));
	// }

	private double toRad(double angle){
		return angle*Math.PI/180;
	}
	private Point2D project(Point2D sourceLocation, double angle, double length) {
		return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length,
				sourceLocation.getY() + Math.cos(angle) * length);
	}
	
	private double absoluteBearing(Point2D source, Point2D target) {
		return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
	}
	// </UTILS>

	public void run() {
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setColors(Color.black,Color.black,Color.black,Color.black,Color.black); // body,gun,radar,bullet,scanarc

		myWaves = new ArrayList<Wave>();

		// enemyDataPoints = new ArrayList<DataPoint>();

		turnRadarRightRadians(Double.POSITIVE_INFINITY);

		// Robot main loop
		while(true) {
			scan();
			execute();
		}
	}

	// targeting
	ArrayList<Wave> myWaves;

	// KNN data
	static ArrayList<DataPoint> enemyDataPoints = new ArrayList<DataPoint>();

	// vars for tracking enemy data
	int enemyDirection = 1;
	int enemyVelocity = 0;


	// movement
	boolean stopandgo = true;
	int timesHit = 0;
	int dir = 1;

	double prevEnergy = 100.0;

	//                              0.0 0.5 1.0 1.5 2.0 2.5 3.0
	//                              0   1   2   3   4   5   6
	static int[] travelDistLookup = {19, 27, 33, 37, 48, 56, 64};

	public void onScannedRobot(ScannedRobotEvent e) {
		//radar lock
		double radarTurn = getHeadingRadians() + e.getBearingRadians() - getRadarHeadingRadians();
		setTurnRadarRightRadians(1.9 * Utils.normalRelativeAngle(radarTurn));

		// general variables
		double enemyAbsoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double enemyDistance = e.getDistance();
		Point2D robotLocation = new Point2D.Double(getX(), getY());
		Point2D enemyLocation = project(robotLocation, enemyAbsoluteBearing, enemyDistance);
		Rectangle2D fieldRectangle = new Rectangle2D.Double(16, 16, getBattleFieldWidth()-32, getBattleFieldHeight()-32);

		
		//targeting
		double bulletPower = 2.49;
	 
		// dont use high power bullets if a smaller one will kill the enemy anyway
		bulletPower = Math.min(bulletPower, e.getEnergy()/4.0);
		// double bulletPower = Math.max(0.1,Math.random() * 3.0);
		double headOnBearing = getHeadingRadians() + e.getBearingRadians();
		
		// double linearBearing = headOnBearing + Math.asin(e.getVelocity() / Rules.getBulletSpeed(bulletPower) * Math.sin(e.getHeadingRadians() - headOnBearing));
		
		double escapeAngle = Math.asin(8 / Rules.getBulletSpeed(bulletPower));
		// double randomAimOffset = -escapeAngle + Math.random() * 2 * escapeAngle;



		// process waves currently in the air
		for (int i = 0; i < myWaves.size(); i++) {
			Wave w = (Wave)myWaves.get(i);
			w.advance();
			if(w.hasArrived(enemyLocation)){
				// add point to collection
				enemyDataPoints.add(w.enemyData);
				myWaves.remove(i);
				i--;
			}
		}

		// track enemy orbit direction
		// don't try to figure out the direction they're moving 
		// if they're not moving, just use the direction we had before
		if (e.getVelocity() != 0)
		{
			if (Math.sin(e.getHeadingRadians()-headOnBearing)*e.getVelocity() < 0)
				enemyDirection = -1;
			else
				enemyDirection = 1;
		}

		// calculate enemy data
		DataPoint enemyData = new DataPoint();
		enemyData.coord = new double[5];
		// distance to enemy
		enemyData.coord[0] = Math.min(e.getDistance(), 800) / 800;
		// enemy distance to wall
		Point2D enemyDestination;
		double enemyHeading = e.getHeadingRadians() + ((Math.signum(e.getVelocity()) == -1) ? Math.PI : 0);
		enemyData.coord[1] = 1;
		double maxWallDist = 200;
		for(int dist = 0; dist < maxWallDist; dist += 10){
			enemyDestination = project(enemyLocation, enemyHeading, dist);
			if (!fieldRectangle.contains(enemyDestination)){
				enemyData.coord[1] = dist / maxWallDist;
				break;
			}
		}
		// enemy lateral velocity
		double enemyLateralVelocity = e.getVelocity() * Math.sin(e.getHeadingRadians() - headOnBearing);
		enemyData.coord[2] = Math.abs(enemyLateralVelocity) / 8;
		// enemy advancing velocity
		double enemyAdvancingVelocity = e.getVelocity() * -1 * Math.cos(e.getHeadingRadians() - headOnBearing);
		enemyData.coord[3] = Math.abs(enemyAdvancingVelocity) / 8;
		// my gun heat
		enemyData.coord[4] = Math.min(1.5, getGunHeat()) / 1.5;


		// figure out what shot to take
		DataPoint[] neighbours = KNN.nearestneighbours(enemyDataPoints, enemyData, (int)Math.max(1,Math.sqrt(enemyDataPoints.size())));
		// System.out.println(enemyDataPoints.size() + " " + (neighbours == null ? -1 : neighbours.length));

		// TODO: do something fancy here to produce a guessfactor using the neighbours
		// double guessfactor = 0;
		// if(neighbours != null){
		// 	guessfactor = neighbours[0].guessfactor;
		// }
		// System.out.println(guessfactor);
		double guessfactor = 0;
		if(neighbours != null){
			int[] bins = new int[32];
			for(int i = 0; i < neighbours.length; i++){
				int index = (int)(((neighbours[i].guessfactor+1)/2)*32);
				bins[index] += 3;
				if(index > 0)
					bins[index-1] += 1;
				if(index < 31)
					bins[index+1] += 1;

			}
			int bestVal = -1;
			int bestIndex = 0;
			for (int i = 0; i < bins.length; i++) {
				if(bins[i] > bestVal){
					bestVal = bins[i];
					bestIndex = i;
				}
			}
			// System.out.println(((double)bestVal)/neighbours.length*100);
			guessfactor = ((double)bestIndex)/32*2-1;
			// System.out.println(guessfactor);
		}


		// calculate angle from the guessfactor
		double angleOffset = enemyDirection * guessfactor * escapeAngle;

		// if the enemy is disabled, shoot head-on
		if(e.getEnergy() <= 0){
			angleOffset = 0;
		}

		double gunAdjust = Utils.normalRelativeAngle(headOnBearing + angleOffset - getGunHeadingRadians());

		// anti bullet-shielding
		// just add a little random offset
		// we use this calculation to scale the angle to the distance of the enemy
		// the constant inside the atan is the amount of pixels we can be off to either side
		gunAdjust += (Math.random()*2-1)*Math.atan(2/enemyDistance);

		setTurnGunRightRadians(gunAdjust);


		// fire if we can and keep track of my shots (waves)
		if (getGunHeat() == 0 && gunAdjust < Math.atan(9/e.getDistance()) && setFireBullet(bulletPower) != null)
		{
		}
			Wave wave = new Wave();
			wave.gunLocation = new Point2D.Double(getX(), getY());
			wave.bulletPower = bulletPower;
			wave.bearing = headOnBearing;
			wave.direction = enemyDirection;

			// save enemy data at this time

			// add data to this wave
			wave.enemyData = enemyData;

			// save wave
			this.myWaves.add(wave);
		// }





		// movement

		double traveldist = 0;

		// if we're losing, change to alternative movement
		// if(getEnergy() < 50 && e.getEnergy() > getEnergy()){
		if(timesHit >= 2/* && e.getEnergy() > getEnergy()*/){
			stopandgo = false;
		}

		double dEnergy = prevEnergy-e.getEnergy();
		prevEnergy = e.getEnergy();
		if(stopandgo){
			// check if the enemy fired
			if(getDistanceRemaining() == 0.0 && dEnergy > 0 && dEnergy <= 3.0){
				// look up distance we can travel before the enemy can fire again
				traveldist = travelDistLookup[(int)(dEnergy*2)];
			}
		}else{
			traveldist = 100;
			// if(Math.random() < 0.05){
			// 	setMaxVelocity(Math.random()*8+4);
			// 	System.out.println("velocity changed");
			// }
		}

		Point2D robotDestination;

		final double MAX_TRIES = 125;
		final double DEFAULT_EVASION = 1.2;
		final double WALL_BOUNCE_TUNER = 0.699484;
		final double DIR_ANGLE = 0.4;

		// Rectangle2D fieldRectangle = new Rectangle2D.Double(18, 18, getBattleFieldWidth()-36, getBattleFieldHeight()-36);
		double tries = 0;
		do{
			robotDestination = project(enemyLocation, enemyAbsoluteBearing + Math.PI + DIR_ANGLE*dir, enemyDistance * (DEFAULT_EVASION - tries / 100.0));
			tries++;
		}
		while (!fieldRectangle.contains(robotDestination) && tries < MAX_TRIES);

		//if (/*Math.random() < (GFTUtils.bulletVelocity(enemyFirePower) / REVERSE_TUNER) / enemyDistance ||*/
		//		tries > (enemyDistance / GFTUtils.bulletVelocity(enemyFirePower) / WALL_BOUNCE_TUNER)) {
		//	direction = -direction;
		//}
		boolean changeDir = false;
		double bulletSpeed = 11;//Rules.getBulletSpeed(dEnergy);
		// don't randomly change direction when using stop&go to avoid being hit by head-on targeting
		if (!stopandgo &&  Math.random() < ( bulletSpeed / 0.421075) / enemyDistance) {
			changeDir = true;
		}
		// dir = Math.random() < .5 ? -1 : 1;
		if(tries > (enemyDistance / bulletSpeed / WALL_BOUNCE_TUNER)) {
			changeDir = true;
		}

		if(changeDir)
			dir *= -1;

		// System.out.println(tries);
		// Jamougha's cool way
		double turn = absoluteBearing(robotLocation, robotDestination) - getHeadingRadians();



		// double moveoffset = 0;
		// double dDist = e.getDistance()-300;
		// // uses a sigmoid curve to smoothly calculate and offset angle and also limit it to a maximum angle
		// double x = dDist/75;
		// moveoffset = -toRad(30)*(x/Math.sqrt(1+x*x));


		// double moveangle = getHeadingRadians() + e.getBearingRadians() - dir*(toRad(90) + moveoffset);

		// //change direction if we're gonna hit a wallotherwise
		// double stick = 150;
		// Rectangle2D fieldRect = new Rectangle2D.Double(18, 18, getBattleFieldWidth()-36, getBattleFieldHeight()-36);
		// if (!fieldRect.contains(getX()+Math.sin(moveangle)*stick, getY()+ Math.cos(moveangle)*stick))
		// {
		// 	dir *= -1;
		// 	moveangle = getHeadingRadians() + e.getBearingRadians() - dir*(toRad(90) + moveoffset);
		// 	System.out.println(".");
		// }
		// double turn = moveangle-getHeadingRadians();

		// I don't know how, but this works...
		if(traveldist != 0)
			setAhead(Math.signum(Math.cos(turn))*traveldist);
		setTurnRightRadians(Math.tan(turn));

		
	}

	//When our bullet hits them, they lose energy
	public void onBulletHit(BulletHitEvent e) {
		prevEnergy -= Rules.getBulletDamage(e.getBullet().getPower());
	}
	//When we get hit by the enemies bullet, they gain energy
	public void onHitByBullet(HitByBulletEvent e) {
		prevEnergy += Rules.getBulletHitBonus(e.getPower());
		timesHit++;
	}

	public void onSkippedTurn(SkippedTurnEvent event){
		System.out.println("You dun fucked up... Make me faster!");
	}


	public void onPaint(Graphics2D g) {
		// Set the paint color to red
		g.setColor(java.awt.Color.RED);
		// Paint a filled rectangle at (50,50) at size 100x150 pixels
		// g.fillRect(50, 50, 100, 150);
		for (int i = 0; i < myWaves.size(); i++) {
			Wave w = (Wave)myWaves.get(i);
			Ellipse2D.Double circle = new Ellipse2D.Double(w.gunLocation.getX()-w.distanceTraveled, w.gunLocation.getY()-w.distanceTraveled, w.distanceTraveled*2, w.distanceTraveled*2);
			g.draw(circle);
		}
	}
}
