package trab.utils;

import java.awt.geom.*;

public class Wave extends Object {

  private Point2D.Double waveSource;
  private Point2D.Double targetAtSpawn;
  
  private double bulletPower;
  private double bulletSpeed;
  private double waveRadius;
  private double bearingDirection;
  
  private boolean isDead;
  private int deadTime;
  
  public Wave( Point2D source, Point2D target, double bulletPwr, double bearDir  )
  {
    waveSource = (Point2D.Double)source.clone();
    targetAtSpawn = (Point2D.Double)target.clone();
  
    bulletPower = bulletPwr;
    bulletSpeed = 20 - bulletPower * 3;
    
    bearingDirection = bearDir;
  
    waveRadius = 0;
    
    deadTime = 0;
    isDead = false;
  }
  
  public void advance( int ticks ) {
    if ( isDead ) {
      deadTime += ticks;
    }  
    else {
      waveRadius += bulletSpeed * ticks;  
    }
  }

  public boolean hasHit( Point2D target ) {
    
    if ( isDead )
      return false;
    
    Ellipse2D.Double ellipse = new Ellipse2D.Double( waveSource.getX()-waveRadius, waveSource.getY()-waveRadius, 2*waveRadius, 2*waveRadius );
    Rectangle2D.Double hitbox = new Rectangle2D.Double( target.getX()-16, target.getY()-16, 38, 38 );
    
    return ellipse.intersects( hitbox.getX(), hitbox.getY(), hitbox.getWidth(), hitbox.getHeight() );
    
    /*
    return ellipse.intersects( hitbox.getX(), hitbox.getY(), hitbox.getWidth(), hitbox.getHeight() ) ||
           ellipse.contains( hitbox.getX(), hitbox.getY(), hitbox.getWidth(), hitbox.getHeight() );
    */
    
    //return waveRadius+18+bulletSpeed >= waveSource.distance( target ); // is this correct?  
  }
  
  public double getGuessFactor( Point2D newTarget ) {
    
    double a = Utils.absoluteBearing( waveSource, newTarget ) - Utils.absoluteBearing( waveSource, targetAtSpawn );
    double f = Utils.normalRelativeAngle(a) / Utils.maxEscapeAngle( bulletSpeed );
    
    if ( bearingDirection != 0 )
      f *= bearingDirection;
    else
      f = Math.abs( f );
    
    return f;
  }
  public double getMinGF( Point2D target ) {
    
    double abs = Utils.absoluteBearing( waveSource, target );
    double d = waveSource.distance( target );
    double a = Math.atan( 18/d ) * -bearingDirection;
    double len = Math.sqrt( d*d + 18*18 );
    
    return getGuessFactor( Utils.project( waveSource, abs+a, len ) );
  }
  public double getMaxGF( Point2D target ) {
    
    double abs = Utils.absoluteBearing( waveSource, target );
    double d = waveSource.distance( target );
    double a = Math.atan( 18/d ) * +bearingDirection;
    double len = Math.sqrt( d*d + 18*18 );
    
    return getGuessFactor( Utils.project( waveSource, abs+a, len ) );
  }
  
  
  
  // this isnt 100% accurate!!
  public double impactEta( Point2D target ) {
    return ( distance( target ) -38 ) / bulletSpeed;
  }
  
  public final double distance( Point2D target ) { // maybe do -18 or something
    return waveSource.distance( target ) - waveRadius - 18;
  }
  public final Point2D getSource() {
    return waveSource;
  }
  public final Point2D getTarget() {
    return targetAtSpawn;
  }
  public final double getSpeed() {
    return bulletSpeed;
  }
  public final double getBulletPower() {
    return bulletPower;
  }
  
  public final double getRadius() {
    return waveRadius;
  }
  
  public double getLowGfAngle() {
    return Utils.absoluteBearing( waveSource, targetAtSpawn ) - Utils.maxEscapeAngle( bulletSpeed ) * bearingDirection;
  }
  public double getAngleSector() {
    return Utils.maxEscapeAngle( bulletSpeed ) * 2 * bearingDirection;
  }

  public final boolean isDead() {
    return isDead;  
  }

  public void kill() {
    isDead = true;
  }
  public final int deadTime() {
    return deadTime;  
  }
}