package tm;
import robocode.*;

/********************************************************************
* BulletTracker.java -- Ceǐ
*                        ͂ꎞCGCxZo
*
* Originated by Ray Vermette
*
********************************************************************/
public class BulletTracker extends Condition {
	private long expectedTimeOfImpact;
	private String targetName;
	private Bullet bullet;
	private AdvancedRobot myRobot;
	private int aimMethod;
	private boolean hitTarget;
	double iniEneX, iniEneY;		//Gʒu
	private double timeToImpact;
	
	//------------------------------------------------------------------
	// constructor
	//
	//
	//------------------------------------------------------------------
	public BulletTracker(AdvancedRobot ar, Bullet b, Enemy enemy, long timeToImpact, int aimMethod) {
		if (b != null) {
			this.myRobot = ar;
			this.bullet = b;
			this.targetName = enemy.getName();
			this.expectedTimeOfImpact = ar.getTime() + timeToImpact;
			this.aimMethod = aimMethod;
			this.hitTarget = false;
			this.timeToImpact = timeToImpact;
			this.iniEneX = enemy.getX();
			this.iniEneY = enemy.getY();
			myRobot.addCustomEvent(this);
		}
	}
	

	//------------------------------------------------------------------
	// getXXX()
	//
	//
	//------------------------------------------------------------------
	public long getExpectedTimeOfImpact() { return expectedTimeOfImpact; }
	public String getTargetName() { return targetName; }
	public Bullet getBullet() { return bullet; }
	public int getAimMethod() { return aimMethod; }
	public boolean hitTarget() { return hitTarget; }
	public double getTimeToImpact() { return timeToImpact; }
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public boolean test() {
		if (targetName.equals(bullet.getVictim())) {
			hitTarget = true;
			myRobot.removeCustomEvent(this);
			return true;
		}
		
		if (bullet.getVictim() != null) {
			myRobot.removeCustomEvent(this);
		}
		
		if (expectedTimeOfImpact <= myRobot.getTime()) {
			hitTarget = false;
			myRobot.removeCustomEvent(this);
			return true;
		}
		
		return false;
	}
}