/*
 * Created on 03/09/2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package axeBots;

import java.text.DecimalFormat;
import java.util.Arrays;

/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class AxeAimingStrats implements Comparable {
    private int id;
    private String name;

    private int totHits = 0;
    private int totFired = 0;
    private int totHitsPR[] = new int[Stratego.AIM_RANGES_QTD];
    private int totFiredPR[] = new int[Stratego.AIM_RANGES_QTD];

    /**
    * 
    */
    public AxeAimingStrats() {
        super();
        // TODO Auto-generated constructor stub

    }

    public AxeAimingStrats(
        int id,
        String name,
        int totHits,
        int totFired,
        int totHitsPR[],
        int totFiredPR[]) {

        this();

        this.id = id;
        this.name = name;
        this.totHits = totHits;
        this.totFired = totFired;
        this.totHitsPR = totHitsPR;
        this.totFiredPR = totFiredPR;

    }

    public AxeAimingStrats(int id, String name) {

        this();

        this.id = id;
        this.name = name;
    }

    public void add(AxeAimingStrats as) {
        totHits += as.getTotHits();
        totFired += as.getTotFired();
        int thPR[] = as.getTotHitsPR();
        int tfPR[] = as.getTotFiredPR();

        for (int i = 0; i < Stratego.AIM_RANGES_QTD; i++) {
            totHitsPR[i] += thPR[i];
            totFiredPR[i] += tfPR[i];
        }
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        if (obj instanceof AxeAimingStrats) {
            AxeAimingStrats him = (AxeAimingStrats)obj;
            if ((him.getId() == this.getId())
                && (him.getName().equals(this.getName()))
                ) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    /* (non-Javadoc)
       * @see java.lang.Object#hashCode()
       */
    public int hashCode() {
        if (this.getTotFired() > 0) {

            return (int)
                (((double)this.getTotHits() / (double)this.getTotFired())
                    * 10000);
        } else {
            return 0;
        }
    }
    /* (non-Javadoc)
                      * @see java.lang.Object#toString()
                      */
    public String toString() {
        DecimalFormat forma = new DecimalFormat("0.00");
        StringBuffer ret = new StringBuffer();

        double percent;

        if (totFired > 0) {

            percent = ((double)totHits / (double)totFired) * 100;
        } else {
            percent = 0;
        }

        ret.append(
            this.getName()
                + ": |"
                + forma.format(percent)
                + "("
                + totHits
                + "/"
                + totFired
                + ")"
                + " - |");

        double[] aimHits = this.getAimTotHitsArray();
        double[] aimFired = this.getAimTotFiredArray();
        for (int i = 0; i < aimFired.length; i++) {
            double avg = (aimHits[i] / aimFired[i]) * 100.00;
            avg = (Double.isNaN(avg)) ? 0.00 : avg;
            ret.append(
                forma.format(avg)
                    + "("
                    + (int)aimHits[i]
                    + "/"
                    + (int)aimFired[i]
                    + ")"
                    + "|;");
        }

        ret.append("     ");

        for (int i = 0; i < Stratego.AIM_RANGES_QTD; i++) {
            if (totFiredPR[i] > 0) {

                percent = ((double)totHitsPR[i] / (double)totFiredPR[i]) * 100;
            } else {
                percent = 0;
            }

            ret.append(
                forma.format(percent)
                    + "("
                    + totHitsPR[i]
                    + "/"
                    + totFiredPR[i]
                    + ")"
                    + "|;");

        }

        return ret.toString();
    }
    
	public String toCSV() {
			DecimalFormat forma = new DecimalFormat("0.00");
			StringBuffer ret = new StringBuffer();

			double percent;

			if (totFired > 0) {

				percent = ((double)totHits / (double)totFired) * 100;
			} else {
				percent = 0;
			}

			ret.append(
				this.getStratName()
					+ ";"
					+ forma.format(percent)
					+ ";"
					+ totHits
					+ ";"
					+ totFired
					
					);

			double[] aimHits = this.getAimTotHitsArray();
			double[] aimFired = this.getAimTotFiredArray();
			for (int i = 0; i < aimFired.length; i++) {
				double avg = (aimHits[i] / aimFired[i]) * 100.00;
				avg = (Double.isNaN(avg)) ? 0.00 : avg;
				ret.append(
				";"
					+forma.format(avg)
						+ ";"
						+ (int)aimHits[i]
						+ ";"
						+ (int)aimFired[i]
						);
			}

			
			return ret.toString();
		}
    /**
                      * @return
                      */
    public int getId() {
        return id;
    }
    /**
                          * @return
                          */
    public String getName() {
        return name;
    }
    
	public String getStratName() {
		
			return name.substring(name.indexOf("AIM"));
		}
    /**
                          * @return
                          */
    public int getTotFired() {
        return totFired;
    }
    /**
                          * @return
                          */
    public int getTotHits() {
        return totHits;
    }

    /* (non-Javadoc)
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    public int compareTo(Object obj) {
        AxeAimingStrats him = (AxeAimingStrats)obj;
        return him.hashCode() - this.hashCode();
    }

    /**
     * @return
     */
    public int[] getTotFiredPR() {
        return totFiredPR;
    }

    /**
     * @return
     */
    public int[] getTotHitsPR() {
        return totHitsPR;
    }

    //duplicados stratego:

    private double[] getAimTotFiredArray() {
        double ret[] = new double[4];
        int start;
        int end;
        int[] fires;
        double fired;

        double botSz = 40; //((HataMoto)HataMoto.getIt()).getBotDim();

        //0-80
        start = Stratego.getDistInd(0);
        end = Stratego.getDistInd(botSz * 2);
        fires = RoboMath.arraySubSet(totFiredPR, start, end);
        fired = RoboMath.getSum(fires);
        ret[0] = fired;

        //80-240
        start = Stratego.getDistInd(botSz * 2);
        end = Stratego.getDistInd(botSz * (2 + 4));
        fires = RoboMath.arraySubSet(totFiredPR, start, end);
        fired = RoboMath.getSum(fires);
        ret[1] = fired;

        //240-560
        start = Stratego.getDistInd(botSz * (2 + 4));
        end = Stratego.getDistInd(botSz * (2 + 4 + 8));
        fires = RoboMath.arraySubSet(totFiredPR, start, end);
        fired = RoboMath.getSum(fires);
        ret[2] = fired;

        //560-1200
        start = Stratego.getDistInd(botSz * (2 + 4 + 8));
        end = Stratego.getDistInd(botSz * (2 + 4 + 8 + 16));
        fires = RoboMath.arraySubSet(totFiredPR, start, end);
        fired = RoboMath.getSum(fires);
        ret[3] = fired;

        return ret;
    }

    private double[] getAimTotHitsArray() {
        double ret[] = new double[4];
        int start;
        int end;
        int[] fires;
        double fired;

        double botSz = 40; //((HataMoto)HataMoto.getIt()).getBotDim();

        //0-80
        start = Stratego.getDistInd(0);
        end = Stratego.getDistInd(botSz * 2);
        fires = RoboMath.arraySubSet(totHitsPR, start, end);
        fired = RoboMath.getSum(fires);
        ret[0] = fired;

        //80-240
        start = Stratego.getDistInd(botSz * 2);
        end = Stratego.getDistInd(botSz * (2 + 4));
        fires = RoboMath.arraySubSet(totHitsPR, start, end);
        fired = RoboMath.getSum(fires);
        ret[1] = fired;

        //240-560
        start = Stratego.getDistInd(botSz * (2 + 4));
        end = Stratego.getDistInd(botSz * (2 + 4 + 8));
        fires = RoboMath.arraySubSet(totHitsPR, start, end);
        fired = RoboMath.getSum(fires);
        ret[2] = fired;

        //560-1200
        start = Stratego.getDistInd(botSz * (2 + 4 + 8));
        end = Stratego.getDistInd(botSz * (2 + 4 + 8 + 16));
        fires = RoboMath.arraySubSet(totHitsPR, start, end);
        fired = RoboMath.getSum(fires);
        ret[3] = fired;

        return ret;
    }

}
