/* This is the navigation module for the StiX Modular Robot System
 * This class handles all gun management for the robot, and it easily
 * modified for any gun system or virtual gun syste, you want.
 */
package amk.ShizzleStiX;
import robocode.*;
import java.util.Iterator;

class Navigator extends Module
{
	/* The standard constructor */
	public Navigator(ShizzleStiX bot) {
		this.bot = bot;
	}
	
	public void run() {
		int changeSpeed = StiXUtil.rand.nextInt(8);
		int newSpeed =  StiXUtil.rand.nextInt(6)+3;
		if(changeSpeed != 0) { return; }
		bot.setMaxVelocity(newSpeed);
		
		int moveType = StiXUtil.rand.nextInt(8);
		int direction = StiXUtil.rand.nextInt(6);
		if(direction == 1) {
			bot.setAhead(40000);
		} else if(direction == 0) {
			bot.setBack(40000);
		}
		switch(moveType) {
			case 0: bot.setTurnRight(45); break;
			case 1: bot.setTurnRight(90); break;
			case 2: bot.setTurnLeft(45); break;
			case 3: bot.setTurnLeft(90); break;
			case 4: bot.setTurnRight(180); break;
			default: break;
		}
		
		Iterator it = bot.Sensors.field.enemies.iterator();
		while(it.hasNext()) {
			FieldUnit unit = (FieldUnit)it.next();
			if(unit.hasFired()) {
				bot.setMaxVelocity(8);
				bot.turnLeft(StiXUtil.smallestToParallel(90 - unit.getBearing()));
				bot.setAhead(50);
				bot.execute();
			}
		}
	}
	
	public void onHitWall(HitWallEvent e) {
		bot.setBack(-400);
		bot.setTurnLeft(115);
		bot.execute();
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		bot.setBack(-1*(StiXUtil.rand.nextInt(400)+50));
		bot.setTurnLeft(StiXUtil.rand.nextInt(160)+20);
		bot.execute();
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		String name = e.getName();
		FieldUnit thisUnit;
		
		if(bot.isTeammate(name)) { thisUnit = bot.Sensors.field.getTeammate(name); }
		else { thisUnit = bot.Sensors.field.getEnemy(name); }
		
		if(thisUnit.getDistance() <=49) {
			bot.setMaxVelocity(8);
			bot.turnLeft(StiXUtil.smallestToParallel(90 - thisUnit.getBearing()));
			bot.setAhead(50);
		}
	}
	
	public void onWin(WinEvent e) {
		bot.stop();
		bot.setTurnLeft(3600);
		bot.setTurnGunRight(3600);
		bot.setTurnGunLeft(3600);
		bot.execute();
	}
}
