package amk.ShizzleStiX;
import robocode.*;
import robocode.util.Utils;
import java.io.*;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.*;

class StiXUtil
{
	static Random rand = new Random();
	static double NormalizeBearing(double ang) {
		if (ang > Math.PI)
			ang -= 2*Math.PI;
			if (ang < -Math.PI)
				ang += 2*Math.PI;
			return ang;
	}
	
	static double getrange( double x1,double y1, double x2,double y2 )
	{
		double xo = x2-x1;
		double yo = y2-y1;
		double h = Math.sqrt( xo*xo + yo*yo );
		return h;
	}
	
	static double absoluteBearing( double x1,double y1, double x2,double y2 )
    {
		double xo = x2-x1;
		double yo = y2-y1;
		double h = getrange( x1,y1, x2,y2 );
		if( xo > 0 && yo > 0 )
		{
				return Math.asin( xo / h );
		}
		if( xo > 0 && yo < 0 )
		{
				return Math.PI - Math.asin( xo / h );
		}
		if( xo < 0 && yo < 0 )
		{
				return Math.PI + Math.asin( -xo / h );
		}
		if( xo < 0 && yo > 0 )
		{
				return 2.0*Math.PI - Math.asin( -xo / h );
		}
		return 0;
	}
	
	static double absoluteBearing(Point2D source, Point2D target) {
         return Math.toDegrees(Math.atan2(target.getX() - source.getX(), target.getY() - source.getY()));
    }

    static double normalRelativeAngle(double angle) {
        double relativeAngle = angle % 360;
        if (relativeAngle <= -180)
            return 180 + (relativeAngle % 180);
        else if (relativeAngle > 180)
            return -180 + (relativeAngle % 180);
        else
            return relativeAngle;
    }
	
	static double smallestToParallel(double angle) {
        if (angle > -90 && angle <= 90)
            return angle;
        double fixedAngle = angle;
        while (fixedAngle <= -90)
            fixedAngle += 180;
        while (fixedAngle > 90)
            fixedAngle -= 180;
        return fixedAngle;
    }
}
