package djc.gun;

import djc.*;
import djc.util.*;

import java.awt.*;
import java.awt.geom.*;     // for Point2D's

import robocode.*;
import robocode.util.*;

/**
 * Circular targetting gun...
 *
 * For some reason, this gun only hits SpinBot about 33% of the time...
 */
public class CircularGun extends LinearGun
{
	public CircularGun(AbstractDynaBot themyrobot) {
		super(themyrobot);
		name = "CIRCULARGUN";
		gunID = DynaBotConstants.CIRCULARGUN;
	}
	
    /**
     * _predictCoordinates
     *  @return Coordinate
     */
    public Point2D.Double predictPosition(Enemy e, double futureTime) {
        if (Math.abs(e.angVelocity) < 0.0001) {  // Too close to linear...
            return super.predictPosition(e,futureTime);
        }
		double tDiff = (futureTime + myrobot.getTime() - e.lastTimePosition);
        double angle = tDiff * e.angVelocity;
		double radius = e.linVelocity / e.angVelocity;
        double cosAngle = Math.cos(e.heading + angle);
        double sinAngle = Math.sin(e.heading + angle);
        double cosHeading = Math.cos(e.heading);
        double sinHeading = Math.sin(e.heading);
		double x = cosAngle * radius - cosHeading * radius;
		double y = sinHeading * radius - sinAngle * radius;

        Point2D.Double retval = new Point2D.Double(e.location.x + x, e.location.y + y);
		myrobot.theBattleManager.translateInsideField(retval, 1);
/*
		myrobot.out.println("enemy at " + (int) e.location.getX() + "," + (int)e.location.getY() + 
		" new point is " + (int)retval.getX() + "," + (int)retval.getY()
		+ " angle is " + Math.toDegrees(angle) + " angv: " + Math.toDegrees(e.angVelocity) + " linv " + e.linVelocity +
		" ftime " + futureTime);
		*/
		return retval;
    }
	
}
