package djc.radar;

import djc.*;
import djc.util.*;

import java.util.*;
import java.awt.geom.*;     // for Point2D's

import robocode.*;
import robocode.util.Utils;

/**
 * Use EnemyManager to find the Least Recently Scanned Enemy
 * 
 * Still not perfect, as it spins the wrong way.  I don't think it is
 * any worse than the TheArtOfWar though.
 */
public class IntelligentMeleeRadar extends BaseRadar
{
	int      direction              = 1;
	String   scanTargetName         = null;
	String   scannedTargetsThisTick = "";
	double   scanAmountRadians      = Double.POSITIVE_INFINITY;
	boolean  shouldWobble           = false;
	
	public IntelligentMeleeRadar(AbstractDynaBot themyrobot) {
		super(themyrobot);
		name = "INTELLIGENT_MELEE_RADAR";
	}
	
	public void reset() {
		scanTargetName = null;
		scannedTargetsThisTick = "";
	}
	
	public void doWork() {
		scannedTargetsThisTick = "";
		//myrobot.out.println("scanAmount: " + Math.toDegrees(scanAmountRadians) + " dir: " + direction + " wobble: " + shouldWobble);
		myrobot.setTurnRadarRightRadians(scanAmountRadians * direction);
		if(shouldWobble) {
			direction *= -1; // Flip direction if wobbling
			Enemy e = (Enemy)myrobot.theEnemyManager.findLeastRecentlyScannedEnemy("");
			if(e != null) {
				if(e.lastTimePosition < myrobot.getTime()) {
					shouldWobble = false;
					scanAmountRadians = Double.POSITIVE_INFINITY;
					direction *= -1;
				}
			}
		}
	}
	
	public void onScannedRobot(ScannedRobotEvent event) {
		//myrobot.out.println("IMR.scannedRobot " + event.getName() + " targets scanned this tick: " + scannedTargetsThisTick);
		String scannedName = event.getName();
		Enemy leastRecentlyScanned;
		boolean bDecideDirectionChange = false;
	
		if(myrobot.theEnemyManager.enemyList.size() == myrobot.getOthers()) {
			//myrobot.out.println("Everyone was scanned once...");
			// Everyone has been scanned....
			if(scanTargetName == null) {
				//myrobot.out.println("scanTargetName is null...");
				// But we don't know who was the last scanned enemy
				leastRecentlyScanned = myrobot.theEnemyManager.findLeastRecentlyScannedEnemy(scannedTargetsThisTick);
				if(leastRecentlyScanned == null) {
					String sTmp = scannedTargetsThisTick.substring(0, scannedTargetsThisTick.indexOf(","));
					//myrobot.out.println("scanTargetName was still null and leastRecentlyScanned is null; first scannedTargetThisTick = " + sTmp);
					scannedTargetsThisTick += scannedName + ",";
					leastRecentlyScanned = (Enemy)myrobot.theEnemyManager.enemyList.get(sTmp);
				}
				
				scanTargetName = leastRecentlyScanned.name;
				//myrobot.out.println("scanTargetName was null, setting to " + scanTargetName);
				bDecideDirectionChange = true;
			} else {
				leastRecentlyScanned = (Enemy)myrobot.theEnemyManager.enemyList.get(scanTargetName);
			}
		
			Enemy currentScannedEnemy = (Enemy)myrobot.theEnemyManager.enemyList.get(scannedName);
			if(scannedName == scanTargetName || bDecideDirectionChange) {
				//myrobot.out.println("Found who we wanted " + scannedName + " deciding direction change...");
				// We found the least recently scanned enemy; find the next least recently scanned
				leastRecentlyScanned = myrobot.theEnemyManager.findLeastRecentlyScannedEnemy(scannedTargetsThisTick);
				scannedTargetsThisTick += scannedName + ",";
				if(leastRecentlyScanned == null) {
					//myrobot.out.println("leastRecentlyScanned is null...scanAmountRadians to minimal wobble");
					scanAmountRadians = Math.toRadians(45);
					shouldWobble = true;
					//myrobot.setTurnRadarRight(0);
					//super.onScannedRobot(event);
					return;
				}
				//myrobot.out.println("Next least recently scanned: " + leastRecentlyScanned.name + " dir=" + direction);
				double absBearingBetweenEnemies = Utils.normalAbsoluteAngle(MyUtils.absoluteBearing(myrobot.location, leastRecentlyScanned.location));
				double newAngleOffset = Utils.normalRelativeAngle(absBearingBetweenEnemies - myrobot.getRadarHeadingRadians());
				direction = newAngleOffset > 0 ? 1 : -1;
				scanAmountRadians = Double.POSITIVE_INFINITY;
				//myrobot.out.println("new dir=" + direction + " to " + leastRecentlyScanned.name + " absBear: " + Math.toDegrees(absBearingBetweenEnemies) + " myRadar: " + Math.toDegrees(myrobot.getRadarHeadingRadians()) + " newAngleRadians: " + Math.toDegrees(newAngleOffset));
				myrobot.setTurnRadarRight(scanAmountRadians * direction);
				scanTargetName = leastRecentlyScanned.name;
				//myrobot.out.println("scanTargetName updated to " + scanTargetName);
			} else {
				scannedTargetsThisTick += scannedName + ",";
				//myrobot.out.println("Scanned " + scannedName + " but looking for " + scanTargetName);
			}
		} else {
			// Have not scanned everyone yet...continue scanning
			scannedTargetsThisTick += scannedName + ",";
			//myrobot.out.println("Not everyone has been initially scanned...");
			shouldWobble=false;
		}
		//super.onScannedRobot(event);
	}

}
