package djc.util;

import djc.*;

import java.awt.geom.*;

/**
 * VirtualBullet class
 */
public class VirtualBullet
{
    public String enemyName = "";
    public int gunID = 0;
	public double firedAtDistance = 0;
	public double shotVelocity = 0;
	protected double shotPower = 0;
	public double shotAngle = 0;
	public Point2D.Double firedFrom;
	public Point2D.Double currentLocation;
	public Point2D.Double prevLocation;
	public int firedTime;
	
    /**
     * VirtualBullet Constructor
     *
     * @param targetName - String for the name
     */
    public VirtualBullet(String theEnemyName, int theGunID, double theRange, Point2D.Double theFiredFrom, double theShotPower, double theShotAngle, int theFireTime)
    {
		enemyName = theEnemyName;
		gunID = theGunID;
		firedAtDistance = theRange;
		shotPower = theShotPower;
		shotAngle = theShotAngle;
		firedFrom = theFiredFrom;
		currentLocation = firedFrom;
		prevLocation = firedFrom;
		shotVelocity = MyUtils.getShotVelocity(shotPower);
		firedTime = theFireTime - 1;
		advanceBullet(firedTime);
    }
	
	public void advanceBullet(int curTime) {
		double x = firedFrom.getX() + (curTime - firedTime - 1) * shotVelocity * Math.sin(shotAngle);
		double y = firedFrom.getY() + (curTime - firedTime - 1) * shotVelocity * Math.cos(shotAngle);
		prevLocation = new Point2D.Double(x, y);
		x = firedFrom.getX() + (curTime - firedTime) * shotVelocity * Math.sin(shotAngle);
		y = firedFrom.getY() + (curTime - firedTime) * shotVelocity * Math.cos(shotAngle);
		currentLocation = new Point2D.Double(x, y);
	}

	/**
	 * Per:
	 *    http://testwiki.roborumble.org/w/index.php?title=Bullet_Travel_Time
	 *
	 * Check the enemy's previous location
	 */
	public boolean hitTarget(AbstractDynaBot myrobot) {
		Enemy e = (Enemy)myrobot.theEnemyManager.enemyList.get(enemyName);
		Rectangle2D.Double c = new Rectangle2D.Double(e.lastLocation.getX() - 18, e.lastLocation.getY() - 18, 36, 36);
		Line2D.Double bulletPath = new Line2D.Double(currentLocation.getX(), currentLocation.getY(),
													prevLocation.getX(), prevLocation.getY());
		boolean retval = c.intersectsLine(bulletPath);
		retval = retval || c.contains(currentLocation);
		if(!c.intersectsLine(bulletPath) && c.contains(currentLocation)) {
			myrobot.out.println("Intersection failed, but contains worked..");
		}
		//retval = retval || (e.location.distance(currentLocation) < 25);  // Quick and dirty, from http://robowiki.net/cgi-bin/robowiki?VirtualBullets/VirtualBulletsSampleBot
		return retval;
	}
}
