package kc.mega.aim.models;

import kc.mega.model.WaveKNN;
import kc.mega.utils.Range;

/** Two KNN models - one trained to hit wave surfers and one trained for other bots. */
public class AimModels {
  public static KNNAimModel getMainModel() {
    return new KNNAimModel("Main", new WaveKNN.Builder<Range>()
        .features(new String[] {"power", "virtuality", "bft", "accel", "vel", "vel=8", "advDir", "dirChangeTimer", "decelTimer", "distanceLast20", "mirrorOffset", "maeWallAhead", "maeWallReverse", "stickWallAhead", "stickWallReverse", "stickWallAhead2", "stickWallReverse2", "stickWallAhead=0", "stickWallReverse=0", "shotsFired"})
        .params(new double[][] {
          {0.6451, 0.0221, 0.3791},
          {0.6586, 0.5277, 0.7128},
          {3.8637, 0.0721, 0.5527},
          {6.1880, 0.0179, 0.1242},
          {1.5331, 0.3616, 0.4985},
          {0.7015, 0.3663, 1.3652},
          {0.9362, 1.1348, 1.6805},
          {0.7125, 0.0178, 0.3897},
          {0.5285, 0.0228, 0.2664},
          {0.4369, 0.5886, 1.1668},
          {0.3591, 0.3235, 1.2803},
          {2.3051, 0.2179, 1.4084},
          {1.0039, 0.0585, 1.7278},
          {1.9669, 0.3157, 1.6041},
          {0.5608, 0.0414, 0.5860},
          {1.4668, 0.1155, 0.2835},
          {0.0646, 0.3137, 0.0688},
          {0.0837, 0.0183, 1.0184},
          {0.2553, 0.1974, 1.1975},
          {0.6133, 0.0291, 0.4828},
        })
        .distanceScale(-0.6551)
        .neighborhoodSizeDivider(5.0)
        .maxNeighbors(200)
        .maxTreeSize(50000).build());
  }

  public static KNNAimModel getAntiSurferModel() {
    return new KNNAimModel("AntiSurfer", new WaveKNN.Builder<Range>()
        .features(new String[] {"virtuality", "bft", "accel", "vel", "vel=8", "advDir", "dirChangeTimer", "decelTimer", "distanceLast10", "mirrorOffset", "maeWallAhead", "maeWallReverse", "stickWallAhead", "stickWallReverse", "stickWallAhead2", "didHit", "didCollide"})
        .params(new double[][] {
          {0.6877, 0.1397, 0.4629},
          {4.0790, 0.2051, 1.1629},
          {4.5094, 0.0618, 0.1255},
          {1.1957, 0.3597, 0.3171},
          {0.1602, 0.0425, 0.9967},
          {0.6232, 0.1955, 1.6019},
          {0.2710, 0.0056, 0.1494},
          {0.7536, 0.0182, 0.2313},
          {0.0950, 0.0582, 0.5642},
          {0.2834, 0.1904, 1.2034},
          {2.0943, 0.3160, 1.0635},
          {1.2343, 0.0954, 1.3740},
          {1.1255, 0.1244, 0.6192},
          {0.5663, 0.1092, 0.7460},
          {0.3343, 0.0048, 0.7101},
          {1.8750, 0.1119, 1.5176},
          {0.6337, 0.2833, 1.6022}})
        .nn("-0.40164658 0.016240256 0.2620343 -0.18569629 -0.44875354 0.10180492 -0.11747387 -0.015256345 0.07607033 -0.18413791 -0.04241628 -0.14722466 0.10131721 0.53352535 -0.25916353 0.11599076 0.16707227 -0.06678912 -0.03969136 0.007647638 -0.4058293 0.032850962 -0.24816713 -0.34964117 0.21308942 -0.009459811 0.21945722 0.12877513 0.12659088 0.2013622 0.64478356 -0.09916522," +
            "-0.20191474 0.08362146 0.45230567 0.15774205 -0.15918495 0.39260757 0.22071762 -0.019216716 0.42740202 -0.33423722 0.103673585 0.05650312 0.16485761 0.18746954 -0.0661773 0.05199434 0.037990004 0.5331758 0.5625863 0.63170516 -0.19944166 0.24793229 0.23362482 -0.27439642 0.060406137 -0.26746458 -0.12179525 -0.3312766 -0.4515746 0.3862874 -0.11190452 -0.14602719," +
            "0.23352052 0.025247019 0.039490193 -0.32496652 -0.18691747 -0.14985064 -0.07748321 -0.107027546 -0.22294907 -0.11167705 0.075586356 -0.32562414 -0.31342804 -0.015020436 -0.087164894 -0.19621961 -0.277458 0.09281284 0.08633102 -0.29204497 0.044975616 -0.11922294 0.2031565 -0.060653877 -0.30619255 0.08077454 -0.12713847 0.09336336 -0.215862 -0.16873744 0.3283605 0.06550175," +
            "0.05871137 -0.056401175 -0.18341318 0.11543661 0.23360707 0.17483447 0.104643635 -0.23179314 0.009976862 -0.31988233 -0.11012001 -0.085519195 0.13155727 0.17488456 -0.42333516 -0.063897885 0.16082911 -0.17183317 -0.069087915 -0.11643643 -0.23276289 0.067459285 -0.39148554 0.010691198 0.05740133 0.061024915 -0.2462696 -0.41137582 -0.12586841 0.16703129 0.13935603 0.40146375," +
            "0.078218296 0.109633476 0.20681415 0.15997145 -0.12137863 0.09388823 0.6398671 -0.03044647 -0.059758168 -0.019992743 0.43610245 -0.3138124 -0.3022155 0.25779364 -0.310301 -0.10707409 0.16141771 0.07554691 -0.041127644 -0.18371263 0.06974187 0.044386253 0.48346475 0.24803111 -0.0096951565 0.16757722 -0.036630396 -0.19998667 0.018959807 -0.314105 -0.061297536 -0.2981804," +
            "-0.20622544 -0.32057688 0.36183226 -0.13735153 -0.115564466 0.44219497 0.31157917 0.0065452754 -0.36898288 -0.11845862 -0.5296051 -0.30222535 -0.0010488917 -0.41909528 0.08254559 0.36482435 0.23080763 0.37715158 0.5164691 0.30249518 0.18109418 0.19442183 0.1452636 -0.2408482 -0.06666733 -0.27353978 -0.17924714 0.25514504 -0.95319766 -0.08079981 -0.4049213 -0.39073688," +
            "0.42085528 0.03814089 0.060197383 -0.2913424 -0.2102037 -0.056064006 -0.2759429 -0.018145084 0.05012937 -0.013016208 0.1418079 0.407926 -0.02095544 -0.20474613 0.14875415 -0.34579852 0.10749472 0.052155882 0.109919064 0.21350431 0.26293287 -0.104649626 0.016377373 -0.1675639 -0.10643531 0.19309506 0.110375546 -0.13499808 -0.55061054 0.13672704 0.10590542 -0.27535233," +
            "0.66723454 -0.000121718185 -0.49094543 -0.28365475 -0.37846017 0.1893865 -0.38717595 0.24241677 -0.27232847 0.095907226 0.019526336 -0.19451967 -0.07414874 0.20499262 -0.115493335 -0.17751253 -0.50111806 -0.16994312 -0.12843263 -0.01727875 -0.08617938 -0.03125379 -0.2888281 -0.23610735 0.07920268 0.09128429 -0.49321786 0.0020518347 0.27515692 -0.40664795 0.25269577 0.0355743," +
            "0.020009635 -0.15698364 0.3460442 -0.24154907 0.34857363 0.3615914 0.35697588 -0.34397918 -0.40811002 -0.26515445 -0.21006724 -0.187803 -0.2436734 -0.08490695 -0.19998696 -0.16167524 -0.0822116 0.53654253 -0.051566724 0.47880587 0.0294065 -0.35275212 0.100476526 0.0940963 -0.16973224 -0.54554427 -0.33500853 0.123829335 -0.36615714 -0.25182888 0.33615032 -0.26179868," +
            "0.016580261 0.30935708 -0.33574444 0.10223046 -0.08164862 0.0774319 -0.41526976 -0.15644838 0.104802884 -0.32184803 0.13469483 0.07766366 -0.38212273 0.66196334 -0.22429894 -0.38831264 -0.24007536 -0.6373235 -0.4435084 0.040811416 -0.4096567 -0.81737226 -0.60551983 0.17007074 0.37156665 -0.40118077 -0.3600281 -0.38137734 0.16402178 -0.13909064 0.51004946 0.0563521," +
            "0.31776935 0.37288836 -0.17126328 -0.25460458 0.05590304 0.020720828 -0.21180743 -0.27855247 0.34854707 0.16763042 0.17673741 -0.19034994 -0.35301608 0.36729884 0.10293472 -0.020813335 -0.08460953 0.40446788 -0.05215031 0.040045664 0.021606172 0.035661776 -0.29436892 -0.18800431 0.36849156 0.14179268 0.056741852 -0.16697678 0.3686121 0.48417 0.38557047 0.3126521," +
            "-0.091740966 -0.3336806 0.52148885 -0.06686595 0.05503924 -0.15601942 -0.02218535 -0.27021748 0.06037601 -0.007197187 -0.75939035 0.2033268 0.42763883 -0.6802067 0.100895576 0.19876237 -0.25814933 0.27560017 0.37151808 0.71370196 0.12079624 0.060958713 0.09198117 -0.048557136 0.004369292 -0.21272884 0.03589267 -0.351958 -0.6366918 0.036562707 -0.38558966 -0.41533756," +
            "0.31356463 0.38146746 0.14500342 -0.16279116 0.12406802 -0.26819676 -0.3451579 -0.015868038 0.4636733 0.100475594 0.25982913 -0.2863725 0.11337678 0.6484657 -0.20915362 0.16087747 0.1360838 0.078210205 -0.3555062 0.3599825 0.047456004 -0.29493418 -0.40065587 0.31022596 0.087522045 0.26419935 -0.10353681 -0.2548173 0.35406765 0.4322395 0.4357067 0.55071175," +
            "0.44604784 0.17478843 0.58789307 0.040411472 -0.18478116 -0.5564166 -0.12209476 -0.05774823 -0.22413568 0.23432612 -0.53076655 0.30424523 0.082769856 -0.35855365 -0.29576015 -0.03114129 0.19597605 0.2648618 0.32753834 0.46073747 0.025065802 -0.017779903 -0.0007164045 0.143001 -0.03911357 0.08337457 -0.09608942 0.005417836 -0.61833143 -0.28599343 -0.27126437 -0.024846215," +
            "0.69302523 0.24870555 0.082668304 -0.31745917 -0.52266777 -0.009880523 -0.3096427 0.2216709 -0.13984849 0.039439164 0.037617356 0.2082248 0.04612066 -0.05356065 -0.0148958275 0.1920342 0.21613573 -0.06229854 -0.10430288 -0.21418224 -0.09553118 0.12636058 -0.10114306 0.112577185 -0.0703131 -0.0443976 -0.0031195453 0.078454725 -0.081356704 -0.16015552 -0.33501896 -0.5834323," +
            "-0.114541255 0.1992344 0.3269748 -0.10428573 0.047727346 0.5571771 0.48191947 0.33244345 0.5103057 -0.16032729 -0.17993437 0.13820383 0.16335352 -0.008313282 -0.22727983 0.008674569 -0.19851717 0.29939777 0.671835 -0.076125294 -0.28543723 0.16532256 -0.07449896 0.06872669 0.14572667 0.5301218 -0.11042444 0.17190567 -0.60286534 0.27969128 0.5883534 -0.30409235," +
            "0.28093788 0.6660154 0.18940292 0.038071543 -0.118598156 -0.051929414 -0.32547083 0.2814472 -0.09763557 0.10973099 0.72045726 -0.15996258 -0.1543717 0.03048883 -0.4027564 0.12548092 -0.34487024 -0.70635206 0.47691074 0.80726767 -0.14342538 -0.46569002 -0.28674135 -0.08945409 0.64749354 0.06440135 -0.61669695 0.24315414 0.26299798 -0.33569226 -0.03700924 0.19137184," +
            "\n" +
            "-0.26271373 -0.28527814 -0.22571273 -0.4298312 0.43987343 0.51392055 0.5513786 -0.6070733 -0.1032446 0.4679915 0.12821528 -0.22492549 0.32396123 -0.023105154 -0.6044431 -0.09192039 -0.36593777," +
            "-0.43251842 -0.18773353 -0.17204188 0.32530248 0.42655662 -0.15563568 0.14673257 -0.35006428 -0.08477606 0.82787216 0.53691506 0.08514354 -0.013993199 -0.18256593 -0.15704255 -0.291191 -0.092481755," +
            "-0.09414809 0.3180592 0.010433332 0.26889524 0.33977103 0.41628727 -1.1823816 -1.3402243 0.18566254 -0.16911787 -0.2668491 -0.07272454 0.29647514 -0.060112894 -0.44096178 0.23210792 -0.28898537," +
            "0.2852424 -0.086778045 0.051667064 -0.30899477 0.11123264 -0.24545774 -0.07499385 0.033704937 0.042577475 0.2639927 0.037854135 -0.101509124 0.10921797 0.27574673 -0.0687401 0.282194 0.21900555," +
            "-0.2429393 -0.15204021 -0.12232138 0.4500128 -0.2286904 -0.02085112 0.38356042 0.30569795 -0.07468607 0.08541772 -0.07834001 -0.0767117 -0.17595091 0.28018913 0.08187953 -0.2735058 -0.06640998," +
            "0.11788097 -0.13765234 0.21124743 -0.036704462 -0.07302616 0.09933702 -0.14728998 -0.22488895 0.31816337 -0.47637197 0.01893155 0.42732203 0.16700551 -0.36293957 -0.03391542 -0.31074405 -0.49697435," +
            "-0.20988548 -0.39434022 0.15124886 -0.022362612 0.42777005 0.609486 0.041657694 -0.20663351 0.08251167 -0.31127372 -0.13305756 -0.21611966 -0.041033626 -0.057011247 -0.40560564 -0.5386075 -0.1949468," +
            "0.17452297 0.28322867 0.21152243 0.1821939 0.17187777 -0.2823546 0.34793904 -0.34971586 0.20195803 0.1862283 0.24366203 -0.15325788 0.00547722 0.25460473 -0.19068068 -0.3101218 0.28796682," +
            "-0.055586454 -0.04638016 0.26996547 0.28374317 0.04908712 0.3766804 -0.76167 -1.1298469 0.5047373 0.12495609 0.06498474 0.6447722 0.13012981 0.3333736 0.08703887 -0.50912315 -1.0857342," +
            "-0.25333616 -0.33287388 -0.30422732 -0.14108744 0.12566078 0.06270401 0.1914163 0.016716234 -0.06345128 -0.3009271 -0.35029852 -0.3062072 0.20761612 -0.18102422 -0.11149315 0.34567884 -0.048831176," +
            "0.43964142 -0.41275755 0.014211051 0.271568 0.37012622 0.4595378 -0.11459472 -0.74566346 0.080372974 -0.15158804 0.5710344 -0.033395674 -0.11818385 0.08890383 -0.8463057 -0.56593555 -0.66021365," +
            "-0.072068654 0.057331108 0.11706787 -0.08418291 0.16857907 -0.35749722 -0.22099128 0.31344554 -0.26026198 -0.27147824 0.062700495 -0.2337924 0.050365467 0.023378056 0.067588836 -0.0031104507 -0.20145772," +
            "0.25853533 0.28544655 0.041150384 -0.2926717 -0.31666863 0.25191438 -0.12417965 -0.24870653 0.032575846 -0.0068147574 -0.11213951 0.18536894 0.16664395 -0.13651451 -0.02564971 0.11886558 -0.46559644," +
            "-0.30043694 0.28780025 0.06770509 0.30543774 0.32585987 0.37479347 0.07424084 -0.9545263 0.05433531 0.10316831 0.6850359 0.030606214 -0.29665977 0.52463996 -0.48167312 -0.43977273 0.34377393," +
            "0.16132148 -0.08483957 -0.12855653 -0.34821263 0.32451802 0.1311046 -0.15532126 0.0775888 0.28497267 0.01208894 -0.08556798 -0.10845575 -0.08177336 0.1299292 0.16273916 -0.14134486 -0.11712081," +
            "0.08642901 0.20795281 -0.042191707 -0.2216023 0.11268103 0.29616898 -0.053470146 -0.65487766 0.35106632 0.16114342 -0.11680898 -0.09745744 -0.022601496 0.26201272 -0.44953987 -0.035508532 -0.15738924," +
            "0.098230325 -0.18227723 -0.12275715 -0.10794953 0.2663576 0.36659864 -0.31696153 -0.6616968 0.508716 -0.081269 0.066701286 0.3588924 0.13594167 0.11604747 -0.010283506 0.17373279 -0.434027," +
            "-0.3364064 0.02243014 0.24775791 -0.2771492 -0.23019975 0.83640766 -0.12785569 -0.84838694 0.5037487 -0.010793011 -0.6146865 0.11531663 0.3943033 -0.020120706 -0.06781933 -0.049856227 -0.5978647," +
            "0.02866822 -0.27997068 -0.18361484 0.16123521 0.21536388 0.757277 -0.17261161 -1.0430081 0.31156585 -0.39822304 -0.35403064 -0.11096193 0.07687343 0.38188115 -0.11110779 -0.1846317 -1.1658722," +
            "0.00761236 0.12545104 -0.19036716 -0.15614903 0.13178252 0.16983779 -0.6053293 -0.90775007 0.009378416 -0.34978992 -0.45670864 0.56911373 0.13182332 1.2539166 -0.15926772 0.24719687 -0.65855706," +
            "-0.042457674 -0.14784302 0.098558985 -0.37506557 0.21156478 0.37834725 0.45728767 0.094951116 -0.3793238 0.111072965 -0.47264305 -0.15288508 -0.19968472 0.31833214 -0.20163794 0.016112424 -0.395043," +
            "0.025516933 0.24628788 0.12940611 -0.05321281 -0.16417617 0.35493356 -0.3023433 0.19605465 -0.042008698 0.40646803 -0.3046 0.24552193 -0.10485 0.15104333 -0.5499418 -0.11505269 -0.22535986," +
            "0.05540397 0.3089041 0.053578865 -0.4731979 0.4686198 0.8272498 0.4380642 -0.7393014 -0.18618199 -0.23411758 -0.59624374 0.097666174 -0.07011107 -0.32397783 -0.60497886 0.079033814 -0.626235," +
            "-0.2964553 -0.11754477 0.1855135 0.15810922 -0.3339985 0.27205673 -0.34662443 0.1615652 0.0065513565 -0.12434853 0.19325523 0.09961416 -0.0024533672 0.18019474 -0.38905385 -0.17241493 -0.13076936," +
            "-0.34189597 -0.07782368 0.11609782 0.21033275 -0.023104517 -0.09807558 -0.1946394 -0.36404946 -0.023235446 -0.18447374 0.27045244 -0.16891372 -0.3666699 0.50986373 -0.47418618 0.099636 -0.6366093," +
            "0.18991534 -0.2357608 0.01616697 0.12156997 0.062421374 0.11890816 0.11988909 -0.00019248982 -0.18704681 0.5141466 -0.17967902 0.015415151 -0.19912165 -0.26735452 -0.089805074 -0.3797497 -0.20654736," +
            "0.1465293 -0.17748871 -0.1545997 0.2862365 0.20374967 0.3034809 -0.7022352 -0.51137775 0.28822902 -0.2486729 -0.2352669 0.2796566 -0.09298118 -0.056135025 -0.35177684 0.23528726 -0.114639364," +
            "-0.023123063 -0.12093797 -0.024621822 -0.20559724 -0.26479238 0.32802093 -0.28409693 -0.38988 0.4388487 -0.15316975 -0.15807022 -0.36171585 0.12293693 -0.19250536 0.2807165 -0.023368625 -0.31033194," +
            "-0.37064588 -0.09191089 -0.4090755 0.044006646 0.22401044 0.3685847 -0.15402237 -0.6168213 0.22398765 0.3768957 0.39886734 -0.30299333 0.15746227 -0.059675533 -0.3737741 -0.0031233197 -0.14033042," +
            "-0.28340468 -0.3441424 0.12887155 0.45853385 -0.15259658 0.34896225 -0.5433997 -0.72893906 0.63135546 0.102489516 -0.018881347 0.062019996 -0.21456131 0.31025213 -0.22946413 -0.40880352 -0.8275764," +
            "-0.5138569 -0.07101199 -0.099816404 0.3972919 0.49640638 -0.20059754 0.0953856 -1.086742 0.11637895 0.007263158 0.50622153 -0.20647274 -0.16053091 0.289929 -0.37110072 -0.71374124 0.39356866," +
            "-0.2281311 -0.46019837 0.1616849 0.23192707 0.30502823 0.11488136 0.33596548 -0.2748382 0.13724723 0.5396786 0.31009382 -0.009367908 -0.014475255 -0.14162497 -0.9506163 0.06337443 -0.45575115,")
        .distanceScale(-0.1824)
        .neighborhoodSizeDivider(5.0)
        .maxNeighbors(100)
        .maxTreeSize(50000).build());
  }
}
