
package axeBots.gunner;

import axeBots.AxeBot;
import axeBots.SilverSurfer;
import axeBots.silversurfer.*;
import axeBots.util.*;

import java.awt.geom.*;

import axeBots.data.*;

public abstract class AxeGunner{
    private AxeTarget target= null;
    private AxeBot me= null;
    private Point2D.Double result= null;
    private double firePower= 0;
    private int id;
    private BotData botData= null;
    

    public final static int LAST_BIT= 31;
    public final static int GAP= 8;

    public final static double PRECISION= 0.5;
    public final static double POWER_LIMIT= 8;

    private int jumpAmt= 1;
    public AxeGunner(AxeTarget target, AxeBot me, int id) {
        super();
        this.target= target;
        this.me= me;
        this.id= id;
        botData= StaticDataCenter.get(target.getName());
    }

    public Point2D.Double aim(double firepwr) {
        if (ready()) {
            this.firePower= firepwr;
            long deltams= System.currentTimeMillis();
            this.result= guess();
            deltams= System.currentTimeMillis() - deltams;

        } else {
        	if(target != null && target.isRamming())
            	{
            		return target.pos(); 
            	}
            me.out.println("not ready..");
            this.result= null;
        }
        return result;
    }

    protected abstract Point2D.Double guess();

    public SilverSurfer getMe() {
        return (SilverSurfer)me;
    }

    public Point2D.Double getResult() {
        return result;
    }

    public AxeTarget getTarget() {
        return target;
    }

    public double getFirePower() {
        return firePower;
    }

    public int getId() {
        return id;
    }


    public String toString() {
        return "AxeGunner "
            + Stratego.getStratName(this.id)
            + " against "
            + this.target.getName();
    }


    public boolean ready() {
        return true;
    }

    public double setFirePower(double dist) {

        if (AxeBot.TC) {
            return 3.0;
        }
        
        double maxPwr = (BulletTracker.getHitAvg(target.getDistance())>0.35 )?3.0:1.9;

        double life= AxeBot.getIt().getEnergy();
        double damage= target.getLife();
        double pwr= 0.1;
 
        if ((life > damage * maxPwr) && (RoboMath.getBulletDamage(maxPwr) >= damage)) {
            pwr= RoboMath.bulletDamageToEnergy(damage);
            pwr= (pwr<0.1)?0.1:pwr;
        } else {

        	
        	//ALTERADO: PEZ POWER BULLET SUGESTION...
        	pwr= (dist<150)?3.0:maxPwr;
            
            
            
            if (life <= POWER_LIMIT) {
                pwr= 0.1;
            }

            double max;

            if (damage <= 4) {
                max= damage / 4;
            } else {
                max= (damage + 2) / 6;
            }

            if (max > maxPwr ) {
                max= maxPwr;
            } else if (max < 0.1) {
                max= 0.1;
            }

            if (pwr > max) {
                pwr= max;
            } else if (pwr < 0.1) {
                pwr= 0.1;
            }
        }
        
        return pwr;
    }


    public int getJumpAmt() {
        return jumpAmt;
    }


    public void setJumpAmt(int i) {
        jumpAmt= i;
    }


    public BotData getBotData() {
        return botData;
    }

}
