package axeBots.pilot.navigator;
import axeBots.AxeBot;
import axeBots.SilverSurfer;
//import axeBots.SilverSurfer;
//import axeBots.data.BitRater;
import axeBots.data.SegmentedGFs;
//import axeBots.silversurfer.AxeTarget;
import axeBots.silversurfer.AxeTarget;
import axeBots.silversurfer.AxeVector;
import axeBots.util.RoboMath;
import axeBots.util.Triangle;
//import axeBots.pilot.AxePilot;
import axeBots.pilot.WaveSurferPilot;
import axeBots.pilot.waves.EnemyWave;
import java.awt.geom.*;
//import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
/**
 * Course - 11/06/2004
 * 
 * @author Axe
 * 
 * This code is released under the RoboWiki Public Code Licence (RWPCL),
 * datailed on: http://robowiki.net/?RWPCL (Basically it means you must keep the
 * code public if you base any code on it.) Not basically, i think it means that
 * the knowledge should not be retained, but shared. We must all remember that
 * the veins of the Knowledge must flow. Quoting(or some) PEZs comment about
 * OpenSouce: "At least is a good Karma".
 */
public class Course {
	public static boolean MULTI_WAVE_SURFING = true;
	protected int goodPoints;
	private static int consecutives;
	protected static double chosen;
	protected boolean re;
	protected boolean wallRestricted = false;
	private Point2D.Double pos;
	protected int timeSlack;
	protected int timeToEnd;
	protected int timeToWall;
	protected int travelTime;
	protected double desloc;
	protected double arc;
	protected double arcPos;
	//tamanho da fatia de cada gf
	protected double slc;
	//gf linear
	protected double linGF;
	protected double maxLinGF;
	protected double endLinGF;
	protected int depth;
	private static Course courseRe = new Course(true);
	private static Course courseFt = new Course(false);
	private static Course course = null;
	private static long lastChangeTime = 0;
	private static WaveNavigator navigator = null;
	protected static Boolean dangerPts[] = null;
	protected int toDngr = 0;
	private static EnemyWave wav;
	private AxeVector route = new AxeVector();
	protected static AxeVector chosenRoute = null;
	//	private static double[] allHitsGraph;
	//	private static double[] hitsGraph;
	//	private static double[] visitsGraph;
	//	private static double[] waveRatesGraph;
	private static BotSimulator sim = null;
	//	private static double[] longAllHitsGraph;
	public boolean stop(double myGF) {
		return ((linGF > maxLinGF) && (myGF <= chosen))
				|| ((linGF < maxLinGF) && (myGF >= chosen));
	}

	//ALTERADO: (2004/10/14) NOVO STOP.
	public int dirToGf(AxeVector toMe, AxeVector toGf) {
		double dif = toMe.getDiffTheta(toGf);
		dif = (dif < 0) ? -1 : +1;
		dif *= (re) ? 1 : -1;
		return (int) dif;
	}

	public boolean containsGF(double gf) {
		//ALTERADO: SE ROUTE == NULL, NAO CONTEM
		if (this.route == null) {
			return false;
		}

		if (this.maxLinGF < this.linGF) {
			return gf <= linGF && gf >= maxLinGF;
		} else {
			return gf >= linGF && gf <= maxLinGF;
		}
	}

	private void compute(boolean update) {
		pos = navigator.me.pos();
		double dist = WaveNavigator.wave.getCenter().distance(pos);
		double ang = (navigator.getEnemy().isHeadOn() && !navigator.me
				.getWallAlert().test())
				? 120
				: (dist < WaveSurferPilot.RUN_DIST)
						? 120
						: (dist < WaveSurferPilot.MIN_DIST) ? 105 : 90;

		if (route == null) {
			route = new AxeVector();
		}
		double tm = findWallSmoothRoute(route, re, ang);

		AxeVector radial = new AxeVector(WaveNavigator.wave.getMyOriginalPos(),
				WaveNavigator.wave.getCenter());
		if (re) {
			radial.addTheta(-90);
		} else {
			radial.addTheta(+90);
		}

		if (Double.isNaN(tm) || Math.abs(radial.getDiffTheta(route)) > 90) {
			System.out.println("route:NULL " + re + " route " + route);
			route = null;
			linGF = WaveNavigator.wave.getPreciseGF(pos);
			maxLinGF = linGF;
			return;
		}
		linGF = WaveNavigator.wave.getPreciseGF(pos);
		maxLinGF = WaveNavigator.wave.getPreciseGF(route.getEndPoint());
		arc = WaveNavigator.wave.getArcLen(pos);
		slc = arc / (SegmentedGFs.GF_QT - 1);
	}
	public static boolean traceCourse(WaveNavigator nav) {
		if (sim == null) {
			sim = new BotSimulator(AxeBot.getIt());
		}
		navigator = nav;
		wav = WaveNavigator.getWave();
		courseFt.compute(true);
		courseRe.compute(true);
		//		System.out.println(courseFt);
		//		System.out.println(courseRe);
		int gfMenosMeio = 5 * ((SegmentedGFs.GF_QT - 1) / 16);
		int gfMaisMeio = 11 * ((SegmentedGFs.GF_QT - 1) / 16);
		boolean headOnRange = false;
		int floorGF = (headOnRange) ? gfMenosMeio : 0;
		int ceilGF = (headOnRange) ? gfMaisMeio : SegmentedGFs.GF_QT - 1;
		boolean ftUp = (courseRe.maxLinGF < courseFt.maxLinGF);
		double maxGF = (ftUp) ? courseFt.maxLinGF : courseRe.maxLinGF;
		double minGF = (!ftUp) ? courseFt.maxLinGF : courseRe.maxLinGF;
		double myGF = courseFt.linGF;
		int myPos = (int) RoboMath.boundIt(Math.round(courseFt.linGF), floorGF,
				ceilGF);
		int maxFt = (int) RoboMath.boundIt((ftUp) ? Math
				./* floor */ceil(courseFt.maxLinGF) : Math
				.floor(courseFt.maxLinGF), floorGF, ceilGF);
		int maxRe = (int) RoboMath.boundIt((ftUp) ? Math
				.floor(courseRe.maxLinGF) : Math.ceil(courseRe.maxLinGF),
				floorGF, ceilGF);
		int from = 0;
		int to = 0;
		Course lastCourse = course;
		if (courseFt.route == null && courseRe.route == null) {
			from = myPos;
			to = myPos;
			course = null;
			//			System.out.println("duas rotas obstruidas. @"+timeNow);
			return false;

		} else if (courseRe.route == null) {
			from = (myPos > maxFt) ? maxFt : myPos;
			to = (myPos > maxFt) ? myPos : maxFt;
			course = courseFt;

			//System.out.println("rota re obstruida. @"+timeNow);
		} else if (courseFt.route == null) {
			from = (myPos > maxRe) ? maxRe : myPos;
			to = (myPos > maxRe) ? myPos : maxRe;
			course = courseRe;
			//System.out.println("rota fwd obstruida. @"+timeNow);
		} else {
			//System.out.println("ambas rotas ok. @"+timeNow);
			course = null;
			if (maxRe > maxFt) {
				from = maxFt;
				to = maxRe;
			} else {
				from = maxRe;
				to = maxFt;
			}
		}

		consecutives = (int) Math.ceil(30.0 / courseFt.slc);

		//int dist = (int) AxeBot.getIt().pos().distance(wav.getCenter());
		//ALTERADO: NOVO ALL WAVE SURFING
		chosen = allWavesChooseFuture(wav, from, to,
				new double[]{/* minGF,maxGF,myGF */});//chooseFuture(wav, null,
		// from, to);

		if (course == null) {
			//ALTERADO: SIMPLIFICANDO
			//			if (courseFt.route == null) {
			//				// System.out.println(".......... Rota ft obstruida"+courseFt );
			//				course = courseRe;
			//			} else if (courseRe.route == null) {
			//				// System.out.println(".......... Rota re obstruida:"+courseRe
			//				// );
			//				course = courseFt;
			//			} else if (maxRe > maxFt) {
			//				// min = maxFt;
			//				if (chosen >= myPos) {
			//					course = courseRe;
			//				} else {
			//					course = courseFt;
			//				}
			//			} else {
			//				// min = maxRe;
			//				if (chosen <= myPos) {
			//					course = courseRe;
			//				} else {
			//					course = courseFt;
			//				}
			//			}
			boolean inFt = courseFt.containsGF(chosen);
			boolean inRe = courseRe.containsGF(chosen);
			course = (inFt && inRe)
					? (((lastCourse != null) && (lastCourse.route != null))
							? lastCourse
							: courseFt)
					: (inFt) ? courseFt : courseRe;
					
					
//					if (courseFt.getRoute() == null) {
//						course = courseRe;
//					} else if (courseRe.getRoute() == null) {
//						course = courseFt;
//					} else {
//						if (courseFt.containsGF(chosen)) {
//							course = courseFt;
//						} else if (courseRe.containsGF(chosen)) {
//							course = courseRe;
//						} else {
//												double difRe = Math.abs(courseRe.maxLinGF-chosen);
//												double difFt = Math.abs(courseFt.maxLinGF-chosen);
//												course = (difRe<difFt)?courseRe:courseFt;
////							futureRates[c++] = Double.NaN;
////							continue;
//						}
//
//					}

		}

		//ALTERADO: SEM RANDOM +-0.5 NO CHOSEN GF
		if (!navigator.enemy.isHeadOn()) {
			double min = chosen - 0.5;
			chosen = min + Math.random();
		}

		AxeVector rt = course.getRoute();
		chosen = RoboMath.boundIt(chosen, minGF, maxGF);

		chosenRoute = getVectorToGF(wav, chosen, rt, course);
		if (course.timeSlack <= course.timeToWall) {
			lastChangeTime = AxeBot.getIt().getTime();
		}

		return true;
	}
	private static AxeVector getVectorToGF(EnemyWave w, double gf,
			AxeVector route, Course course) {
		double escapeAng = w.getMaxEscapeAngle();
		double slice = escapeAng / Math.floor(SegmentedGFs.GF_QT / 2);
		double gfAngDiff = Math.abs(course.linGF - gf) * slice;
		AxeVector ref = new AxeVector(route.getStartPoint(), w.getCenter());
		double rtAngDiff = Math.abs(ref.getDiffTheta(route));
		Triangle t = new Triangle(
				new double[]{gfAngDiff, rtAngDiff, Double.NaN}, new double[]{
						Double.NaN, Double.NaN, ref.getModule()});
		try {
			t.compute();
		} catch (DataFormatException e) {
			e.printStackTrace();
		}
		//			System.out.println(t);
		double module = t.getSide(0);

		double theta = route.getTheta();
		ref.setTheta(theta);
		ref.setModule(module);
		return ref;
	}
	public String toString() {
		//		if(true)throw new RuntimeException ("aqui");
		return "> Course. " + " re:" + re + " linGF:" + linGF + " maxLinGF:"
				+ maxLinGF + " chosen:" + chosen + " consecutives:"
				+ consecutives + " arc:" + arc + " arcPos:" + arcPos + " slc:"
				+ slc;
	}
	/**
	 *  
	 */
	public Course(boolean re) {
		super();
		this.re = re;
	}

	protected static double avgHits(double[] hits, int from, int to) {
		double tot = 0;
		for (int i = from; i <= to; i++) {
			tot += hits[i];
		}
		return tot / (to - from + 1);
	}

	//	protected static int chooseFuture(EnemyWave w, ArrayList allWaves,
	//			 int from, int to) {
	//		AxeTarget him = AxeBot.getIt().getMyTarget();
	//		SegmentedGFs gfHist = him.getBotData().getGfHistory();
	//		allHitsGraph = SegmentedGFs.getAllHits();
	//		hitsGraph = gfHist.getHits(w);
	//		int qtd = (int) gfHist.getQtdHits(w);
	//		visitsGraph = /* (him.getBotData().getGfHistory().isHeadOn() )?null:
	// */gfHist
	//				.getVisits(w );
	//		longAllHitsGraph = SegmentedGFs.getLongAllHits();
	//		waveRatesGraph = navigator.getEnemy().getBotData().getGfHistory()
	//				.rateGFs(allHitsGraph, hitsGraph, qtd, visitsGraph,
	//						navigator.getEnemy().isHeadOn());
	//
	//		double[] futureRates = new double[to - from + 1];
	//		int c = 0;
	//		for (int j = from; j <= to; j++) {
	//			//HISTORY v.2.42: COMENTEI, ACHO QUE ESTAH ERRADO!!
	//			// Course thisCourse = (courseFt.containsGF(j)) ? courseFt :
	//			// courseRe;
	//			// if (courseFt.getRoute() != null && courseFt.containsGF(j)) {
	//			// thisCourse = courseFt;
	//			// } else if (courseRe.getRoute() != null && courseRe.containsGF(j))
	//			// {
	//			// thisCourse = courseRe;
	//			// } else {
	//			// futureRates[c++] = Integer.MAX_VALUE;
	//			// continue;
	//			// }
	//			// Point2D.Double p = getVectorToGF(w, j, thisCourse.getRoute(),
	//			// thisCourse).getEndPoint();
	//			// EnemyWave ew = w;
	//			// int wavgf = (int) Math.round(ew.getPreciseGF(p));
	//			// wavgf = (int) RoboMath.limit(wavgf, 0, SegmentedGFs.GF_QT - 1);
	//			// double weight = ew.getBulletPower()
	//			// / Math.pow(ew.getDistance(p, 0), 2);
	//			// futureRates[c] += waveRatesGraph[wavgf] * weight;
	//
	//			futureRates[c] = waveRatesGraph[j];
	//
	//			//dbg += j+":"+forma.format(futureRates[c] )+" ";
	//
	//			c++;
	//		}
	//		int ret = RoboMath.getMinIndex(futureRates);
	//		return ret + from;
	//	}

	protected static double allWavesChooseFuture(EnemyWave w, int from, int to,
			double[] extras) {

		double[] futureRates = new double[to - from + 1 + extras.length];
		int c = 0;
		Course thisCourse = null;
		if (!MULTI_WAVE_SURFING) {
			EnemyWave.fillInGraph(w);
		}

		//		ALTERADO: NOVA ESCOLHA DE GFs inclui pontas!!
		//		double maxGF=Double.NaN , minGF=Double.NaN, myGF=Double.NaN;
		//		
		//		if ((courseRe.getRoute() != null) && (courseFt.getRoute() != null)){
		//			maxG
		//		}else if(courseRe.getRoute() != null){
		//			
		//		}else if(courseFt.getRoute() != null){
		//			
		//		}
		//		
		//		maxGF = ()(courseFt.maxLinGF )
		//		
		ArrayList allWaves = null;
		int end = (MULTI_WAVE_SURFING) ? to + extras.length : to;
		if (MULTI_WAVE_SURFING) {
			allWaves = EnemyWave.getWavesWeightened();
		}
		for (int j = from; j <= to + extras.length; j++) {

			//				ALTERADO: NOVA ESCOLHA DE GFs inclui pontas!!
			double gf = Double.NaN;
			if (j <= to) {
				gf = j;
			} else {
				if (Double.isNaN(extras[j - to - 1])) {
					futureRates[c++] = Double.NaN;
					continue;
				} else {
					gf = extras[j - to - 1];
				}

			}
			int wavgf = 0;
			Point2D.Double p = null;

			if (courseFt.getRoute() == null) {
				thisCourse = courseRe;
			} else if (courseRe.getRoute() == null) {
				thisCourse = courseFt;
			} else {
				if (courseFt.containsGF(gf)) {
					thisCourse = courseFt;
				} else if (courseRe.containsGF(gf)) {
					thisCourse = courseRe;
				} else {
//										double difRe = Math.abs(courseRe.maxLinGF-gf);
//										double difFt = Math.abs(courseFt.maxLinGF-gf);
//										thisCourse = (difRe<difFt)?courseRe:courseFt;
					futureRates[c++] = Double.NaN;
					continue;
				}

			}
			//			
			//			// if (MULTI_WAVE_SURFING) {
			//			thisCourse = (courseFt.containsGF(gf)) ? courseFt : courseRe;
			//			if (courseFt.getRoute() != null && courseFt.containsGF(gf)) {
			//				thisCourse = courseFt;
			//			} else if (courseRe.getRoute() != null &&
			// courseRe.containsGF(gf)) {
			//				thisCourse = courseRe;
			//			} else {
			//				
			//				
			//				//TODO: INVESTIGAR PORQUE NAUM FUNCIONA SEM ISTO!
			//				futureRates[c++] = Double.NaN;
			//				// System.out.println("ERRO! nenhum dos cursos...:"+gf);
			//				// System.out.println(" *** FWD "+courseFt);
			//				// System.out.println(" *** RE "+courseRe);
			//				continue;
			//			}
			if (MULTI_WAVE_SURFING) {
				p = getVectorToGF(w, gf, thisCourse.getRoute(), thisCourse)
						.getEndPoint();

				wavgf = (int) w.getGF(p);//Math.round(w.getPreciseGF(p));
			} else {
				wavgf = (int) gf;
			}
			wavgf = (int) RoboMath.boundIt(wavgf, 0, SegmentedGFs.GF_QT - 1);

			if (wavgf != gf) {
				//					System.out.println("ERRO! wavgf:"+wavgf+"!= j:"+j+"
				// at:"+AxeBot .getIt().getTime() );
			}

			futureRates[c] = ((w.getResultGraph())[(int) wavgf]);

			if (MULTI_WAVE_SURFING) {
				futureRates[c] *= w.getWeight();
				for (int i = 0; i < allWaves.size(); i++) {
					EnemyWave ew = (EnemyWave) allWaves.get(i);
					wavgf = (int) (int) ew.getGF(p);//Math.round(ew.getPreciseGF(p));
					wavgf = (int) RoboMath.boundIt(wavgf, 0,
							SegmentedGFs.GF_QT - 1);

					futureRates[c] += ((ew.getResultGraph())[wavgf] * ew
							.getWeight());

				}

			}

			c++;
		}

		
		
		int ret = AxeBot.getIt().isFirstBlood(w) ? RoboMath
				.getMaxIndex(futureRates) : RoboMath.getMinIndex(futureRates);
		double rate = futureRates[ret];
		
//		int minIndex = RoboMath.getMinIndex(futureRates);
//		int maxIndex = RoboMath.getMaxIndex(futureRates);
//		double min = futureRates[minIndex ];
//		double max = futureRates[maxIndex];
//		double mid = (min+max)/2D;
//		
//		if (!Double.isNaN(rate)) {
//			do {
//				ret = (int) Math.floor(Math.random() * futureRates.length);
//				rate = futureRates[ret];
////				System.out.println("ret:"+ret+" rate:"+rate+" from:"+from+" to:"+to+" at:"+AxeBot .getIt().getTime() );
//			} while (Double.isNaN(rate) || (rate > mid));
//		}

		ret = (int) ((ret <= to) ? ret + from : extras[ret - to - 1]);
		//		System.out.println("ret:"+ret+" rate:"+rate+" from:"+from+" to:"+to+"
		// at:"+AxeBot .getIt().getTime() );
		//		ALTERADO: NOVA ESCOLHA DE GFs inclui pontas!!
		return ret;
	}

	private static double interceptBullet(AxeVector rt, boolean re, EnemyWave w) {
		double dist = w.getDistance(rt.getStartPoint(), 0);
		int time = 0;

		Point2D.Double pos = null;

		sim.reset();
		sim.setRe(re);

		double teta = rt.getTheta();

		//ALTERADO PROVISORIO. VERIFICAR. DE NOVO.
		double slack = navigator.enemy.isHeadOn() ? 20 : 0;//w.getBulletVel() ;
		//		double slack = navigator.enemy.isHeadOn() ? (20+w.getBulletVel()) :
		// 20;

		while (dist > slack) {
			time++;

			pos = sim.walkBot(teta);
			dist = w.getDistance(pos, time);
		}
		int acumul = (int) sim.getDesloc();

		rt.setModule((acumul) > 0 ? acumul : 1);
		return time;
	}

	public static int getMinTimeTo(Point2D.Double from, Point2D.Double to) {
		SilverSurfer me = AxeBot.getIt();

		double dist = from.distance(to);
		//		se re, dir =-1
		int dir = (me.isRe()) ? -1 : 1;
		int ticks = 0;
		int tot = 0;
		//se re vel deve ser negativa
		int vel = (int) navigator.me.getVelocity();
		while ((dist - tot) > 1) {
			//desacelerando
			if ((dir * vel) < 0) {
				if (vel < 0) {
					vel += 2;
					vel = (vel > 0) ? 0 : vel;
				} else {
					vel -= 2;
					vel = (vel < 0) ? 0 : vel;
				}
			} else if (Math.abs(vel) < 8) {
				if (dir < 0) {
					vel -= 1;
					vel = (vel < -8) ? -8 : vel;
				} else {
					vel += 1;
					vel = (vel > 8) ? 8 : vel;
				}
			}
			tot += vel;
			ticks++;
		}
		return ticks - 1;

	}

	private static double findWallSmoothRoute(AxeVector rt, boolean re,
			double initAng) {

		double head = navigator.me.getHeading();
		head = RoboMath.normalRelativeAngle(re ? head - 180 : head);

		Point2D.Double mypos = navigator.me.pos();
		Point2D.Double hispos = navigator.enemy.pos();
		AxeVector meToHim = new AxeVector(mypos, hispos);
		double angDiff = Math.abs(meToHim.getDiffTheta(head));
		boolean almostDead = navigator.enemy.getLife() <= 0.2;
		//ALTERADO:USANDO drivenIntoCorner() INVES DE inCorner(); DISTANCIA
		// PARA 250 AO INVES DE 200.
		//ALTERADO: SE ENCURRALADO NOS CANTOS, FAZ WALLSMOOTH (TENTANDO
		// RESOLVER BUG...)
		double waveLimitAng = /* (almostDead) ? 15: */(navigator.enemy
				.getDistance() < 200) || (3*navigator.me.getLife() < 2*navigator .enemy.getLife() ) ? ((RoboMath.drivenIntoCorner(mypos,
				hispos)) ? 30 : 80) : 30;
		double enemyLimitAng = /* (almostDead) ? 0: */20;

		double wallSlack = 120;
		double ret = 0;
		int dir = (re) ? -1 : 1;
		//getMe().getWallAlert();
		double d = 18;//(40.0 / 2.0);
		double h = navigator.me.getBattleFieldHeight() - (2 * d);
		double w = navigator.me.getBattleFieldWidth() - (2 * d);
		Rectangle2D.Double bf = new Rectangle2D.Double(d, d, w, h);
		boolean found = false;
		//		AxeVector original = (AxeVector) rt.clone();

		Point2D.Double wavcenter = WaveNavigator.wave.getCenter();
		rt.set(mypos, wavcenter);

		double ang = initAng * dir;
		double var = 5D * dir;
		do {
			ang = initAng * dir;
			do {
				rt.set(mypos, wavcenter);
				rt.setModule(wallSlack);
				rt.addTheta(ang);
				ret = interceptBullet(rt, re, WaveNavigator.wave);
				rt.addModule(wallSlack);
			} while ((!(found = bf.contains(rt.getEndPoint())))
					&& (Math.abs(ang -= var) > waveLimitAng)
					//ALTERADO: LIMITE DE ANGULO COM OPP TAMBEM EM 20
					&& ((angDiff = Math.abs(meToHim.getDiffTheta(rt))) > enemyLimitAng));
			while ((!(found = bf.contains(rt.getEndPoint())))
					&& (rt.getModule() > 150)) {
				rt.addModule(-20);
			}
			initAng = 90;
		} while (!found && ((waveLimitAng -= 20) >= 0));
		rt.addModule(-wallSlack);
		return (!found) ? Double.NaN : ret;
	}

	/**
	 * @return Returns the dangerPts.
	 */
	public static Boolean[] getDangerPts() {
		return dangerPts;
	}
	/**
	 * @return Returns the course.
	 */
	public static Course getCourse() {
		return course;
	}
	/**
	 *  
	 */
	public static void hitByBullet() {
		lastChangeTime = 0;
	}
	/**
	 * @return Returns the lastChangeTime.
	 */
	public static long getLastChangeTime() {
		return lastChangeTime;
	}
	/**
	 * @param lastChangeTime
	 *            The lastChangeTime to set.
	 */
	public static void setLastChangeTime(long lastChangeTime) {
		Course.lastChangeTime = lastChangeTime;
	}
	/**
	 * @return Returns the courseFt.
	 */
	public static Course getCourseFt() {
		return courseFt;
	}
	/**
	 * @return Returns the courseRe.
	 */
	public static Course getCourseRe() {
		return courseRe;
	}
	/**
	 * @return Returns the route.
	 */
	public AxeVector getRoute() {
		return route;
	}
	/**
	 * @return Returns the chosenRoute.
	 */
	public static AxeVector getChosenRoute() {
		return chosenRoute;
	}
	/**
	 * @return Returns the chosen.
	 */
	public static double getChosen() {
		return chosen;
	}
	//	public static double[] getAllHitsGraph() {
	//		return allHitsGraph;
	//	}
	//	public static double[] getLongAllHitsGraph() {
	//		return longAllHitsGraph;
	//	}
	//	public static double[] getHitsGraph() {
	//		return hitsGraph;
	//	}
	//	public static double[] getVisitsGraph() {
	//		return visitsGraph;
	//	}
	//	public static double[] getWaveRatesGraph() {
	//		return waveRatesGraph;
	//	}
	public static BotSimulator getSim() {
		if (sim == null) {
			sim = new BotSimulator(AxeBot.getIt());
		}
		return sim;
	}

}