package axeBots.silversurfer;
import java.awt.geom.*;

import axeBots.AxeBot;
import axeBots.util.*;

/** Classe para tratamentos de vetores para o robocode orientaccao com 0 graus para cima na tela (eixo y).
 * @author Marcos Machado Coelho de Souza  
 */
public class AxeVector implements Cloneable {
    //private double teta;
    //private double modulo;
    private double x;
    private double y;

    private double x0;
    private double y0;

    private double dx;
    private double dy;

    //private double y1;
    //private double y2;
    //private double dy;
    //private double dx;
    //private double modulo;

    public AxeVector() {}

    /** constroi um vetor com centro 0,0 e fim x1,y1.
     */
    public AxeVector(double x1, double y1) {
        this.x= x1;
        this.y= y1;
        x0= 0;
        y0= 0;
        dx= x - x0;
        dy= y - y0;
        //head = normalAbsoluteAngle(head);
    }
    /** constroi um vetor com centro x1,y1, angulo theta (graus), e modulo mod
     */
    public AxeVector(double x1, double y1, double theta, double mod) {
        x0= x1;
        y0= y1;
        theta= Math.toRadians(RoboMath.normalAbsoluteAngle(theta));
        double x2= mod * Math.sin(theta);
        double y2= mod * Math.cos(theta);
        this.x= x1 + x2;
        this.y= y1 + y2;
        dx= x - x0;
        dy= y - y0;
    }

    /** constroi um vetor com inicio em p1 e fim em p2
    	 */
    public AxeVector(Point2D.Double p1, Point2D.Double p2) {
        x= p2.getX();
        y= p2.getY();
        x0= p1.getX();
        y0= p1.getY();
        dx= x - x0;
        dy= y - y0;

    }

    public void set(Point2D.Double p1, double theta, double mod) {
        x0= p1.x;
        y0= p1.y;
        theta= Math.toRadians(RoboMath.normalAbsoluteAngle(theta));
        double x2= mod * Math.sin(theta);
        double y2= mod * Math.cos(theta);
        this.x= x0 + x2;
        this.y= y0 + y2;
        dx= x - x0;
        dy= y - y0;

    }

    public void set(Point2D.Double p1, Point2D.Double p2) {
        x= p2.getX();
        y= p2.getY();
        x0= p1.getX();
        y0= p1.getY();
        dx= x - x0;
        dy= y - y0;

    }

    public void translate(Point2D.Double p1) {
        double oldTheta= this.getRelativeTheta();
        x0= p1.getX();
        y0= p1.getY();
        this.setTheta(oldTheta);
    }

    public String toString() {
        return "("
            + x0
            + ","
            + y0
            + ")("
            + x
            + ","
            + y
            + ") theta:"
            + this.getRelativeTheta()
            + " mod:"
            + this.getRelativeModule()
            + " dx:"
            + dx
            + " dy:"
            + dy;
    }

    public double getX() {
        return x;
    }
    public double getY() {
        return y;
    }

    public double getDX() {
        return dx;
    }
    public double getDY() {
        return dy;
    }

    public double getX0() {
        return x0;
    }
    public double getY0() {
        return y0;
    }

    public Point2D.Double getStartPoint() {
        return new Point2D.Double(x0, y0);
    }

    public Point2D.Double getEndPoint() {
        return new Point2D.Double(x, y);
    }

    public void setModule(double mod) {
    	//HISTORY v.2.42: 2004/09/21 PROTECCAO NO AXEVECTOR CONTRA MODULO == 0
    	//proteccao contra mod = 0
    	mod=(mod==0)?0.000001:mod;
        /*
         x0= x1;
        y0= y1;
        theta= Math.toRadians(RoboMath.normalAbsoluteAngle(theta));
        double x2= mod * Math.sin(theta);
        double y2= mod * Math.cos(theta);
        this.x= x1 + x2;
        this.y= y1 + y2;
        dx= x - x0;
        dy= y - y0;
         */

        double theta=
            Math.toRadians(RoboMath.normalAbsoluteAngle(getRelativeTheta()));
        double x2= mod * Math.sin(theta);
        double y2= mod * Math.cos(theta);
        this.x= x0 + x2;
        this.y= y0 + y2;
        dx= x - x0;
        dy= y - y0;
    }

    public void setTheta(double ang) {

        ang= Math.toRadians(RoboMath.normalAbsoluteAngle(ang));
        double mod= getModule();
        double x2= mod * Math.sin(ang);
        double y2= mod * Math.cos(ang);
        this.x= x0 + x2;
        this.y= y0 + y2;
        dx= x - x0;
        dy= y - y0;
    }

    public void addTheta(double ang) {
        this.setTheta(getRelativeTheta() + ang);
    }
    
    /**
	 * @param wallSlack
	 */
	public void addModule(double mod) {
		this.setModule(this.getModule() +mod);
		
	}


    public double getModule() {
        //return Math.sqrt(x * x + y * y);
        return getRelativeModule();
    }

    public double getTheta() {
        //return Math.toDegrees(Math.PI / 2 - Math.atan2(y, x));
        return getRelativeTheta();
    }
    /** seta nova origem mantendo pt final. theta e modulo mudam!!
     */
    public void setOrigin(double x1, double y1) {
        x0= x1;
        y0= y1;
        dx= x - x0;
        dy= y - y0;
    }

    public void setEnd(double x1, double y1) {
        x= x1;
        y= y1;
        dx= x - x0;
        dy= y - y0;
    }

    public void setEnd(Point2D.Double p) {
        this.setEnd(p.x, p.y);
    }

    public void setOrigin(Point2D.Double p) {
        this.setOrigin(p.x, p.y);
    }

    /** retorna o modulo do vetor
     */
    public double getRelativeModule() {
        return Math.sqrt(dx * dx + dy * dy);
    }

    /** retorna o angulo do vetor em graus.
     */
    public double getRelativeTheta() {
        if (this.getModule() == 0)
            return 0;
        double t= Math.toDegrees(Math.PI / 2 - Math.atan2(dy, dx));
        return t;
    }

    public double getDiffModule(AxeVector vec) {
        double dx= this.getDX() - vec.getDX();
        double dy= this.getDY() - vec.getDY();
        return Math.sqrt((dx * dx) + (dy * dy));
    }

    public double getDiffTheta(AxeVector vec) {
        double thisTheta= RoboMath.normalRelativeAngle(this.getTheta());
        double vecTheta= RoboMath.normalRelativeAngle(vec.getTheta());
        return RoboMath.normalRelativeAngle(vecTheta - thisTheta);
    }
    
    public double getDiffTheta(double theta) {
        double thisTheta= RoboMath.normalRelativeAngle(this.getTheta());
        theta= RoboMath.normalRelativeAngle(theta);
        return RoboMath.normalRelativeAngle(theta - thisTheta);
    }

    public AxeVector minus(AxeVector vec) {
        AxeVector vecInv= (AxeVector)vec.clone();
        vecInv.setModule(vecInv.getModule() * (-1));
        AxeVector ret= this.plus(vecInv);
        return ret;
        //		AxeVector ret = new AxeVector(p0, pF);

    }

    public AxeVector plus(AxeVector vec) {
        AxeVector ret;

        Point2D.Double p0= this.getStartPoint();
        double retDx= this.getDX() + vec.getDX();
        double retDy= this.getDY() + vec.getDY();
        Point2D.Double pF=
            new Point2D.Double(p0.getX() + retDx, p0.getY() + retDy);
        ret= new AxeVector(p0, pF);

        return ret;
    }

    public void relativePlus(AxeVector vec) {

        dx= dx + vec.getDX();
        dy= dy + vec.getDY();
        x= x0 + dx;
        y= y0 + dy;
    }

    /*
    public AxeVector div(double d)
    {
    	AxeVector ret;
    	ret = new AxeVector((this.getX()+vec.getX()),(this.getY()+vec.getY()));
    	return ret;
    }*/

    public double getRelativeModule(double x1, double y1) {
        double Dx= x - x1;
        double Dy= y - y1;
        return Math.sqrt(Dx * Dx + Dy * Dy);
    }

    public double getRelativeTheta(double x1, double y1) {
        double Dx= x - x1;
        double Dy= y - y1;
        if (Math.sqrt(Dx * Dx + Dy * Dy) == 0)
            return 0;
        double t= Math.toDegrees(Math.PI / 2 - Math.atan2(Dy, Dx));
        return (Double.isNaN(t) || Double.isInfinite(t)) ? 0 : t;
    }

    public Object clone() {
        Object ret= null;
        try {
            ret= super.clone();

        } catch (CloneNotSupportedException e) {
            ret= null;
            AxeBot.getIt().out.println("************** nao cloneou:" + this);
        }
        return ret;
    }

	
}