package kc.serpent.utils;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;

public class RobotPredictor {
    double ahead = 0;
    double turnRightRadians = 0;
    double maxVelocity = 8;

    public void setAhead(double d) {
		ahead = d;
	}
    public void setTurnRightRadians(double turn) {
		turnRightRadians = turn;
	}
    public void setMaxVelocity(double v) {
		maxVelocity = v;
	}
	
	public void standardUpdate(AdvancedRobot robot) {
		ahead = robot.getDistanceRemaining();
		turnRightRadians = robot.getTurnRemainingRadians();
	}
	
    public Point2D.Double getNextLocation(AdvancedRobot robot) {
		int currentDirection = KUtils.sign(ahead);
		Point2D.Double location = new Point2D.Double(robot.getX(), robot.getY());
		double vectorDistance = nextVelocity(robot.getVelocity(), currentDirection, maxVelocity);
		double vectorHeading = robot.getHeadingRadians() + turnIncrement(turnRightRadians, vectorDistance);
		return KUtils.projectMotion(location, vectorHeading, vectorDistance);
	}
	
	public static double maxTurn(double v) {
		return Math.toRadians(10 - (Math.abs(v) * 0.75));
	}
	
	public static double turnIncrement(double t, double v) {
		double max = maxTurn(v);
		return KUtils.minMax(t, -max, max);
	}
	
	public static double nextVelocity(double v, int d, double maxV) {
		v = Math.abs(v) > maxV ? 
			v + (KUtils.sign(v) * Math.max(maxV - Math.abs(v), -2)) : 
			KUtils.minMax(v + (d * (d * v >= 0 ? 1 : 2)), -maxV, maxV);
		return v;
	}
}
