package djc;
import robocode.*;

/**
 * CircularTargetingStrategy. 
 */
public class CircularTargetingStrategy extends LinearTargetingStrategy
{
    /* ********************************************************************************** */
    /*                                   CONSTANTS                                        */
    /* ********************************************************************************** */

    /* ********************************************************************************** */
    /*                                MEMBER VARIABLES                                    */
    /* ********************************************************************************** */

    CircularTargetingStrategy(Target pT)
    {
        super(pT);
        name = TargetingStrategyManager.CIRCULAR;
    }

    /**
     * predictCoordinates
     *  @return Coordinate
     */
    public Coordinate predictCoordinate(double curTime, double futureTime)
    {
	return _predictCoordinate(curTime, futureTime, t.velocity, 
				  t.angularVelocity, t.heading_rad);
    }

    /**
     * _predictCoordinates
     *  @return Coordinate
     */
    public Coordinate _predictCoordinate(double curTime, double futureTime,
					 double pVel, double pAngVel, double oriHdng)
    {
        if (Math.abs(pAngVel) < 0.0001) {
            return super.predictCoordinate(curTime, futureTime);
        }
	double tDiff = (futureTime + curTime - t.lastTimePosition);
        double angle = tDiff * pAngVel;
	double radius = pVel / pAngVel;
        double cosAngle = Math.cos(oriHdng + angle);
        double sinAngle = Math.sin(oriHdng + angle);
        double cosHeading = Math.cos(oriHdng);
        double sinHeading = Math.sin(oriHdng);
	double x = cosAngle * radius - cosHeading * radius;
	double y = sinHeading * radius - sinAngle * radius;

        return new Coordinate(t.position.x + x, t.position.y + y);
    }

}
