package ags.rougedc.gun;

import ags.rougedc.base.Rules;
import ags.rougedc.robots.*;
import ags.utils.points.AbsolutePoint;

public class PatternRobot extends VirtualRobotPredictor {
    private final double accel, turn;
    
    public PatternRobot(Rules rules, VirtualRobot sourcerobot, double turn, double accel) {
        super(sourcerobot, AbsolutePoint.fromXY(rules.BATTLEFIELD_WIDTH, rules.BATTLEFIELD_HEIGHT));
        this.turn = turn;
        this.accel = accel;
    }

    @Override
    public double getAcceleration() {
        return accel;
    }

    @Override
    public double getAngularVelocity() {
        return turn;
    }

}
