package abud;

import robocode.Robot;
import robocode.ScannedRobotEvent;

/**
 * Comments
 */
public class EnemyInfo {
	private double x;
	private double y;
	private double velocity;
	private double heading;
	private double energy;
	private long time;
	private String name;
	
	public EnemyInfo(Robot robo, ScannedRobotEvent e){
		double enemyBearing = robo.getHeading() + e.getBearing();
		x = robo.getX() + e.getDistance() * Math.sin(Math.toRadians(enemyBearing));
		y = robo.getY() + e.getDistance() * Math.cos(Math.toRadians(enemyBearing));
		velocity = e.getVelocity();
		time = e.getTime();
		name = e.getName();
		heading = e.getHeading();
		energy = e.getEnergy();
	}
	/**
	 * @return
	 */
	public double getEnergy() {
		return energy;
	}
	
	public double getDistance(Robot r){
		double dx = Math.abs(r.getX() - x);
		double dy = Math.abs(r.getY() - y);
		double dis = Math.sqrt(dx*dx + dy*dy);
		return dis;
	}

	public double getAproxX(long now, Robot r){
		double hea = Math.round(heading);
		double dis = (now - time) * (velocity);
		double dx=0;
		if (hea==0 || hea==180 || hea==360){
			dx = 0;
		} else if (hea==90){
			dx = dis;		
		} else if (hea==270){
			dx = -dis;
		}
		
		dx = x + dx;
		if (dx<0) {
			dx = 0;
		} else if (dx>r.getBattleFieldWidth()) {
			dx = r.getBattleFieldWidth();
		}
		return dx;

	}
	
	public double getAproxY(long now, Robot r){
		double hea = Math.round(heading);
		double dis = (now - time) * (velocity);
		double dy=0;
		if (heading==90 || heading==270){
			dy = 0;
		} else if (hea==0 || hea==360){
			dy = dis;		
		} else if (hea==180){
			dy = -dis;		
		}
		
		dy = y + dy;
		if (dy<0) {
			dy = 0;
		} else if (dy>r.getBattleFieldHeight()) {
			dy = r.getBattleFieldHeight();
		}
		return dy;
	}

	/**
	 * @return
	 */
	public double getHeading() {
		return heading;
	}

	/**
	 * @return
	 */
	public long getTime() {
		return time;
	}

	/**
	 * @return
	 */
	public double getVelocity() {
		return velocity;
	}

	/**
	 * @return
	 */
	public double getX() {
		return x;
	}

	/**
	 * @return
	 */
	public double getY() {
		return y;
	}

	/**
	 * @return
	 */
	public String getName() {
		return name;
	}

}
