/*
 * Written by Kinsen Choy
 */

package kinsen.melee.Guns;
import java.util.ArrayList;

/*
 * GunStatistics - The class that records the statistics for each gun.
 */
public class GunStatistics
{
	// ArrayList of whether bullet hit and counts of hits and total fired
	private ArrayList results = new ArrayList();
	private int hit;
	private int total;

	// These two constants synchronized with SimpleGuns
	// Minimum percent gun has to achieve or it will continue trying others
	private static final int MINIMUM_CHANGE_PERCENT = 25;
	// Maximum amount of tries for each gun
	private static final int MAXIMUM_GUN_TRIES = 40;

	/*
	 * Creates a new instance of GunStatistics and resets data
	 */
	public GunStatistics()
	{
		hit = 0;
		total = 0;
	}

	/*
	 * getPercentage: Returns bullet hit percentage
	 */
	public double getPercentage()
	{
		if (total == 0)
			return MINIMUM_CHANGE_PERCENT;

		return (double) hit / (double) total * 100;
	}

	/*
	 * getTotal: Returns total number of bullet fired
	 */
	public double getTotal()
	{
		return total;
	}

	/*
	 * recordBullet: Records bullet results
	 */
	public void recordBullet(boolean bulletHit)
	{
		if (bulletHit)
		{
			hit++;
			results.add(new Integer(1));
		}
		else
			results.add(new Integer(0));

		total++;

		// If there are too many results then trim the earliest one
		if (total > MAXIMUM_GUN_TRIES)
		{
			// If earliest bullet was hit then subtract from hit
			if (((Integer) results.get(0)).intValue() == 1)
				hit--;

			// Trim data
			results.remove(0);
			total--;
		}
	}
}