package alex;
import robocode.*;
import java.awt.Color;
import java.util.Vector;

/**
 * Diabolo5 - mieux que Diabolo4 mais moins bien que Diabolo6 :)
 * Auteur : Alex (aaupetit@club-internet.fr)
 * Date : 01/06/03
 * Licence : GPL
 */
public class Diabolo5 extends AdvancedRobot
{
	String name = "alex.Diabolo5";

	// etat
	int direction = 1;
	int directionRadar = 1;
	boolean nearUpWall, nearDownWall, nearRightWall, nearLeftWall;
	boolean nearULCorner, nearURCorner, nearDLCorner, nearDRCorner;
	boolean nearWall, nearCorner;

	// var de calcul
	double angle = 0;
	double lastAngle = 0;
	boolean escapeWall=false;
	double spir = 0;

	// paramtres
	double maxRadarAngle=45;
	double halfMaxRadarAngle=maxRadarAngle/2;
	double minDistWall = 45;
	double minDistCorner = 150;
	
	D5Utils util=null;
	D5Enemy enemy=null;
	D5GunShooterPredictor shooter=null;


	/*
	 * Constructeur
	 */
	public Diabolo5() {
	}

	/*
	 * Fonction principale
	 */
	public void run() {
		setColors(Color.white,Color.white,Color.green);
		setAdjustRadarForRobotTurn(true);
		setAdjustRadarForGunTurn(true);

		shooter = new D5GunShooterPredictor(this);
		util=D5Utils.getInstance();

		while (true) {
			doStrategy();
			doRadar();
			doMove();
			execute();
		}
	}

	/*
	 * Rcupration de l'tat en cours
	 */
	public void doStrategy() {
		nearLeftWall = (getX() < minDistWall);
		nearRightWall = ((getBattleFieldWidth() - getX()) < minDistWall);
		nearDownWall = (getY() < minDistWall);
		nearUpWall = ((getBattleFieldHeight() - getY()) < minDistWall);

		nearULCorner = ( ((getBattleFieldHeight() - getY()) < minDistCorner) && (getX() < minDistCorner) );
		nearURCorner = ( ((getBattleFieldHeight() - getY()) < minDistCorner) && ((getBattleFieldWidth() - getX()) < minDistCorner) );
		nearDLCorner = ( (getY() < minDistCorner) && (getX() < minDistCorner) );
		nearDRCorner = ( (getY() < minDistCorner) && ((getBattleFieldWidth() - getX()) < minDistCorner) );

		nearWall = ( nearRightWall || nearLeftWall || nearUpWall || nearDownWall);
		nearCorner = ( nearULCorner || nearURCorner || nearDLCorner || nearDRCorner);

	}

	/*
	 * Gestion du radar
	 * Si pas de cible trouve au dernier tour, on fait le tour complet
	 */
	public void doRadar() {
		if ((enemy == null) || (getTime()-enemy.lastScanTime > 1) )
		{
			out.println("tour complet !");
			setTurnRadarRight(360);
		}
	}

	/*
	 * Mouvement : gestion de la distance trop importante et des murs
	 */
	public void doMove() {
		if (enemy != null) {
			double proba=0.85;
			// tourner le robot
			double angleTourn;
			if (enemy.tooFar) {
				angleTourn=util.normAngle(enemy.relativeBearing+90-25*direction);
				proba=0.95;
			} else {
				angleTourn=util.normAngle(enemy.relativeBearing+90);
			}
			if (nearWall || nearCorner) {
				if (!escapeWall) {
					escapeWall = true;
					direction=-direction;
				}
				setAhead(direction*500);
			} else {
				escapeWall = false;
				/*if (enemy.relativeDistance > 350) {
					proba = 0.9;
				}*/
				//0.85-(2+enemy.velocity)/100
				if ( (Math.random() > proba) ) {
						direction=-direction;
						out.println("change!");
					if (Math.random() > 0.85) {
						spir+=Math.random()*6-3;
					}
				}
				setAhead(direction*45);
			}
			setMaxVelocity(8);
			setTurnRight(angleTourn+spir);
		}
	}

	public void onHitWall(HitWallEvent e) {
		direction =-direction;
		setTurnLeft(45);
		setMaxVelocity(8);
		setAhead(direction*50);
	}

		/*
	 * Mort d'un robot => changement de cible
	 */
	public void onRobotDeath(RobotDeathEvent e) {
		 if (e.getName().equals(enemy.name)) {
			enemy=null;
		}
	}


	/*
	 *
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
    // si pas encore de cible
		if (enemy == null) {
			if ( (getOthers()==1)
			 || ( (getOthers()>1) && (!(e.getName().startsWith(name))) ) )
			{
				enemy = new D5Enemy(this, e.getName());
				out.println("Enemy : "+e.getName());
			}
		}

    // on vrifie que c'est bien la cible en cours
		if ( (enemy != null) && (e.getName().equals(enemy.name)) )
		{
 			enemy.updateInformation(e);

			directionRadar = -directionRadar;
			setTurnRadarRight(directionRadar*45);

			double angle_diff=util.normAngleRadians(getHeadingRadians()+enemy.relativeBearingRadians-enemy.headingRadians);
			int signe=1;
			if ( (angle_diff>-util.PIsur2)||(angle_diff<util.PIsur2) )  {
				signe = -1;
			} else {
				signe = 1;
			}
																			
			// tourner le canon
			angle = util.normAngle(getHeading() - getGunHeading() + enemy.relativeBearing);

			double correct=0;		
			if (enemy.nearCorner) {
				correct=4*signe*Math.sin(angle_diff)*enemy.velocity;
			} else {
				if (enemy.nearWall) {
					correct=4*signe*Math.sin(angle_diff)*enemy.velocity;
				} else {
					if (enemy.relativeDistance > 300) {
						correct=5.5*signe*Math.sin(angle_diff)*enemy.velocity;
					} else {
						correct=4*signe*Math.sin(angle_diff)*enemy.velocity;
					}
				}
			}
			double rnd=Math.random();
			if ((enemy.relativeDistance>50) && (enemy.energy != 0))
				//if (rnd > 0.90-(enemy.velocity)/20) {
				if (rnd > 0.7) {
					correct+=(Math.random()*6-3);
					if (rnd > 0.85) {
						correct*=1.15;
						if (rnd > 0.90) {
							if ((enemy.relativeDistance<300) && (Math.abs(correct)<8)) {
								correct*=-0.95;
							} else {
								correct*=0.75;
							}
						}
						if (rnd > 0.98) {
							correct = 0;
						}
					}
			}
			setTurnGunRight(util.normAngle(angle+correct));
			
			if (shooter.decideToFire(enemy))
			{
				setFire(shooter.firePower);
			}
			lastAngle = angle;
		}

	}


	/*
	 * Danse de la victoire
	 */
	public void onWin(WinEvent e) {
		ahead(0);
		turnRadarRight(360);
		turnGunLeft(getGunHeading());
		turnLeft(getHeading()+90);
		fire(0.1);
		turnGunRight(360);
		fire(0.1);
		turnGunLeft(360);
		fire(0.1);
	}

}



/**
 * D5Utils
 */
class D5Utils {
	double PI = Math.PI;
	double deuxPI = PI*2;
	double PIsur2 = PI/2;

	/*
	 *
	 */

	static private D5Utils instance=null;

	 	//  transformer en singleton
	private D5Utils () {
	}
	
	static public D5Utils getInstance() {
		if (instance == null) {
			instance = new D5Utils();
		}
		
		return instance;
	}

	public double normAngle(double angle) {
		angle = angle % 360;

		if (angle > 180) {
			angle = 180 - angle;
		}
		if (angle < -180) {
			angle += 360;
		}

		return angle;
	}

	/*
	 *
	 */
	public double normAngle180(double angle) {
		angle = angle % 180;

		if (angle > 90) {
			angle = 90 - angle;
		}
		if (angle < -90) {
			angle += 180;
		}

		return angle;
	}
	
	/*
	 *
	 */
	public double normAngleRadians(double angle) {
		angle = angle % deuxPI;

		if (angle > PI) {
			angle = PI - angle;
		}
		if (angle < -PI) {
			angle += deuxPI;
		}

		return angle;
	}
}


/**
 * Classe : indique si on peut tirer
 */
class D5GunShooterPredictor {

	public boolean doFire = false;
	public double firePower=3;
	Diabolo5 me = null;

	public D5GunShooterPredictor(Diabolo5 me) {
		this.me = me;
	}

	public boolean decideToFire(D5Enemy enemy) {
			doFire = false;
			if (me.getGunHeat() == 0)
			{
				firePower=1;
				if ((enemy.relativeDistance<450) || (enemy.energy==0)) {
					doFire = true;
				} else {
					doFire=(enemy.velocity<enemy.old_velocity) && (enemy.velocity<4);
					firePower=0.1;
				}
				if (enemy.relativeDistance<400) {
					firePower++;
				}
				if (enemy.relativeDistance<300) {
					firePower++;
				}
				
				if (me.getEnergy() > enemy.energy+20)  {
					firePower=3;
				}
				
				if ( (enemy.nearCorner) || (enemy.nearWall) ) {
					firePower=3;
					doFire = true;
				}
			}
			return doFire;
	}
}



/**
 * L'ennemi est con : il croit que c'est nous les ennemis, alors que c'est lui !
 */
class D5Enemy {
	String name;
	int x;
	int y;
	double energy;
	double relativeBearing, relativeBearingRadians;
	double heading, headingRadians;
	double relativeDistance;
	double velocity;
	double old_velocity;
	long lastScanTime=0;

	boolean nearUpWall, nearDownWall, nearRightWall, nearLeftWall;
	boolean nearULCorner, nearURCorner, nearDLCorner, nearDRCorner;
	boolean nearWall, nearCorner;
	boolean old_nearWall, old_nearCorner;

	double minDistWall = 100;
	double minDistCorner = 150;
	boolean tooFar = false;

	double X;
	double Y;

	Diabolo5 me;

	public D5Enemy (Diabolo5 me, String name0) {
		name = name0;
		old_velocity=0;
		this.me = me;
		old_nearWall = false;
		old_nearCorner = false;
	}

	public void updateInformation(ScannedRobotEvent e) {
		relativeBearing = e.getBearing();
		relativeBearingRadians = e.getBearingRadians();
		heading = e.getHeading();
		headingRadians = e.getHeadingRadians();
		relativeDistance = e.getDistance();
		old_velocity=velocity;
		velocity = e.getVelocity();
		energy = e.getEnergy();

		X = me.getX() + Math.cos(relativeBearingRadians)*relativeDistance;
		Y = me.getY() + Math.sin(relativeBearingRadians)*relativeDistance;

		nearLeftWall = (X < minDistWall);
		nearRightWall = ((me.getBattleFieldWidth() - X) < minDistWall);
		nearDownWall = (Y < minDistWall);
		nearUpWall = ((me.getBattleFieldHeight() - Y) < minDistWall);
		nearULCorner = ( ((me.getBattleFieldHeight() - Y) < minDistCorner) && (X < minDistCorner) );
		nearURCorner = ( ((me.getBattleFieldHeight() - Y) < minDistCorner) && ((me.getBattleFieldWidth() - X) < minDistCorner) );
		nearDLCorner = ( (Y < minDistCorner) && (X < minDistCorner) );
		nearDRCorner = ( (Y < minDistCorner) && ((me.getBattleFieldWidth() - X) < minDistCorner) );

		old_nearWall = nearWall;
		old_nearCorner = nearCorner;

		nearWall = ( nearRightWall || nearLeftWall || nearUpWall || nearDownWall);
		nearCorner = ( nearULCorner || nearURCorner || nearDLCorner || nearDRCorner);
		lastScanTime = e.getTime();
		if (relativeDistance > 200) {
			tooFar = true;
		} else {
			tooFar = false;
		}
	}
}
