/**
 * Copyright (c) 2009 Nat Pavasant; All right reserved.
 * Source code is released under the term of Nat Public Robot License 2.1
 */
package nat.base.actors;

import nat.base.BotBase;
import nat.utils.M;

/**
 * @author Nat Pavasant
 */
public final class GunActor extends ActorBase {
	
	public GunActor(BotBase robot) {
		super(robot);
	}
	
	public robocode.Bullet fire(double power) {
		return _robot.setFireBullet(power);
	}
	
	public void turnGun(double angle) {
		_robot.setTurnGunRightRadians(angle);
	}
	
	public void turnGunTo(double angle) {
		_robot.setTurnGunRightRadians(M.normalRelativeAngle(angle - _robot.getGunHeadingRadians()));
	}
	
	public void turnGunTo(nat.utils.Point pt) {
		turnGunTo((new nat.utils.Point(_robot.getX(), _robot.getY())).angle(pt));
	}
}
