package hamilton;

public class Calculator 
{
	public static double normalizeAngle(double a)
	{
		if (a > (Math.PI * 2)) a %= (Math.PI * 2);
		if (a < 0) 
		{
			a %= (Math.PI * -2);
			a += (Math.PI * 2);
		}
		
		return a;
	}
	
	public static double relativeAngle(double a)
	{
		while (a > Math.PI) a -= Math.PI * 2;
		while (a < -Math.PI) a += Math.PI * 2;
		
		return a;
	}	
	
	public static double getMaxForwardDistance(double someTime, double someVelocity)
	{
		double distance = 0;
		
		double timeToAccelerate = 8 - someVelocity;
		
		if (timeToAccelerate <= someTime) 
		{
			double timeAtConstantVelocity = someTime - timeToAccelerate;
			distance = ((((8 + someVelocity) / 2) * timeToAccelerate) + (timeAtConstantVelocity * 8));
		}
		
		else distance = ((someVelocity * someTime) + (.5 * (someTime * someTime))) ;
		
		return distance;
	}
	
	public static double getMaxPeriodicDisplacement(double someTime)
	{
		double distance = 0;
		
		if (someTime >= 12) distance = 32 + ((someTime - 12) * 8);
		else
		{
			distance = (.5 * Math.pow((someTime * .666), 2)) + ((someTime * .666) * (someTime *.666)) + (-1 * Math.pow((someTime * .333), 2));
		}
		
		return distance;
	}
	
	
	public static double getMaxReverseDistance(double someTime, double someVelocity)
	{
		double distance = 0;
		
		double timeToDecelerate = someVelocity / 2;
		double timeToAccelerate = 8;
		
		if (timeToDecelerate <= someTime) 
		{
			if (timeToAccelerate <= (someTime - timeToDecelerate))
			{
				double timeAtConstantVelocity = someTime - timeToDecelerate - timeToAccelerate;
				
				distance = (((someVelocity / 2) * timeToDecelerate) - 32 + (timeAtConstantVelocity * -8));		
			}
			
			else distance = (((someVelocity / 2) * timeToDecelerate) - (.5 * (someTime - timeToDecelerate) * (someTime - timeToDecelerate) ));
			
		}
		
		else distance = ((someVelocity * someTime) + (.5 * (-2 * someTime * someTime))) ;
		
		return distance;
	}
	
	public static double getMaxSideDisplacement(double someTime, double someVelocity)
	{
		double distance = 0;
		
		double turnRate = ((10 - (.75 * someVelocity)) * (Math.PI / 180));
		double timeToTurn = (Math.PI / 2) / turnRate;
		
		double radius = someVelocity / turnRate;
		
		if (timeToTurn <= someTime)
		{
			double timeAtPerpendicular = someTime - timeToTurn;
			distance = radius + (timeAtPerpendicular * 8);
		}
		
		else 
		{
			double theta = turnRate * someTime;
			double chord = 2 * radius * Math.sin(theta * 0.5);
			double y = Math.sin(theta) * radius;
			distance = Math.sqrt((chord * chord) - (y * y));
		}
		
		return distance;
	}
	
}