package hamilton;

public class PossibleAreaAiming extends StationaryAiming
{
	static public FiringSolution getSolution(AimingInfo someInfo)
	{
		Target currentTarget = someInfo.aimingTarget;
		Coordinate targetCoordinates = currentTarget.getCoordinates();
		
		double firepower = calculateFirepower(someInfo);
		double bulletVelocity = 20 - (3 * firepower);
		
		double oldForwardTimeOfFlight = someInfo.targetDistance / bulletVelocity;
		double oldReverseTimeOfFlight = oldForwardTimeOfFlight;
		double oldRightTimeOfFlight = oldForwardTimeOfFlight;
		double oldLeftTimeOfFlight = oldForwardTimeOfFlight;
			
		double maxForwardDisplacement = Calculator.getMaxForwardDistance(oldForwardTimeOfFlight, someInfo.targetVelocity);
		double maxReverseDisplacement = Calculator.getMaxReverseDistance(oldReverseTimeOfFlight, someInfo.targetVelocity);			
		double maxRightDisplacement = Calculator.getMaxSideDisplacement(oldRightTimeOfFlight, someInfo.targetVelocity);
		double maxLeftDisplacement = maxRightDisplacement;
	
		double headingToRight = Calculator.normalizeAngle(someInfo.targetHeading + (Math.PI / 2));
		double headingToLeft = Calculator.normalizeAngle(someInfo.targetHeading - (Math.PI / 2));	
			
		Coordinate maxForwardPosition = targetCoordinates.getCoordinates(someInfo.targetHeading, maxForwardDisplacement);
		Coordinate maxReversePosition = targetCoordinates.getCoordinates(someInfo.targetHeading, maxReverseDisplacement);
		Coordinate maxRightPosition = targetCoordinates.getCoordinates(headingToRight, maxRightDisplacement);
		Coordinate maxLeftPosition = targetCoordinates.getCoordinates(headingToLeft, maxLeftDisplacement);

		double forwardTimeOfFlight = someInfo.robotCoordinates.distanceFrom(maxForwardPosition) / bulletVelocity;
		double reverseTimeOfFlight = someInfo.robotCoordinates.distanceFrom(maxReversePosition) / bulletVelocity;
		double rightTimeOfFlight = someInfo.robotCoordinates.distanceFrom(maxRightPosition) / bulletVelocity;
		double leftTimeOfFlight = someInfo.robotCoordinates.distanceFrom(maxLeftPosition) / bulletVelocity;
			
		double error = Math.abs(oldForwardTimeOfFlight - forwardTimeOfFlight) + Math.abs(oldReverseTimeOfFlight - reverseTimeOfFlight) + Math.abs(oldRightTimeOfFlight - rightTimeOfFlight) + Math.abs(oldLeftTimeOfFlight - leftTimeOfFlight);
			
		oldForwardTimeOfFlight = forwardTimeOfFlight;
		oldReverseTimeOfFlight = reverseTimeOfFlight;
		oldRightTimeOfFlight = rightTimeOfFlight;
		oldLeftTimeOfFlight = leftTimeOfFlight;
			
		int count = 0;
			
		while (error > 1)
		{
			maxForwardDisplacement = Calculator.getMaxForwardDistance(oldForwardTimeOfFlight, someInfo.targetVelocity);
			maxReverseDisplacement = Calculator.getMaxReverseDistance(oldReverseTimeOfFlight, someInfo.targetVelocity);	
			maxRightDisplacement = Calculator.getMaxSideDisplacement(oldRightTimeOfFlight, someInfo.targetVelocity);
			maxLeftDisplacement = Calculator.getMaxSideDisplacement(oldLeftTimeOfFlight, someInfo.targetVelocity);
				
			maxForwardPosition = targetCoordinates.getCoordinates(someInfo.targetHeading, maxForwardDisplacement);
			maxReversePosition = targetCoordinates.getCoordinates(someInfo.targetHeading, maxReverseDisplacement);
			maxRightPosition = targetCoordinates.getCoordinates(headingToRight, maxRightDisplacement);
			maxLeftPosition = targetCoordinates.getCoordinates(headingToLeft, maxLeftDisplacement);

			forwardTimeOfFlight = someInfo.robotCoordinates.distanceFrom(maxForwardPosition) / bulletVelocity;
			reverseTimeOfFlight = someInfo.robotCoordinates.distanceFrom(maxReversePosition) / bulletVelocity;
			rightTimeOfFlight = someInfo.robotCoordinates.distanceFrom(maxRightPosition) / bulletVelocity;
			leftTimeOfFlight = someInfo.robotCoordinates.distanceFrom(maxLeftPosition) / bulletVelocity;
				
			error = Math.abs(oldForwardTimeOfFlight - forwardTimeOfFlight) + Math.abs(oldReverseTimeOfFlight - reverseTimeOfFlight) + Math.abs(oldRightTimeOfFlight - rightTimeOfFlight) + Math.abs(oldLeftTimeOfFlight - leftTimeOfFlight);
				
			oldForwardTimeOfFlight = forwardTimeOfFlight;
			oldReverseTimeOfFlight = reverseTimeOfFlight;
			oldRightTimeOfFlight = rightTimeOfFlight;
			oldLeftTimeOfFlight = leftTimeOfFlight;	
			
			count ++;
			// System.out.println("Iteration " + count);		
		}
			
		while (!maxForwardPosition.isOnField(someInfo.r.getBattleFieldWidth(), someInfo.r.getBattleFieldHeight()) )
		{
			maxForwardDisplacement *= .75;
			maxForwardPosition = targetCoordinates.getCoordinates(someInfo.targetHeading, maxForwardDisplacement);
			//System.out.println("Count = " + count + " " + maxForwardPosition.getX() + ", " + maxForwardPosition.getY());
		}	
			
		while (!maxReversePosition.isOnField(someInfo.r.getBattleFieldWidth(), someInfo.r.getBattleFieldHeight()) )
		{
			maxReverseDisplacement *= .75;
			maxReversePosition = targetCoordinates.getCoordinates(someInfo.targetHeading, maxReverseDisplacement);
			// System.out.println("Count = " + count + " " + maxReversePosition.getX() + ", " + maxReversePosition.getY());
		}
			
		while (!maxRightPosition.isOnField(someInfo.r.getBattleFieldWidth(), someInfo.r.getBattleFieldHeight()) )
		{
			maxRightDisplacement *= .75;
			maxRightPosition = targetCoordinates.getCoordinates(headingToRight, maxRightDisplacement);
			// System.out.println("Count = " + count + " " + maxReversePosition.getX() + ", " + maxReversePosition.getY());
		}	
		
		while (!maxLeftPosition.isOnField(someInfo.r.getBattleFieldWidth(), someInfo.r.getBattleFieldHeight()))
		{
			maxLeftDisplacement *= .75;
			maxLeftPosition = targetCoordinates.getCoordinates(headingToLeft, maxLeftDisplacement);
			// System.out.println("Count = " + count + " " + maxReversePosition.getX() + ", " + maxReversePosition.getY());
		}
			
		// System.out.print("Forward = " + maxForwardPosition.getX() + ", " + maxForwardPosition.getY());
		// System.out.print(", Reverse = " + maxReversePosition.getX() + ", " + maxReversePosition.getY());
		// System.out.print(", Right = " + maxRightPosition.getX() + ", " + maxRightPosition.getY());
		// System.out.println(", Left = " + maxLeftPosition.getX() + ", " + maxLeftPosition.getY());
			
		double[] angles = new double[4];
			
	
		angles[0] = someInfo.robotCoordinates.absoluteBearingTo(maxForwardPosition);
		angles[1] = someInfo.robotCoordinates.absoluteBearingTo(maxReversePosition);
		angles[2] = someInfo.robotCoordinates.absoluteBearingTo(maxRightPosition);
		angles[3] = someInfo.robotCoordinates.absoluteBearingTo(maxLeftPosition);
		
		double max = 0;
		double min = 0;
		double width = 0;
			
		for (int x = 0; x < angles.length; x ++)
		{
			for (int y = 0; y < angles.length; y ++)
			{
				double temp = Calculator.relativeAngle(angles[x] - angles[y]);

				if (temp > width)
				{
					width = temp;
					max = angles[x];
					min = angles[y];
				}
			}
		}
		
		double targetWidth = Math.atan(40 / someInfo.targetDistance);
		
		double ratio = targetWidth / width;
		
		double intitalTimeOfFlight = someInfo.targetDistance / bulletVelocity;
		
		// System.out.println(targetWidth + "," + width + "," + someInfo.targetDistance + "," + intitalTimeOfFlight);
		
		// System.out.println("AB = " + absoluteBearing + " Max = " + max + " Min = " + min + " Width = " + width);
		
		// System.out.println(initialTimeOfFlight + " = " + area + " , " + BurrMath.relativeAngle(max - min) + ", " + targetAngularWidth);	
				
		double randomOffset = Math.random() * width;			
					
		double bearing = Calculator.normalizeAngle(min + randomOffset);
		
		boolean validity = true;
		
		if (ratio > .16) validity = true;
		
		return new FiringSolution(bearing, firepower, validity);
	}
	
	static public double calculateFirepower(AimingInfo someInfo)
	{
		double energyFirepower = (someInfo.aimingTarget.getEnergy() / 4) + .1;
		
		double firepower = Math.min(energyFirepower, 3);
		
		double bulletVelocity = 20 - (3 * firepower);
		
		double timeOfFlight = someInfo.targetDistance / bulletVelocity;
		
		double ratio = 3.3674 * Math.pow(timeOfFlight, -.9598);
		
		while ((ratio < .16) && (firepower > .1))
		{
			firepower *= .9;
			bulletVelocity = 20 - (3 * firepower);
			timeOfFlight = someInfo.targetDistance / bulletVelocity;
			ratio = 3.3674 * Math.pow(timeOfFlight, -.9598);				
		}
		
		return firepower;
	}	
}
