/*
 * Class.java
 *
 * Created on April 7, 2002, 12:52 AM
 */

package tobe.util;

/**
 *
 * @author  tobe
 * @version 
 */
public class Delta {
                private BearingVector moved = new BearingVector();
                private double turned;
                
                public Delta(BearingVector previousPosition, BearingVector previousMovement,
                BearingVector position, BearingVector movement, double timeDifference) {
                    setDelta(previousPosition, previousMovement, position, movement, timeDifference);
                }
                
                public Delta(double startX, double startY, BearingVector previousMovement,
                BearingVector position, BearingVector movement, double timeDifference) {
                    setDelta(startX, startY, previousMovement, position, movement, timeDifference);
                }
                
                public Delta(BearingVector previousPosition, BearingVector previousMovement,
                double x, double y, double heading, double velocity, double timeDifference) {
                    setDelta(previousPosition, previousMovement, x, y, heading, velocity, timeDifference);
                }
                
                public void setDelta(BearingVector previousPosition, BearingVector previousMovement,
                BearingVector position, BearingVector movement, double timeDifference) {
                    moved.setPoints(position.getToX(), position.getToY(),
                    previousPosition.getToX(), previousPosition.getToY());
                    moved.setBearing(moved.getBearing() - previousMovement.getAbsoluteBearing());
                    moved.setDistance(moved.getDistance()/timeDifference);
                    turned = normalizeAngle(movement.getAbsoluteBearing() - previousMovement.getAbsoluteBearing());
                    turned /= timeDifference;
                }
                
                public void setDelta(double startX, double startY, BearingVector previousMovement,
                		BearingVector position, BearingVector movement, double timeDifference) {
                    moved.setPoints(position.getToX(), position.getToY(), startX, startY);
                    moved.setBearing(moved.getBearing() - previousMovement.getAbsoluteBearing());
                    moved.setDistance(moved.getDistance()/timeDifference);
                    turned = normalizeAngle(movement.getAbsoluteBearing() - previousMovement.getAbsoluteBearing());
                    turned /= timeDifference;
                }
                
                public void setDelta(BearingVector previousPosition, BearingVector previousMovement,
                double x, double y, double heading, double velocity, double timeDifference) {
                    moved.setPoints(x, y, previousPosition.getToX(), previousPosition.getToY());
                    moved.setBearing(moved.getBearing() - previousMovement.getAbsoluteBearing());
                    moved.setDistance(moved.getDistance()/timeDifference);
                    double absoluteHeading = heading;
                    if( velocity < 0) absoluteHeading += Math.PI;
                    turned = normalizeAngle(absoluteHeading - previousMovement.getAbsoluteBearing());
                    turned /= timeDifference;
                }
                
                public void applyTo(BearingVector position, BearingVector movement) {
                    position.add(movement.getAbsoluteBearing() + moved.getBearing(), moved.getDistance());
                    movement.setAbsoluteBearing(movement.getAbsoluteBearing() + turned);
                }
                
                public void applyToOrigin(BearingVector position, BearingVector movement) {
                    position.addToOrigin(movement.getAbsoluteBearing() + moved.getBearing(), moved.getDistance());
                    movement.setAbsoluteBearing(movement.getAbsoluteBearing() + turned);
                }
                
                /** Utility routine to take an angle in radians and returns its normal value between -PI and PI*/
                protected double normalizeAngle(double a) {
                    while(a>Math.PI) a-=2*Math.PI;
                    while(a<-Math.PI) a+=2*Math.PI;
                    return a;
                }

}
