package simonton.beta;

import java.awt.*;

import robocode.ScannedRobotEvent;
import simonton.core.*;
import simonton.guns.CheGun;
import simonton.guns.Gun;
import simonton.guns.HeadOnGun;
import simonton.guns.InBoundCircularGun;
import simonton.guns.InBoundLinearGun;
import simonton.guns.KomariousGun;
import simonton.guns.singleTick.*;
import simonton.movements.*;
import simonton.utils.Util;

public class LifelongObsession extends OneOnOneBot {

	@Override
	public Gun getGun() {
		// return new CompoundGun(100, new SingleTickGun(60, 2000, 18),
		// new SingleTickGun(60, 2000, 1));
		// return new SingleTickGun(60, 2000, 1); // unsegmented
		return new SingleTickGun(60, 200, 180); // segmented
		// return new TwoStageSingleTickGun(60, 20, 2000, 180, 15);
	}

	@Override
	protected double getNextBulletPower() {
		if (Util.enemyP != null) {
			return Math.min(Math.min(3, getEnergy() / 16), 900 / Util.myP
					.distance(Util.enemyP));
		}
		return 2;
	}

	@Override
	public Movement getMovement() {
		// return null;
		return new Surfer(
				16,
				19,
				Math.toRadians(45),
				Math.toRadians(20),
				800,
				122,
				20,
				1 // leave minDistance out for now
				// new KomariousFlattener());
				// new EnemyGunWaveMachine(new CheGun()));
				,new EnemyGunWaveMachine(new HeadOnGun(), 1, true)
				,new EnemyGunWaveMachine(new HeadOnGun(), 1, false)
				,new EnemyGunWaveMachine(new InBoundLinearGun(), 1, true),
				new EnemyGunWaveMachine(new InBoundCircularGun(), 1, true),
				new EnemyGunWaveMachine(new CheGun(), 1, true)
				// new EnemyGunWaveMachine(new KomariousGun(), .25),
				, new EnemyHitsWaveMachine(.9, 1)
		// ,new EnemyGunWaveMachine(new SingleTickGun(60, 2000, 1), 1)
		);
	}

	@Override
	public void run() {
		setColors(Color.BLACK, Color.BLACK, Color.RED);
		super.run();
	}
}
