/*
 * Created on Sep 9, 2004
 *
 */
package davidalves.net.gun.segmentation;

import davidalves.net.AdvancedTeamRobot;
import davidalves.net.util.RobotState;
import davidalves.net.util.Utils;

/*
 * Splits distance traveled into equally sized segments
 * 
 * @author David Alves
 *
 */
public class AttackAngleSegmentation extends LinearSegmentation {
	static final double QUARTER_CIRCLE = Math.PI / 2.0;
	
	public AttackAngleSegmentation(int segments){
		super(0.0, QUARTER_CIRCLE, false, false, segments);
	}

	protected double getValue(RobotState shooter, RobotState target, double bulletPower) {
		return Math.abs(QUARTER_CIRCLE - Math.abs(Utils.angularDifferenceBetween(shooter.absoluteAngleTo(target), target.heading)));
	}
	
}
