package dz;
import robocode.*;
import java.awt.geom.*;
import robocode.util.Utils;
//import java.awt.Color;

/**
 * OthoMini - a robot by Rational Insanity
 */
public class OthoMini extends AdvancedRobot
{
	static double move;
	static double enemyEnergy;
	static double bulletSpeed; //Speed of enemy's bullets.
	static double radarMove;
	static double eHeading; //Enemy's heading.
	static long lastMove; //Time of last movement.
	static double enemyCoolingTime;
	static boolean musashi = true;
	
	static int afterWall;
	
	// 0 is for velocity; 1 is for heading change; 2 is for relative heading; 3 is for distance.
	static double pattern [][];
	static int index = 0;
	
	public void run() {
		//setColors(Color.blue,Color.black,Color.yellow);
		lastMove = 0;
		afterWall = 0;
		radarMove = 0.785398; // =PI/4
		if(getRoundNum() == 0){
			pattern = new double[4000][4];
		}

		while(true) {
			afterWall++;
			turnRadarRightRadians(radarMove);
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		
		//Rectangle2D.Double field = new Rectangle2D.Double(18, 18, getBattleFieldWidth() - 36, getBattleFieldHeight() - 36);
		Rectangle2D.Double field = new Rectangle2D.Double(18, 18, 764, 564);
		
		double eDist; //Distance to enemy.
		
		//////////  Movement  //////////////
		double myVelocity;
		move -= (myVelocity = getVelocity());
		
		double energyDrop = enemyEnergy - (enemyEnergy = e.getEnergy());
		
		if(energyDrop < -9 && musashi){
			setAhead(move = 100000000); // 10^8
		}
		
		boolean enemyFired = false;
		
		if(energyDrop <= 3 && energyDrop >= 0.1){
			enemyFired = true;
			bulletSpeed = 20 - 3*energyDrop;
			enemyCoolingTime = 10 + (2 * energyDrop);
		}
		
		//Period of my movement.
		double period = 0.9 * (eDist = e.getDistance())/bulletSpeed;
		double moveFactor = Math.random()*2 - 1 + (myVelocity/60);
		if(!musashi && ((period > enemyCoolingTime && (lastMove + period) <= getTime()) || (period < enemyCoolingTime && enemyFired))){
		//if(getTime() >= (lastMove + period)){
			//move = (moveFactor/((period < (10 - 2* energyChange)) ? Math.pow(Math.abs(moveFactor),0.3) : 1))*period * 9;
			//Do move.
			setAhead(move = (moveFactor/Math.pow(Math.abs(moveFactor),0.3))*period * 9);
			lastMove = getTime();
		}
		
		//Wall avoidance.
		double advanceAngle = 0;
		//int advanceAngle = (getEnergy()/((enemyEnergy = e.getEnergy())+0.1) >= 3)? 15 : 0;
		//int advanceAngle = (getEnergy()/((enemyEnergy = e.getEnergy())+0.1) >= 3)? 15 : (eDist < 400? -3:0); //Backs away slightly if too close to enemy.
		int direction = myVelocity > 0? 1:-1;
		for(int dist = 160; dist > 0 && myVelocity != 0; dist -= 20){
			//Wall avoidance - approximate future position.
			//double wallX = getX() + direction*dist*Math.sin(getHeadingRadians());
			//double wallY = getY() + direction*dist*Math.cos(getHeadingRadians());
			if(!field.contains(getX() + direction*dist*Math.sin(getHeadingRadians()), getY() + direction*dist*Math.cos(getHeadingRadians()))){
				//Turn towards opponent if approaching wall.
				advanceAngle = 3.5/Math.sqrt(dist);
				if(dist <= 40){
					setBack(direction*Math.abs(move));
					afterWall = 0;
				}
			}
		}
		
		setTurnLeftRadians(Utils.normalRelativeAngle(1.5708 - e.getBearingRadians() - direction * advanceAngle));
		
		//////////  Aiming  /////////////
		
		//Record data.
		//Record velocity and heading change in pattern array.
		//tempVelocity is initial velocity of virtual enemy.
		pattern[index%4000][0] = e.getVelocity();
		pattern[(index++)%4000][1] = Utils.normalRelativeAngle((e.getHeadingRadians()) - eHeading);
		
		double myEnergy;

		double power = Math.min(3,(Math.min((myEnergy = getEnergy()),enemyEnergy)/4));
		
		double myX, myY, myHeading;
		double headingToEnemy;
		//Initial position of virtual enemy.
		double x = (myX = getX()) + eDist * Math.sin((headingToEnemy = (e.getBearingRadians() + (myHeading = getHeadingRadians() )))); //Head-on targeting.
		double y = (myY = getY()) + eDist * Math.cos(headingToEnemy);
		
		pattern[index%4000][2] = (eHeading = e.getHeadingRadians()) - headingToEnemy; //Record enemy's heading relative to me.
		pattern[index%4000][3] = Math.sqrt(eDist);
		
		//Turn radar.
		radarMove = Utils.normalRelativeAngle(headingToEnemy - getRadarHeadingRadians());
		radarMove += (radarMove >= 0)? 0.3927 : -0.3927; // =PI/8
		
		int timeToTarget = (int)(eDist/(20 - (3 * power)));
		
		//Only use patter matcher if there is sufficient data, the gun is cool, and the enemy is not disabled.
		if(index > 120 && getGunHeat() <= 0.3 && enemyEnergy > 0){
			//Match the pattern.
			double bestErrors[] = new double [20];
			int bestIndices[] = new int[20];
			for(int c = 0; c < 20; c++){
				bestErrors[c] = 1000000;
			}
			int offset = (index < 4000)? 0 : index;
			int patternLength = (int)(Math.pow(eDist,0.4) + 10);
			int numBest = (int)(Math.min(index,4000)/200);
			for(int c = (Math.min(index,4000) - timeToTarget + offset); c >= (patternLength + offset); c--){
				double relativeHeadingDiff = Math.abs(Utils.normalRelativeAngle(pattern[c%4000][2] - pattern[index%4000][2]));
				double currentError = Math.min(relativeHeadingDiff, Math.PI - relativeHeadingDiff) + Math.abs(pattern[c%4000][3] - Math.sqrt(eDist))/5;
				//Calculate error.
				for(int d = 0; d < patternLength; d += 2){
					currentError += (Math.abs(pattern[(c - d)%4000][0] - pattern[(index-d)%4000][0]) + 50*Math.abs(pattern[(c - d)%4000][1] - pattern[(index-d)%4000][1]))/((d/2)+2);
				}
				for(int i = 0; i < 20; i++){
					if(currentError < bestErrors[i]){
						for(int j = 19; j > i; j--){
							bestErrors[j] = bestErrors[j-1];
							bestIndices[j] = bestIndices[j-1];
						}
						bestErrors[i] = currentError;
						bestIndices[i] = c;
						break;
					}
				}
			}
			
			//Calculate enemy's future position.
			
			double targetHeadings[] = new double[20];
			int goodIndices[] = new int[20];
			for(int i = 0; i < 20; i++){
				goodIndices[i] = i;
				double tempX = x;
				double tempY = y;
				//tempHeading is initial heading of virtual enemy.
				double tempHeading = eHeading;
				double tempVelocity = e.getVelocity();
				for(int c = 0; c < timeToTarget; c++){
					tempX += tempVelocity*Math.sin(tempHeading);
					tempY += tempVelocity*Math.cos(tempHeading);
					tempVelocity = pattern[(bestIndices[i]+c)%4000][0];
					tempHeading += pattern[(bestIndices[i]+c)%4000][1];
					//Improves accuracy against bots that vary their distance to their opponent.
					timeToTarget = (int)(Math.sqrt(Math.pow((tempY - myY),2) + Math.pow((tempX - myX),2))/(20 - 3*power));
				}
				targetHeadings[i] = Math.atan((tempX - myX)/(tempY - myY)) + ((tempY < myY)? Math.PI:0);
			}
			//
			for(int c = numBest; c >= 4; c--){
				//Calculate average gun turn;
				double avgGunTurn = 0;
				double worstDeviation = 0;
				int worstIndex = 0;
				for(int j = 0; j < 2; j++){
					for(int d = 0; d < c; d++){
						double gunTurn = Utils.normalRelativeAngle(targetHeadings[goodIndices[d]] - headingToEnemy);
						if(j == 0){
							avgGunTurn = ((avgGunTurn * d)+gunTurn)/(d+1);
						}
						else{
							double deviation = Math.abs(avgGunTurn - gunTurn); // * Math.sqrt(bestErrors[goodIndices[d]] + 4);
							if(deviation > worstDeviation){
								worstDeviation = deviation;
								worstIndex = d;
							}
						}
					}
				}
				goodIndices[worstIndex] = goodIndices[c-1];
			}
			int lowestIndex = 20;
			for(int c = 0; c < 3; c++){
				if(goodIndices[c] < lowestIndex){
					lowestIndex = goodIndices[c];
				}
			}
			headingToEnemy = targetHeadings[lowestIndex];
			//out.println("Selected index: "+lowestIndex+" Error: "+bestErrors[lowestIndex]);
		}
		//Turn gun.
		setTurnGunRightRadians(Utils.normalRelativeAngle(headingToEnemy - getGunHeadingRadians()));
		//Fire.
		if(myEnergy >= 0.4 || enemyEnergy == 0){
			setFire(power);
		}
	}
	
	public void onHitByBullet(HitByBulletEvent e){
		if(afterWall > 23){
			musashi = false;
		}
	}
}
