package Krabb.sliNk;
import java.io.*;
import robocode.*;
import java.util.*;

class Data extends TeamRobot
{
	static HashMap enemies =  new HashMap();
	static HashMap mates =  new HashMap();
	public void run()
	{
		super.run();
		if(getRoundNum()==0)
			return;
		Collection c = mates.values();
		for(Iterator i=c.iterator(); i.hasNext();)
		{
			((Mate)i.next()).run();
		}
		c = enemies.values();
		for(Iterator i=c.iterator(); i.hasNext();)
		{
			((Enemy)i.next()).run();
		}			
	}
	
	protected void step()
	{
//		super.step();
		if(getTime()==0)
			newMateStats(new Stats(this,null));
		else
			newMateStats(new Stats(this,getMate(getName()).getStats(0)));
		Collection c = mates.values();
		for(Iterator i=c.iterator(); i.hasNext();)
		{
			((Mate)i.next()).step(this);
		}
	}		
	
	protected void newEnemyStats(Stats s)
	{
		if(!enemies.containsKey(s.getName()))
			newEnemy(s.getName());
		Enemy en = (Enemy)enemies.get(s.getName());
		en.newStats(s);	
	}
	
	protected void newMateStats(Stats s)
	{
		if(!mates.containsKey(s.getName()))
			newMate(s.getName());
		Mate ma = (Mate)mates.get(s.getName());
		ma.newStats(s);	
	}
	
	protected void newMateBullet(MyBullet b)
	{
		if(!mates.containsKey(b.getName()))
		{
			System.out.println("no mate with name "+b.getName()+ "(BUllet)");
			return;
		}
		Mate ma = (Mate)mates.get(b.getName());
		ma.newBullet(b);	
	}
	
	public Bullet setFireBullet(double p)
	{
		Bullet b = super.setFireBullet(p);
		if(b!=null)
		{
			Mate ma = (Mate)mates.get(getName());
			ma.newBullet(new MyOwnBullet(b,this));
		}
		return b;
	}
	
	public void printStats()
	{
		Global.self.printStats();
	}
	
	public void onScannedRobot(ScannedRobotEvent e)
	{
		if(!isTeammate(e.getName()))
		{
			if(!enemies.containsKey(e.getName()))
				newEnemy(e.getName());
			Enemy en = (Enemy)enemies.get(e.getName());
			en.newScan(e,this);
		}
		else
		{
			if(!mates.containsKey(e.getName()))
				newEnemy(e.getName());
			Mate ma = (Mate)mates.get(e.getName());
			ma.newScan(e,this);
		}
	}
	

	public void onPaint(java.awt.Graphics2D g)
	{
		super.onPaint(g);
		Collection c = enemies.values();
		g.drawRect(1,0,(int)getBattleFieldWidth()-2,(int)getBattleFieldHeight());
		for(Iterator i=c.iterator(); i.hasNext();)
		{
			((Enemy)i.next()).onPaint(g,this);
		}
		c = mates.values();
		for(Iterator i=c.iterator(); i.hasNext();)
		{
			((Mate)i.next()).onPaint(g,this);
		}
	}
	
	public void onRobotDeath(RobotDeathEvent ev)
	{
		Enemy e = (Enemy)enemies.get(ev.getName());
		if(e!=null)
			e.death();
		Mate m = (Mate)mates.get(ev.getName());
		if(m!=null)
			m.death();
	}
	
	public void onHitByBullet(HitByBulletEvent ev)
	{
		super.onHitByBullet(ev);
		
//		System.out.println("onHitByBullet(HitByBulletEvent ev)");
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e)
	{
		super.onBulletHitBullet(e);
		Global.self.onBulletHitBullet(e,this);
//		System.out.println("onBulletHitBullet(BulletHitBulletEvent e)!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!11");
	}
	
	public void onBulletHit(BulletHitEvent e)
	{
//		super.onBulletHitBullet(e);
		Global.self.onBulletHit(this,e);
//		System.out.println("onBulletHit(BulletHitEvent e)");
	}
	
	public void onBulletMissed(BulletMissedEvent e)
	{
//		super.onBulletHitBullet(e);
		Global.self.onBulletMissed(e);
//		System.out.println("onBulletMissed(BulletMissedEvent e)");
		
	}
	
	protected Mate getMate(String name){
		return (Mate)mates.get(name);}
	protected Enemy getEnemy(String name){
		return (Enemy)enemies.get(name);}
	protected Mate getMate(int n){
		return (Mate)mates.values().toArray()[n];}
	protected Enemy getEnemy(int n){
		return (Enemy)enemies.values().toArray()[n];}
	protected int getEnemiesSize(){
		return enemies.size();}
	protected int getMatesSize(){
		return mates.size();}
											
	private void newEnemy(String name){
//		System.out.println(getTime()+" new Enemy: "+name);
		enemies.put(name,new Enemy());}

	private void newMate(String name){
		System.out.println(getTime()+" new Mate: "+name);
		mates.put(name,new Mate());
		if(getName().equals(name))
			Global.self=getMate(getName());}
		
}
